#!/bin/bash

# Set Bash color
ECHO_PREFIX_INFO="\033[1;32;40mINFO...\033[0;0m"
ECHO_PREFIX_ERROR="\033[1;31;40mError...\033[0;0m"

# Try command  for test command result.
function try_command {
    "$@"
    status=$?
    if [ $status -ne 0 ]; then
        echo -e $ECHO_PREFIX_ERROR "ERROR with \"$@\", Return status $status."
        exit $status
    fi
    return $status
}

try_command lsb_release -si > /dev/null

# dectect OS version
LINUX_DISTRO=`lsb_release -si`

if [ "$LINUX_DISTRO" == "SUSE LINUX" ]; then
    LINUX_DISTRO="SuSE"
else if [ "$LINUX_DISTRO" == "Ubuntu" ]; then
    LINUX_DISTRO="Ubuntu"
else
    echo -e $ECHO_PREFIX_ERROR "You are about to install on a non supported linux distribution.\n"
fi
fi
echo -e $ECHO_PREFIX_INFO "Install on $LINUX_DISTRO ..."

#detect system arch.
SYSARCH=64
ULONG_MASK=`getconf ULONG_MAX`
if [ $ULONG_MASK == 18446744073709551615 ]; then
    SYSARCH=64
    UBUNTU_LIB_INSTALL_PATH=/usr/lib/x86_64-linux-gnu/
    SUSE_LIB_INSTALL_PATH=/usr/lib64/
else
    SYSARCH=32
    UBUNTU_LIB_INSTALL_PATH=/usr/lib/i386-linux-gnu/
    SUSE_LIB_INSTALL_PATH=/usr/lib/
fi

#set driver install path
if [ $LINUX_DISTRO == "SuSE" ];then
    DRIVER_INSTALL_PATH=$SUSE_LIB_INSTALL_PATH/dri
else
    DRIVER_INSTALL_PATH=$UBUNTU_LIB_INSTALL_PATH/dri
fi



if [ -f /proc/cpuinfo ]; then
    CPU_MODEL=`grep -m 1 "model name" /proc/cpuinfo | cut -d: -f2 | sed -e 's/^ *//' | sed -e 's/$//'`
    if [[ $CPU_MODEL == *E3* ]]; then
        XEON_MODEL="E3"
    else
        XEON_MODEL="Other"
    fi
fi


if [ ! -d usr/lib/ ] && [ ! -d usr/lib64 ]; then
    echo -e $ECHO_PREFIX_ERROR "Cannot find installation content directory!"
    exit 1
fi


# This script must be run as root
if [[ $EUID -ne 0 ]]; then
    echo -e $ECHO_PREFIX_ERROR "This script must be run as root!" 1>&2
    exit 1
fi

if [ -d usr/include/va ]; then
    try_command rm -f /usr/lib/libva* 
    try_command rm -f /usr/local/lib/libva*
    try_command rm -f $DRIVER_INSTALL_PATH/../libva*
fi
if [ -d usr/include/libdrm ]; then
    try_command rm -f $DRIVER_INSTALL_PATH/../libdrm*
fi
try_command rm -f /usr/lib/dri/iHD* 
try_command rm -f /usr/local/lib/dri/iHD* 
try_command rm -f $DRIVER_INSTALL_PATH/iHD*

echo -e $ECHO_PREFIX_INFO "Installing New Driver..."
try_command cp -dfr usr/* /usr/

# Install MSDK
DEVICEID=`lspci -nn | grep VGA | grep Intel | cut -d: -f 4 | cut -d']' -f 1`
MEDIASDK_OUTPUT="/opt/intel"
MEDIASDK_INSTALL_DIR="$MEDIASDK_OUTPUT/mediasdk"
if [ "$DEVICEID" != "" ]; then
    try_command mkdir -p $MEDIASDK_OUTPUT
    try_command mkdir -p $MEDIASDK_INSTALL_DIR/lib64/8086/$DEVICEID/
    try_command cp -dfr lib/* $MEDIASDK_INSTALL_DIR/lib64/8086/$DEVICEID/
    echo -e $ECHO_PREFIX_INFO "MediaSDK shared library installed successfully in $MEDIASDK_INSTALL_DIR/lib64/8086/$DEVICEID/"
else
    echo -e $ECHO_PREFIX_ERROR "Cannot get Device id, please follow the release notes of MSDK and install them manually!"
fi

# Install KMD
TIME=$(date "+%Y-%m-%d_%H%M%S")
KERNEL_VER=`uname -r`
KMD_KO=kmd/binary/
KMD_SRC="kmd/source/"
KMD_INSTALL_DIR=/lib/modules/$KERNEL_VER/kernel/drivers/gpu/drm/i915/
KMD_DRM_INSTALL_DIR=/lib/modules/$KERNEL_VER/kernel/drivers/gpu/drm/
KMD_BACKUP_DIR=kmd_backup
RUNNING_SYMBOL=/lib/modules/$KERNEL_VER/build/Module.symvers

# Try command  for test command result.
function compile_kmd {
    kmd_src=0
    kmd_src=(`find $KMD_SRC -name "*.bz2"`)
    num_src=${#kmd_src[*]} 

    if [ $num_src -eq 0 ]; then
        echo -e $ECHO_PREFIX_ERROR "KMD source not find!"
        return 1
    fi

    if [ $num_src -gt 1 ];then
        echo -e $ECHO_PREFIX_INFO "Find multi kmd source in the release package:" 
        for (( var=0; var<$num_src; var++ ))
        do
            echo -e $ECHO_PREFIX_INFO "[$var]: ${kmd_src[$var]}"
        done
        read -p "please input the index which is align with your platform: " index
        if [ $index -ge $num_src ] || [ $index -lt 0 ]; then
            echo -e $ECHO_PREFIX_ERROR "Invalid input, process abort. "
            exit
        else
            ko_src=${kmd_src[$index]}
        fi
    else
        ko_src=${kmd_src[0]}
    fi

    KMD_HEADER="/usr/src/linux-headers-$KERNEL_VER"

    if [ ! -d $KMD_HEADER ]; then
        echo -e $ECHO_PREFIX_ERROR "Can not find header files of running kernel, please apt-get linux-header-$KERNEL_VER"
        return 1
    fi

    rm -fr /tmp/kmd/
    mkdir -p /tmp/kmd/ 
    tar -xvf $ko_src -C /tmp/kmd/
    pushd /tmp/kmd/drivers/gpu/drm/i915/
    try_command make -f makefile.i915 patch KERNEL_DIR=$KMD_HEADER
    try_command make -f makefile.i915 kmd KERNEL_DIR=$KMD_HEADER
    popd
    try_command cp /tmp/kmd/drivers/gpu/drm/i915/i915.ko $KMD_INSTALL_DIR
    if [ -f /tmp/kmd/drivers/gpu/drm/drm.ko ]; then
        try_command cp /tmp/kmd/drivers/gpu/drm/drm.ko $KMD_DRM_INSTALL_DIR
    fi
    if [ -f /tmp/kmd/drivers/gpu/drm/drm_kms_helper.ko ]; then
        try_command cp /tmp/kmd/drivers/gpu/drm/drm_kms_helper.ko $KMD_DRM_INSTALL_DIR
    fi


    return 0
}

if [ -d $KMD_KO ];then
#    echo -e $ECHO_PREFIX_INFO "Do you want to install KMD?"
#    read -p "press 'y' to confirm, otherwise cancelled." install_kmd
install_kmd="y"
    if [ "$install_kmd" == "y" ]; then
        #backup original ko file.
        try_command mkdir -p "$PWD/$KMD_BACKUP_DIR"
        try_command cp -f "$KMD_INSTALL_DIR/i915.ko" "$PWD/$KMD_BACKUP_DIR/i915.ko.$TIME"
        echo -e $ECHO_PREFIX_INFO "Original i915.ko backuped in $KMD_BACKUP_DIR/i915.ko.$TIME"
        try_command cp -f "$KMD_DRM_INSTALL_DIR/drm.ko" "$PWD/$KMD_BACKUP_DIR/drm.ko.$TIME"
        echo -e $ECHO_PREFIX_INFO "Original drm.ko backuped in $KMD_BACKUP_DIR/drm.ko.$TIME"
        try_command cp -f "$KMD_DRM_INSTALL_DIR/drm_kms_helper.ko" "$PWD/$KMD_BACKUP_DIR/drm_kms_helper.ko.$TIME"
        echo -e $ECHO_PREFIX_INFO "Original drm_kms_helper.ko backuped in $KMD_BACKUP_DIR/drm_kms_helper.ko.$TIME"
        #install kmd to sles and ubuntu.
        if [ $LINUX_DISTRO == "SuSE" ]; then
            installed_kmd=0
            for ko_module in `find $KMD_KO -name "*.ko"`
            do
                #detect KMD symbol and running KERNEL symbol. 
                KMD_VER=`modinfo -F vermagic $ko_module | awk -v FS=" " '{print $1}'`
                echo -e $ECHO_PREFIX_INFO "Trying to install $KMD_VER kmd..."
                if [ $KMD_VER == $KERNEL_VER ]; then
                    #install ko.
                    ko_module_basename=`basename $ko_module`
                    if [ $ko_module_basename = "i915.ko" ]; then
                        try_command cp -f $ko_module $KMD_INSTALL_DIR
                    else
                        try_command cp -f $ko_module $KMD_DRM_INSTALL_DIR
                    fi
                    echo -e $ECHO_PREFIX_INFO "$ko_module installed successufully."
                    installed_kmd=1
                fi
            done
            if [ $installed_kmd = 1 ]; then
                echo -e $ECHO_PREFIX_INFO "After reboot, you can 'lsmod' to identify whether i915.ko drm.ko drm_kms_helper.ko loaded. if not, you have to rebuild kernel by yourself with patched files (kdm/source) in this package."
                try_command sed -i "0,/0/b;0,/1/{/0/s//1/}" /etc/modprobe.d/unsupported-modules
                try_command mkinitrd
            fi
        else if [ $LINUX_DISTRO == "Ubuntu" ]; then
                 #detect KMD symbol and running KERNEL symbol. 
                 installed_kmd=0
                 if [ ! -f $RUNNING_SYMBOL ]; then
                     echo -e $ECHO_PREFIX_ERROR "Missing Running Module Symbol file "$RUNNING_SYMBOL
                     echo -e $ECHO_PREFIX_ERROR "Please apt-get install linux-headers-$KERNEL_VER, and re-run the installation script!"
                     exit 1
                 fi
                 for module_symbol in `find ./kmd/binary/ -name "Module.symvers"`
                 do
                     echo -e $ECHO_PREFIX_INFO "Trying to install $KMD_VER kmd..."
                     KO_PATH=`dirname $module_symbol`/i915.ko
                     KO_DRM_PATH=`dirname $module_symbol`/drm.ko
                     KO_DRM_HELP_PATH=`dirname $module_symbol`/drm_kms_helper.ko
                     KMD_VER=`modinfo -F vermagic $KO_PATH | awk -v FS=" " '{print $1}'`
                     cmp -s $module_symbol $RUNNING_SYMBOL
                     if [ $? -eq 0 ]; then
                         #install ko.
                         try_command cp -f $KO_PATH $KMD_INSTALL_DIR
                         echo -e $ECHO_PREFIX_INFO "$KO_PATH installed successufully."
                         if [ -f $KO_DRM_PATH ]; then
                             try_command cp -f $KO_DRM_PATH $KMD_DRM_INSTALL_DIR
                             echo -e $ECHO_PREFIX_INFO "$KO_DRM_PATH installed successufully."
                         fi
                         if [ -f $KO_DRM_HELP_PATH ]; then
                             try_command cp -f $KO_DRM_HELP_PATH $KMD_DRM_INSTALL_DIR
                             echo -e $ECHO_PREFIX_INFO "$KO_DRM_HELP_PATH installed successufully."
                         fi
                         echo -e $ECHO_PREFIX_INFO "After reboot, you can 'lsmod' to identify whether i915.ko drm.ko drm_kms_helper.ko loaded. if not, you have to rebuild kernel by yourself with patched files (kdm/source) in this package."
                         installed_kmd=1
                         break
                     fi
                     if [ $XEON_MODEL = "E3" ]; then
                         echo -e $ECHO_PREFIX_INFO "For XEON E3: please confirm your libdrm version >= 2.4.37, xf86-video-intel version >= 2.20.0."
                     fi
                done
#
# no binary KMD, trying to compile
#
                if [ $installed_kmd != 1 ]; then
                    compile_kmd
                    if [ $? -eq 0 ]; then
                        installed_kmd=1
                    fi
                fi
#
# if the old initrd has already included drm/i915, new modules will not be loaded.
# need update initrd.
#
                if [ $installed_kmd = 1 ]; then
                    update-initramfs -u -k $KERNEL_VER
                fi
            fi
        fi
        if [ $installed_kmd == 1 ]; then
            echo -e $ECHO_PREFIX_INFO "Kernel module updated successfully!"
        else
            echo -e $ECHO_PREFIX_ERROR "Kernel module updated failed, due to mismatched kernel $KERNEL_VER with pre-build KMD. You have to rebuild kernel with patched files (kmd/source) manually."
        fi
    else
        echo -e $ECHO_PREFIX_INFO "i915.ko installation cancelled!"
    fi
fi

echo -e $ECHO_PREFIX_INFO "Package installation Done."
