/*
 * Decompiled with CFR 0.152.
 */
package com.wowza.wms.plugin.bwcheck;

import com.wowza.util.IOPerformanceCounter;
import com.wowza.wms.amf.AMFData;
import com.wowza.wms.amf.AMFDataArray;
import com.wowza.wms.amf.AMFDataItem;
import com.wowza.wms.amf.AMFDataList;
import com.wowza.wms.client.IClient;
import com.wowza.wms.module.IModuleCallResult;
import com.wowza.wms.module.ModuleBase;
import com.wowza.wms.request.RequestFunction;
import java.util.ArrayList;
import java.util.List;

public class ModuleBWCheck
extends ModuleBase {
    public static void onConnect(IClient iClient, RequestFunction requestFunction, AMFDataList aMFDataList) {
        boolean bl = aMFDataList.getBoolean(3);
        ModuleBWCheck.getLogger().info("onConnect: " + bl);
        if (bl) {
            ModuleBWCheck.calculateClientBw(iClient);
        } else {
            iClient.call("onBWDone", null, new Object[0]);
        }
    }

    public static void checkBandwidth(IClient iClient, RequestFunction requestFunction, AMFDataList aMFDataList) {
        ModuleBWCheck.getLogger().info("checkBandwidth");
        ModuleBWCheck.calculateClientBw(iClient);
    }

    private static void calculateClientBw(IClient iClient) {
        ModuleBWCheck.getLogger().info("calculateClientBw");
        AMFDataArray aMFDataArray = new AMFDataArray();
        for (int i = 0; i < 1200; ++i) {
            aMFDataArray.add((AMFData)new AMFDataItem(Math.random()));
        }
        iClient.getProperties().put((Object)"payload", (Object)aMFDataArray);
        AMFDataArray aMFDataArray2 = new AMFDataArray();
        for (int i = 0; i < 12000; ++i) {
            aMFDataArray2.add((AMFData)new AMFDataItem(Math.random()));
        }
        iClient.getProperties().put((Object)"payload_1", (Object)aMFDataArray2);
        AMFDataArray aMFDataArray3 = new AMFDataArray();
        for (int i = 0; i < 120000; ++i) {
            aMFDataArray3.add((AMFData)new AMFDataItem(Math.random()));
        }
        iClient.getProperties().put((Object)"payload_2", (Object)aMFDataArray3);
        Object var4_7 = null;
        final IOPerformanceCounter iOPerformanceCounter = iClient.getTotalIOPerformanceCounter();
        final Long l = new Long(System.nanoTime() / 1000000L);
        ModuleBWCheck.getLogger().info("ResultObj");
        /*
         * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
         */
        class ResultObj
        implements IModuleCallResult {
            IClient client = null;
            double latency = 0.0;
            double cumLatency = 1.0;
            int count = 0;
            int sent = 0;
            double kbitDown = 0.0;
            double deltaDown = 0.0;
            double deltaTime = 0.0;
            List<Long> pakSent = new ArrayList<Long>();
            List<Long> pakRecv = new ArrayList<Long>();
            List<Long> beginningValues = null;

            public ResultObj(IClient iClient) {
                this.client = iClient;
                this.beginningValues = new ArrayList<Long>();
                this.beginningValues.add(0, iOPerformanceCounter.getMessagesOutBytes());
                this.beginningValues.add(1, iOPerformanceCounter.getMessagesInBytes());
                this.beginningValues.add(2, l);
            }

            public void onResult(IClient iClient, RequestFunction requestFunction, AMFDataList aMFDataList) {
                Long l3 = new Long(System.nanoTime() / 1000000L);
                this.pakRecv.add(l3);
                Long l2 = l3 - this.beginningValues.get(2);
                ++this.count;
                if (this.count == 1) {
                    this.latency = Math.min(l2, 800L);
                    this.latency = Math.max(this.latency, 10.0);
                    this.pakSent.add(l3);
                    ++this.sent;
                    this.client.call("onBWCheck", (IModuleCallResult)this, new Object[]{this.client.getProperties().get((Object)"payload")});
                } else if (this.count > 1 && this.count < 3 && l2 < 1000L) {
                    this.pakSent.add(l3);
                    ++this.sent;
                    this.cumLatency += 1.0;
                    this.client.call("onBWCheck", (IModuleCallResult)this, new Object[]{this.client.getProperties().get((Object)"payload")});
                } else if (this.count >= 3 && this.count < 6 && l2 < 1000L) {
                    this.pakSent.add(l3);
                    ++this.sent;
                    this.cumLatency += 1.0;
                    this.client.call("onBWCheck", (IModuleCallResult)this, new Object[]{this.client.getProperties().get((Object)"payload_1")});
                } else if (this.count >= 6 && l2 < 1000L) {
                    this.pakSent.add(l3);
                    ++this.sent;
                    this.cumLatency += 1.0;
                    this.client.call("onBWCheck", (IModuleCallResult)this, new Object[]{this.client.getProperties().get((Object)"payload_2")});
                } else if (this.sent == this.count) {
                    if (this.latency >= 100.0 && this.pakRecv.get(1) - this.pakRecv.get(0) > 1000L) {
                        this.latency = 100.0;
                    }
                    this.client.getProperties().remove((Object)"payload");
                    this.client.getProperties().remove((Object)"payload_1");
                    this.client.getProperties().remove((Object)"payload_2");
                    IOPerformanceCounter iOPerformanceCounter2 = this.client.getTotalIOPerformanceCounter();
                    this.deltaDown = (iOPerformanceCounter2.getMessagesOutBytes() - this.beginningValues.get(0)) * 8L / 1000L;
                    this.deltaTime = ((double)(l3 - this.beginningValues.get(2)) - this.latency * this.cumLatency) / 1000.0;
                    if (this.deltaTime <= 0.0) {
                        this.deltaTime = (l3 - this.beginningValues.get(2)) / 1000L;
                    }
                    this.kbitDown = Math.round(this.deltaDown / this.deltaTime);
                    this.client.call("onBWDone", null, new Object[]{this.kbitDown, this.deltaDown, this.deltaTime, this.latency});
                }
            }
        }
        ResultObj resultObj = new ResultObj(iClient);
        resultObj.pakSent.add(l);
        ++resultObj.sent;
        iClient.call("onBWCheck", (IModuleCallResult)resultObj, new Object[]{""});
    }
}

