/*
 * Decompiled with CFR 0.152.
 */
package com.wowza.wms.plugin.bwcheck;

import com.wowza.util.IOPerformanceCounter;
import com.wowza.wms.amf.AMFData;
import com.wowza.wms.amf.AMFDataArray;
import com.wowza.wms.amf.AMFDataItem;
import com.wowza.wms.amf.AMFDataList;
import com.wowza.wms.amf.AMFDataObj;
import com.wowza.wms.application.IApplicationInstance;
import com.wowza.wms.application.WMSProperties;
import com.wowza.wms.client.IClient;
import com.wowza.wms.logging.WMSLoggerFactory;
import com.wowza.wms.module.IModuleCallResult;
import com.wowza.wms.module.ModuleBase;
import com.wowza.wms.plugin.bwcheck.ModuleBWCheck2;
import com.wowza.wms.request.RequestFunction;
import java.util.ArrayList;
import java.util.List;

public class ModuleBWCheck2
extends ModuleBase {
    private int bwCheckPayloadSize = 1800;
    private int bwCheckMaxLoops = 6;
    private long bwCheckMaxTime = 1000L;

    public void onAppStart(IApplicationInstance iApplicationInstance) {
        WMSProperties wMSProperties = iApplicationInstance.getProperties();
        if (wMSProperties != null) {
            this.bwCheckPayloadSize = wMSProperties.getPropertyInt("bwCheckPayloadSize", this.bwCheckPayloadSize);
            this.bwCheckMaxLoops = wMSProperties.getPropertyInt("bwCheckMaxLoops", this.bwCheckMaxLoops);
            this.bwCheckMaxTime = wMSProperties.getPropertyLong("bwCheckMaxTime", this.bwCheckMaxTime);
        }
        ModuleBWCheck2.getLogger().info("ModuleBWCheck2.onAppStart: bwCheckPayloadSize: " + this.bwCheckPayloadSize);
        ModuleBWCheck2.getLogger().info("ModuleBWCheck2.onAppStart: bwCheckMaxLoops: " + this.bwCheckMaxLoops);
        ModuleBWCheck2.getLogger().info("ModuleBWCheck2.onAppStart: bwCheckMaxTime: " + this.bwCheckMaxTime);
    }

    public void onConnect(IClient iClient, RequestFunction requestFunction, AMFDataList aMFDataList) {
        boolean bl = aMFDataList.getBoolean(3);
        if (bl) {
            this.calculateClientBw(iClient);
        } else {
            iClient.call("onBWDone", null, new Object[0]);
        }
    }

    public void checkBandwidth(IClient iClient, RequestFunction requestFunction, AMFDataList aMFDataList) {
        this.calculateClientBw(iClient);
    }

    private void calculateClientBw(IClient iClient) {
        final AMFDataArray aMFDataArray = new AMFDataArray();
        for (int i = 0; i < this.bwCheckPayloadSize; ++i) {
            aMFDataArray.add((AMFData)new AMFDataItem(Math.random()));
        }
        /*
         * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
         */
        class FirstResult
        implements IModuleCallResult {
            FirstResult() {
            }

            public void onResult(IClient iClient, RequestFunction requestFunction, AMFDataList aMFDataList) {
                /*
                 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
                 */
                class ResultObj
                implements IModuleCallResult {
                    IOPerformanceCounter totalStats;
                    long bytesOutStart;
                    double latency;
                    int cumLatency;
                    int count;
                    int sent;
                    double kbitDown;
                    double deltaDown;
                    double deltaTime;
                    long start;
                    List<Long> pakSent;
                    List<Long> pakRecv;
                    final /* synthetic */ AMFDataArray val$payload;
                    final /* synthetic */ ModuleBWCheck2 this$0;

                    public ResultObj(IClient iClient) {
                        this.this$0 = moduleBWCheck2;
                        this.val$payload = aMFDataArray;
                        this.latency = 0.0;
                        this.cumLatency = 1;
                        this.count = 0;
                        this.sent = 0;
                        this.kbitDown = 0.0;
                        this.deltaDown = 0.0;
                        this.deltaTime = 0.0;
                        this.start = 0L;
                        this.pakSent = new ArrayList<Long>();
                        this.pakRecv = new ArrayList<Long>();
                        this.totalStats = iClient.getTotalIOPerformanceCounter();
                    }

                    public void onResult(IClient iClient, RequestFunction requestFunction, AMFDataList aMFDataList) {
                        Long l = new Long(System.currentTimeMillis());
                        this.pakRecv.add(l);
                        if (this.count == 0) {
                            this.latency = l - this.pakSent.get(0);
                            this.latency = Math.min(this.latency, 800.0);
                            this.bytesOutStart = this.totalStats.getMessagesOutBytes();
                            this.start = System.currentTimeMillis();
                        }
                        Long l2 = l - this.start;
                        ++this.count;
                        if (this.count >= 1 && this.count <= ModuleBWCheck2.access$000(this.this$0) && l2 < ModuleBWCheck2.access$100(this.this$0)) {
                            this.pakSent.add(this.sent++, l);
                            ++this.cumLatency;
                            iClient.call("onBWCheck", (IModuleCallResult)this, new Object[]{this.val$payload});
                        } else if (this.sent == this.count) {
                            if (this.latency >= 100.0 && this.pakRecv.get(1) - this.pakRecv.get(0) > 1000L) {
                                this.latency = 100.0;
                            }
                            this.deltaDown = (double)((this.totalStats.getMessagesOutBytes() - this.bytesOutStart) * 8L) / 1000.0;
                            this.deltaTime = ((double)(l - this.start) - this.latency * (double)this.cumLatency) / 1000.0;
                            if (this.deltaTime <= 0.0) {
                                this.deltaTime = (double)(l - this.start) / 1000.0;
                            }
                            this.kbitDown = Math.round(this.deltaDown / this.deltaTime);
                            WMSLoggerFactory.getLogger(null).info("onBWDone: " + this.kbitDown);
                            iClient.call("onBWDone", null, new Object[]{this.kbitDown, this.deltaDown, this.deltaTime, this.latency});
                        }
                    }
                }
                ResultObj resultObj = new ResultObj(ModuleBWCheck2.this, iClient, aMFDataArray);
                long l = System.currentTimeMillis();
                resultObj.pakSent.add(resultObj.sent++, l);
                iClient.call("onBWCheck", (IModuleCallResult)resultObj, new Object[]{""});
            }
        }
        iClient.call("onBwCheck", (IModuleCallResult)new FirstResult(), new Object[]{aMFDataArray});
    }

    public void onClientBWCheck(IClient iClient, RequestFunction requestFunction, AMFDataList aMFDataList) {
        ModuleBWCheck2.getLogger().info("onClientBWCheck");
        AMFDataObj aMFDataObj = new AMFDataObj();
        IOPerformanceCounter iOPerformanceCounter = iClient.getTotalIOPerformanceCounter();
        aMFDataObj.put("cOutBytes", (AMFData)new AMFDataItem(iOPerformanceCounter.getMessagesInBytes()));
        aMFDataObj.put("cInBytes", (AMFData)new AMFDataItem(iOPerformanceCounter.getMessagesOutBytes()));
        aMFDataObj.put("time", (AMFData)new AMFDataItem(aMFDataList.getLong(3)));
        ModuleBWCheck2.sendResult((IClient)iClient, (AMFDataList)aMFDataList, (AMFData)aMFDataObj);
    }

    static /* synthetic */ int access$000(ModuleBWCheck2 moduleBWCheck2) {
        return moduleBWCheck2.bwCheckMaxLoops;
    }

    static /* synthetic */ long access$100(ModuleBWCheck2 moduleBWCheck2) {
        return moduleBWCheck2.bwCheckMaxTime;
    }
}

