/*
 * Decompiled with CFR 0.152.
 */
package com.wowza.wms.plugin.closedcaption.live;

import com.wowza.util.StringUtils;
import com.wowza.wms.logging.WMSLoggerFactory;
import com.wowza.wms.stream.IMediaStream;
import com.wowza.wms.timedtext.cea608.CEA608XDSUtils;
import com.wowza.wms.timedtext.cea608.ICEA608CaptionListener;
import com.wowza.wms.timedtext.cea608.ICEA608Decoder;
import com.wowza.wms.timedtext.cea608.XDSCommand;
import com.wowza.wms.timedtext.model.TimedTextEntry;
import java.util.ArrayList;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class CEA608CaptionLogger
implements ICEA608CaptionListener {
    private static final String CLASSNAME = "CEA608CaptionLogger";
    private static final Class CLASS = CEA608CaptionLogger.class;
    private int maxCaptions = 100;
    private int maxXDSCaptions = 100;
    private int numCaptions = 0;
    private int numXDSCaptions = 0;
    private String fieldCtx = "";

    public CEA608CaptionLogger(String string) {
        this.fieldCtx = string;
    }

    public void onCaptionsAdded(ICEA608Decoder iCEA608Decoder, ArrayList<TimedTextEntry> arrayList) {
        IMediaStream iMediaStream = iCEA608Decoder.getStream();
        String string = iMediaStream == null ? "" : iMediaStream.getContextStr();
        for (TimedTextEntry timedTextEntry : arrayList) {
            try {
                if (timedTextEntry == null) continue;
                String string2 = timedTextEntry.getText();
                if (StringUtils.isEmpty((String)string2)) {
                    string2 = "";
                }
                String string3 = string2.replaceAll("\n", "|");
                if (this.maxCaptions <= 0 || this.numCaptions < this.maxCaptions) {
                    WMSLoggerFactory.getLogger((Class)CLASS).info(String.format("%s[%s] cea608: %s text:'%s'", "ModuleCCDetectLiveCaptions", string, this.fieldCtx, string3));
                }
                ++this.numCaptions;
            }
            catch (Exception exception) {
                WMSLoggerFactory.getLogger((Class)CLASS).warn("CEA608CaptionLogger.onCaptionsAdded", (Throwable)exception);
            }
        }
    }

    public void onXDSAdded(ICEA608Decoder iCEA608Decoder, ArrayList<XDSCommand> arrayList) {
        IMediaStream iMediaStream = iCEA608Decoder.getStream();
        String string = iMediaStream.getContextStr();
        for (XDSCommand xDSCommand : arrayList) {
            this.logXDSInfo(string, xDSCommand);
        }
    }

    private void logXDSInfo(String string, XDSCommand xDSCommand) {
        String string2 = xDSCommand.toString();
        switch (xDSCommand.getCommand() & 0x7F7F) {
            case 259: 
            case 272: 
            case 273: 
            case 274: 
            case 275: 
            case 276: 
            case 277: 
            case 278: 
            case 279: 
            case 771: 
            case 784: 
            case 785: 
            case 786: 
            case 787: 
            case 788: 
            case 789: 
            case 790: 
            case 791: 
            case 1281: 
            case 1282: 
            case 2306: {
                string2 = this.xdsPayloadToString(xDSCommand);
                break;
            }
            case 260: 
            case 772: {
                string2 = this.xdsProgramTypeToString(xDSCommand);
                break;
            }
            default: {
                string2 = this.xdsPayloadToBytes(xDSCommand);
            }
        }
        if (this.maxXDSCaptions <= 0 || this.numXDSCaptions < this.maxXDSCaptions) {
            WMSLoggerFactory.getLogger((Class)CLASS).info(String.format("%s[%s] xds: %s", "ModuleCCDetectLiveCaptions", string, string2));
        }
        ++this.numXDSCaptions;
    }

    private String xdsPayloadToString(XDSCommand xDSCommand) {
        String string = CEA608XDSUtils.getXDSCommandString((short)xDSCommand.getCommand());
        return string + ": '" + xDSCommand.getBytesAsString() + "'";
    }

    private String xdsPayloadToBytes(XDSCommand xDSCommand) {
        String string = CEA608XDSUtils.getXDSCommandString((short)xDSCommand.getCommand());
        ArrayList arrayList = xDSCommand.getBytes();
        if (arrayList.isEmpty()) {
            return string + ": []";
        }
        String string2 = string + ":[0x";
        for (Byte by : arrayList) {
            string2 = String.format("%s%02x", string2, by);
        }
        string2 = string2 + "]";
        return string2;
    }

    private String xdsProgramTypeToString(XDSCommand xDSCommand) {
        String string = CEA608XDSUtils.getXDSCommandString((short)xDSCommand.getCommand());
        ArrayList arrayList = xDSCommand.getBytes();
        if (arrayList.isEmpty()) {
            return string + ": []";
        }
        String string2 = string + ":[";
        for (Byte by : arrayList) {
            string2 = String.format("%s%s, ", string2, CEA608XDSUtils.getProgamTypeAsString((short)by.byteValue()));
        }
        string2 = string2 + "]";
        return string2;
    }

    public void setXDSMaximumCaptions(int n) {
        this.maxXDSCaptions = n;
    }

    public void setMaximumCaptions(int n) {
        this.maxCaptions = n;
    }
}

