/*
 * Decompiled with CFR 0.152.
 */
package com.wowza.wms.plugin.closedcaption.live;

import com.wowza.wms.application.IApplicationInstance;
import com.wowza.wms.application.WMSProperties;
import com.wowza.wms.module.ModuleBase;
import com.wowza.wms.module.ModuleItem;
import com.wowza.wms.module.ModuleList;
import com.wowza.wms.plugin.closedcaption.live.CEA608CaptionLogger;
import com.wowza.wms.plugin.closedcaption.live.OnCaptionInfoCaptionLogger;
import com.wowza.wms.plugin.closedcaption.live.OnTextDataCaptionLogger;
import com.wowza.wms.stream.IMediaStream;
import com.wowza.wms.stream.IMediaStreamCallback;
import com.wowza.wms.timedtext.cea608.CEA608LiveSEIMessageDecoder;
import com.wowza.wms.timedtext.cea608.ICEA608CaptionListener;
import java.util.Collection;

public class ModuleCCDetectLiveCaptions
extends ModuleBase {
    static final String MODULE_NAME = "ModuleCCDetectLiveCaptions";
    static final String[] CONFLICTING_MODULES = new String[]{"com.wowza.wms.timedtext.live.module.ModuleCEA608ToOnTextData", "com.wowza.wms.timedtext.live.module.ModuleOnTextDataToCEA608"};
    private IApplicationInstance appInstance = null;
    private boolean detectCEA608Field1 = true;
    private boolean detectCEA608Field2 = true;
    private boolean detectCEA608XDS = false;
    private boolean detectOnTextData = true;
    private boolean detectOnCaption = true;
    private int maxCEA608Captions = 100;
    private int maxOnTextDataCaptions = 100;
    private int maxOnCaptionCaptions = 100;
    private int maxCEA608XDSCaptions = 250;

    public void onAppStart(IApplicationInstance iApplicationInstance) {
        this.appInstance = iApplicationInstance;
        WMSProperties wMSProperties = iApplicationInstance.getProperties();
        this.detectCEA608Field1 = wMSProperties.getPropertyBoolean("ccDetectCEA608Field1", this.detectCEA608Field1);
        this.detectCEA608Field2 = wMSProperties.getPropertyBoolean("ccDetectCEA608Field2", this.detectCEA608Field2);
        this.detectCEA608XDS = wMSProperties.getPropertyBoolean("ccDetectCEA608XDS", this.detectCEA608XDS);
        this.detectOnTextData = wMSProperties.getPropertyBoolean("ccDetectOnTextData", this.detectOnTextData);
        this.detectOnCaption = wMSProperties.getPropertyBoolean("ccDetectOnCaption", this.detectOnCaption);
        this.maxCEA608Captions = wMSProperties.getPropertyInt("ccDetectCEA608Maximum", this.maxCEA608Captions);
        this.maxCEA608XDSCaptions = wMSProperties.getPropertyInt("ccDetectCEA608XDSMaximum", this.maxCEA608XDSCaptions);
        this.maxOnTextDataCaptions = wMSProperties.getPropertyInt("ccDetectOnTextDataMaximum", this.maxOnTextDataCaptions);
        this.maxOnCaptionCaptions = wMSProperties.getPropertyInt("ccDetectOnCaptionMaximum", this.maxOnCaptionCaptions);
        ModuleCCDetectLiveCaptions.getLogger().info("ModuleCCDetectLiveCaptions.onAppStart[" + iApplicationInstance.getContextStr() + "] ccDetectOnTextData          : " + this.detectOnTextData);
        ModuleCCDetectLiveCaptions.getLogger().info("ModuleCCDetectLiveCaptions.onAppStart[" + iApplicationInstance.getContextStr() + "] ccDetectOnCaption           : " + this.detectOnCaption);
        ModuleCCDetectLiveCaptions.getLogger().info("ModuleCCDetectLiveCaptions.onAppStart[" + iApplicationInstance.getContextStr() + "] ccDetectCEA608Field1        : " + this.detectCEA608Field1);
        ModuleCCDetectLiveCaptions.getLogger().info("ModuleCCDetectLiveCaptions.onAppStart[" + iApplicationInstance.getContextStr() + "] ccDetectCEA608Field2        : " + this.detectCEA608Field2);
        ModuleCCDetectLiveCaptions.getLogger().info("ModuleCCDetectLiveCaptions.onAppStart[" + iApplicationInstance.getContextStr() + "] ccDetectCEA608XDS           : " + this.detectCEA608XDS);
        ModuleCCDetectLiveCaptions.getLogger().info("ModuleCCDetectLiveCaptions.onAppStart[" + iApplicationInstance.getContextStr() + "] ccDetectOnTextDataMaximum   : " + this.maxOnTextDataCaptions);
        ModuleCCDetectLiveCaptions.getLogger().info("ModuleCCDetectLiveCaptions.onAppStart[" + iApplicationInstance.getContextStr() + "] ccDetectOnCaptionMaximum    : " + this.maxOnCaptionCaptions);
        ModuleCCDetectLiveCaptions.getLogger().info("ModuleCCDetectLiveCaptions.onAppStart[" + iApplicationInstance.getContextStr() + "] ccDetectCEA608Maximum       : " + this.maxCEA608Captions);
        ModuleCCDetectLiveCaptions.getLogger().info("ModuleCCDetectLiveCaptions.onAppStart[" + iApplicationInstance.getContextStr() + "] ccDetectCEA608XDSMaximum    : " + this.maxCEA608XDSCaptions);
        boolean bl = this.areOtherCaptionModulesEnabled();
    }

    private boolean areOtherCaptionModulesEnabled() {
        boolean bl = false;
        String string = this.appInstance.getTimedTextProperties().getPropertyStr("captionLiveIngestType", null);
        if (string != null) {
            bl = true;
            ModuleCCDetectLiveCaptions.getLogger().error("ModuleCCDetectLiveCaptions.onAppStart[" + this.appInstance.getContextStr() + "] TimedText Property '" + "captionLiveIngestType" + "' and Module '" + MODULE_NAME + "' likely interfere with one another.");
        }
        ModuleList moduleList = this.appInstance.getModuleList();
        Collection collection = moduleList.getModuleItems().values();
        for (Object v : collection) {
            if (!(v instanceof ModuleItem)) continue;
            ModuleItem moduleItem = (ModuleItem)v;
            String string2 = moduleItem.getBaseClass();
            for (String string3 : CONFLICTING_MODULES) {
                if (!string3.equals(string2)) continue;
                bl = true;
                ModuleCCDetectLiveCaptions.getLogger().error("ModuleCCDetectLiveCaptions.onAppStart[" + this.appInstance.getContextStr() + "] Module '" + string2 + "' and Module '" + MODULE_NAME + "' likely interfere with one another.");
            }
        }
        return bl;
    }

    public void onAppStop(IApplicationInstance iApplicationInstance) {
        ModuleCCDetectLiveCaptions.getLogger().info("ModuleCCDetectLiveCaptions.onAppStop[" + iApplicationInstance.getContextStr() + "]");
    }

    public void onStreamCreate(IMediaStream iMediaStream) {
        CEA608LiveSEIMessageDecoder cEA608LiveSEIMessageDecoder;
        CEA608CaptionLogger cEA608CaptionLogger;
        OnTextDataCaptionLogger onTextDataCaptionLogger = new OnTextDataCaptionLogger();
        onTextDataCaptionLogger.setMaximumCaptions(this.maxOnTextDataCaptions);
        iMediaStream.registerCallback("onTextData", (IMediaStreamCallback)onTextDataCaptionLogger);
        OnCaptionInfoCaptionLogger onCaptionInfoCaptionLogger = new OnCaptionInfoCaptionLogger();
        onCaptionInfoCaptionLogger.setMaximumCaptions(this.maxOnCaptionCaptions);
        iMediaStream.registerCallback("onCaption", (IMediaStreamCallback)onCaptionInfoCaptionLogger);
        iMediaStream.registerCallback("onCaptionInfo", (IMediaStreamCallback)onCaptionInfoCaptionLogger);
        if (this.detectCEA608Field1) {
            cEA608CaptionLogger = new CEA608CaptionLogger("field1");
            cEA608CaptionLogger.setMaximumCaptions(this.maxCEA608Captions);
            cEA608CaptionLogger.setXDSMaximumCaptions(this.maxCEA608XDSCaptions);
            cEA608LiveSEIMessageDecoder = new CEA608LiveSEIMessageDecoder(iMediaStream);
            cEA608LiveSEIMessageDecoder.setEnableField1(this.detectCEA608Field1);
            cEA608LiveSEIMessageDecoder.setEnableField2(false);
            cEA608LiveSEIMessageDecoder.setXDSParsingEnabled(false);
            cEA608LiveSEIMessageDecoder.addCaptionListener((ICEA608CaptionListener)cEA608CaptionLogger);
        }
        if (this.detectCEA608Field2 || this.detectCEA608XDS) {
            cEA608CaptionLogger = new CEA608CaptionLogger("field2");
            cEA608CaptionLogger.setMaximumCaptions(this.maxCEA608Captions);
            cEA608CaptionLogger.setXDSMaximumCaptions(this.maxCEA608XDSCaptions);
            cEA608LiveSEIMessageDecoder = new CEA608LiveSEIMessageDecoder(iMediaStream);
            cEA608LiveSEIMessageDecoder.setEnableField1(false);
            cEA608LiveSEIMessageDecoder.setEnableField2(this.detectCEA608Field2);
            cEA608LiveSEIMessageDecoder.setXDSParsingEnabled(this.detectCEA608XDS);
            cEA608LiveSEIMessageDecoder.addCaptionListener((ICEA608CaptionListener)cEA608CaptionLogger);
        }
    }
}

