/*
 * Decompiled with CFR 0.152.
 */
package com.wowza.wms.plugin.closedcaption.live;

import com.wowza.wms.amf.AMFData;
import com.wowza.wms.amf.AMFDataArray;
import com.wowza.wms.amf.AMFDataItem;
import com.wowza.wms.amf.AMFDataList;
import com.wowza.wms.amf.AMFDataObj;
import com.wowza.wms.logging.WMSLoggerFactory;
import com.wowza.wms.request.RequestFunction;
import com.wowza.wms.stream.IMediaStream;
import com.wowza.wms.stream.IMediaStreamCallback;

public class OnCaptionInfoCaptionLogger
implements IMediaStreamCallback {
    private static final String CLASSNAME = "OnCaptionInfoCaptionLogger";
    private static final Class CLASS = OnCaptionInfoCaptionLogger.class;
    private int maxCaptions = 100;
    private int numCaptions = 0;

    public void setMaximumCaptions(int n) {
        this.maxCaptions = n;
    }

    public void onCallback(IMediaStream iMediaStream, RequestFunction requestFunction, AMFDataList aMFDataList) {
        block0: {
            String string;
            String string2;
            block1: {
                String string3 = string2 = iMediaStream == null ? "" : iMediaStream.getContextStr();
                if (aMFDataList.size() <= 1 || aMFDataList.get(0).getType() != 2 && aMFDataList.get(1).getType() != 3) break block0;
                string = aMFDataList.getString(0);
                if (!string.equalsIgnoreCase("onCaptionInfo")) break block1;
                this.handleOnCaptionInfo(string2, aMFDataList);
                break block0;
            }
            if (!string.equalsIgnoreCase("onCaption")) break block0;
            this.handleOnCaption(string2, aMFDataList);
        }
    }

    private void handleOnCaption(String string, AMFDataList aMFDataList) {
        try {
            String string2 = aMFDataList.getString(0);
            if (!"onCaption".equalsIgnoreCase(string2)) {
                return;
            }
            AMFData aMFData = aMFDataList.get(1);
            if (aMFData instanceof AMFDataArray) {
                AMFDataArray aMFDataArray = (AMFDataArray)aMFData;
                for (int i = 0; i < aMFDataArray.size(); ++i) {
                    AMFData aMFData2 = aMFDataArray.get(i);
                    if (aMFData2 == null) {
                        return;
                    }
                    String string3 = aMFData2.toString();
                    if (this.maxCaptions <= 0 || this.numCaptions < this.maxCaptions) {
                        WMSLoggerFactory.getLogger((Class)CLASS).info(String.format("%s[%s] onCaption: i:%d caption:'%s'", "ModuleCCDetectLiveCaptions", string, i, string3));
                    }
                    ++this.numCaptions;
                }
            }
        }
        catch (Exception exception) {
            WMSLoggerFactory.getLogger((Class)CLASS).error(String.format("%s.handleOnCaption[%s]: exception", CLASSNAME, string), (Throwable)exception);
        }
    }

    private void handleOnCaptionInfo(String string, AMFDataList aMFDataList) {
        try {
            String string2 = aMFDataList.getString(0);
            AMFDataObj aMFDataObj = aMFDataList.getObject(1);
            if (aMFDataObj == null) {
                return;
            }
            AMFDataItem aMFDataItem = (AMFDataItem)aMFDataObj.get("type");
            if (aMFDataItem != null && "708".equals(aMFDataItem.toString())) {
                this.handle708Caption(string, aMFDataObj);
                return;
            }
            AMFDataArray aMFDataArray = (AMFDataArray)aMFDataObj.get("speakers");
            AMFDataArray aMFDataArray2 = (AMFDataArray)aMFDataObj.get("tracks");
            if (aMFDataArray2 == null) {
                return;
            }
            for (int i = 0; i < aMFDataArray2.size(); ++i) {
                AMFData aMFData = aMFDataArray2.get(i);
                if (this.maxCaptions <= 0 || this.numCaptions < this.maxCaptions) {
                    WMSLoggerFactory.getLogger((Class)CLASS).info(String.format("%s[%s] onCaptionInfo: track[%d]:%s", "ModuleCCDetectLiveCaptions", string, i, aMFData));
                }
                ++this.numCaptions;
            }
        }
        catch (Exception exception) {
            WMSLoggerFactory.getLogger((Class)CLASS).error(String.format("%s.handleOnCaptionInfo[%s]: exception", CLASSNAME, string), (Throwable)exception);
        }
    }

    private void handle708Caption(String string, AMFDataObj aMFDataObj) {
        try {
            AMFDataItem aMFDataItem = (AMFDataItem)aMFDataObj.get("type");
            AMFDataItem aMFDataItem2 = (AMFDataItem)aMFDataObj.get("data");
            if (aMFDataItem == null || aMFDataItem2 == null) {
                return;
            }
            if (this.maxCaptions <= 0 || this.numCaptions < this.maxCaptions) {
                WMSLoggerFactory.getLogger((Class)CLASS).info(String.format("%s[%s] onCaptionInfo(708): data:%s", "ModuleCCDetectLiveCaptions", string, aMFDataItem2));
            }
            ++this.numCaptions;
        }
        catch (Exception exception) {
            WMSLoggerFactory.getLogger((Class)CLASS).error(String.format("%s.handle708Caption[%s]: exception", CLASSNAME, string), (Throwable)exception);
        }
    }
}

