/*
 * Decompiled with CFR 0.152.
 */
package com.wowza.wms.plugin.closedcaption.live;

import com.wowza.wms.amf.AMFDataList;
import com.wowza.wms.amf.AMFDataObj;
import com.wowza.wms.logging.WMSLoggerFactory;
import com.wowza.wms.request.RequestFunction;
import com.wowza.wms.stream.IMediaStream;
import com.wowza.wms.stream.IMediaStreamCallback;

public class OnTextDataCaptionLogger
implements IMediaStreamCallback {
    private static final String CLASSNAME = "OnTextDataCaptionLogger";
    private static final Class CLASS = OnTextDataCaptionLogger.class;
    private int maxCaptions = 100;
    private int numCaptions = 0;

    public void setMaximumCaptions(int n) {
        this.maxCaptions = n;
    }

    public void onCallback(IMediaStream iMediaStream, RequestFunction requestFunction, AMFDataList aMFDataList) {
        String string = iMediaStream == null ? "" : iMediaStream.getContextStr();
        try {
            int n;
            if (aMFDataList.size() >= 2 && (aMFDataList.getType(n = 1) == 3 || aMFDataList.getType(n) == 8)) {
                AMFDataObj aMFDataObj = aMFDataList.getObject(n);
                String string2 = aMFDataObj.getString("text");
                String string3 = aMFDataObj.getString("language");
                Integer n2 = aMFDataObj.getInt("trackid");
                String string4 = String.format("track:%d lang:%s text:'%s'", n2, string3 == null ? "" : string3, string2 == null ? "" : string2);
                if (this.maxCaptions <= 0 || this.numCaptions < this.maxCaptions) {
                    WMSLoggerFactory.getLogger((Class)CLASS).info(String.format("%s[%s] onTextData: %s", "ModuleCCDetectLiveCaptions", string, string4));
                }
                ++this.numCaptions;
            }
        }
        catch (Exception exception) {
            WMSLoggerFactory.getLogger((Class)CLASS).error(String.format("%s.onCallback[%s]: exception", CLASSNAME, string), (Throwable)exception);
        }
    }
}

