/*
 * Decompiled with CFR 0.152.
 */
package com.wowza.wms.plugin.closedcaption.live;

import com.wowza.util.FLVUtils;
import com.wowza.util.StringUtils;
import com.wowza.wms.amf.AMFDataList;
import com.wowza.wms.amf.AMFDataObj;
import com.wowza.wms.amf.AMFPacket;
import com.wowza.wms.application.IApplicationInstance;
import com.wowza.wms.application.WMSProperties;
import com.wowza.wms.media.h264.H264CodecConfigInfo;
import com.wowza.wms.media.h264.H264SEIMessage;
import com.wowza.wms.media.h264.H264SEIMessages;
import com.wowza.wms.media.h264.H264Utils;
import com.wowza.wms.module.ModuleBase;
import com.wowza.wms.request.RequestFunction;
import com.wowza.wms.stream.IMediaStream;
import com.wowza.wms.stream.IMediaStreamCallback;
import com.wowza.wms.stream.IMediaStreamH264SEINotify;
import com.wowza.wms.timedtext.cea608.ClosedCaptionCEA608Utils;
import java.util.ArrayList;
import java.util.List;

public class ModuleClosedCaptionLive
extends ModuleBase {
    private IApplicationInstance appInstance = null;
    private int maxDisplayTime = 10000;
    private int commandsPerFrame = 31;
    private int channel = 0;
    private int color = 0;
    private String characterSet = "UTF-8";
    private boolean logOnTextDataEvents = false;
    private boolean removeExistingCEA608 = false;

    public void onAppStart(IApplicationInstance iApplicationInstance) {
        this.appInstance = iApplicationInstance;
        WMSProperties wMSProperties = iApplicationInstance.getProperties();
        this.maxDisplayTime = wMSProperties.getPropertyInt("closedCaptionLiveMaxDisplayTime", this.maxDisplayTime);
        this.commandsPerFrame = wMSProperties.getPropertyInt("closedCaptionLiveCommandsPerFrame", this.commandsPerFrame);
        this.channel = wMSProperties.getPropertyInt("closedCaptionLiveChannel", this.channel);
        this.color = wMSProperties.getPropertyInt("closedCaptionLiveColor", this.color);
        this.characterSet = wMSProperties.getPropertyStr("closedCaptionLiveCharacterSet", this.characterSet);
        this.logOnTextDataEvents = wMSProperties.getPropertyBoolean("closedCaptionLiveLogOnTextDataEvents", this.logOnTextDataEvents);
        this.removeExistingCEA608 = wMSProperties.getPropertyBoolean("closedCaptionLiveRemoveExistingCEA608", this.removeExistingCEA608);
        ModuleClosedCaptionLive.getLogger().info("ModuleClosedCaptionLive.onAppStart[" + iApplicationInstance.getContextStr() + "] logOnTextDataEvents:" + this.logOnTextDataEvents);
    }

    public void onAppStop(IApplicationInstance iApplicationInstance) {
        ModuleClosedCaptionLive.getLogger().info("ModuleClosedCaptionLive.onAppStop[" + iApplicationInstance.getContextStr() + "]");
    }

    public void onStreamCreate(IMediaStream iMediaStream) {
        ClosedCaptionStreamHandler closedCaptionStreamHandler = new ClosedCaptionStreamHandler();
        closedCaptionStreamHandler.setMaxDisplayTime(this.maxDisplayTime);
        closedCaptionStreamHandler.setCommandsPerFrame(this.commandsPerFrame);
        closedCaptionStreamHandler.setChannel(this.channel);
        closedCaptionStreamHandler.setColor(this.color);
        closedCaptionStreamHandler.setCharacterSet(this.characterSet);
        iMediaStream.getProperties().setProperty("ClosedCaptionStreamHandler", (Object)closedCaptionStreamHandler);
        iMediaStream.registerCallback("onTextData", (IMediaStreamCallback)closedCaptionStreamHandler);
        iMediaStream.addVideoH264SEIListener((IMediaStreamH264SEINotify)closedCaptionStreamHandler);
    }

    public void addClosedCaptionText(IMediaStream iMediaStream, String string) {
        block1: {
            Object object;
            block0: {
                object = iMediaStream.getProperties().getProperty("ClosedCaptionStreamHandler");
                if (object != null) break block0;
                ModuleClosedCaptionLive.getLogger().warn("ModuleClosedCaptionLive.addClosedCaptionText[" + iMediaStream.getContextStr() + "] ClosedCaptionStreamHandler is missing.");
                break block1;
            }
            if (!(object instanceof ClosedCaptionStreamHandler)) break block1;
            ClosedCaptionStreamHandler closedCaptionStreamHandler = (ClosedCaptionStreamHandler)object;
            closedCaptionStreamHandler.addClosedCaptionText(string);
        }
    }

    private boolean isCEA608Caption(H264SEIMessage h264SEIMessage) {
        int n;
        if (h264SEIMessage.getPayloadType() != 4L) {
            return false;
        }
        byte[] byArray = h264SEIMessage.getPayloadBuffer();
        return byArray[(n = h264SEIMessage.getPayloadOffset()) + 2] == 49 && byArray[n + 3] == 71 && byArray[n + 4] == 65 && byArray[n + 5] == 57 && byArray[n + 6] == 52;
    }

    private void removeCEA608Captions(H264SEIMessages h264SEIMessages) {
        if (h264SEIMessages == null || h264SEIMessages.isEmpty()) {
            return;
        }
        int n = h264SEIMessages.getMessageCount();
        for (int i = n - 1; i >= 0; --i) {
            H264SEIMessage h264SEIMessage = h264SEIMessages.getMessage(i);
            if (!this.isCEA608Caption(h264SEIMessage)) continue;
            h264SEIMessages.removeMessage(i);
            h264SEIMessages.setModified(true);
        }
    }

    class CCCommandSet {
        public short[] ccCommands = null;
        public int cpos = 0;

        CCCommandSet() {
        }

        public boolean isEmpty() {
            return this.cpos >= this.ccCommands.length;
        }
    }

    class CCTextBlock {
        public String text = null;

        public CCTextBlock(String string) {
            this.text = string;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    class ClosedCaptionStreamHandler
    implements IMediaStreamCallback,
    IMediaStreamH264SEINotify {
        private List<CCTextBlock> ccTextBlocks = new ArrayList<CCTextBlock>();
        private List<CCCommandSet> ccCommandSets = new ArrayList<CCCommandSet>();
        private int nalUnitLen = -1;
        private Object lock = new Object();
        private long lastDisplayTime = -1L;
        private int maxDisplayTime = 10000;
        private int commandsPerFrame = 31;
        private int payloadType = 4;
        private int channel = 0;
        private int charsPerLine = 32;
        private int color = 0;
        private String characterSet = "UTF-8";

        ClosedCaptionStreamHandler() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void onCallback(IMediaStream iMediaStream, RequestFunction requestFunction, AMFDataList aMFDataList) {
            CCTextBlock cCTextBlock = null;
            Object object = this.getTextData(aMFDataList);
            if (object != null) {
                cCTextBlock = new CCTextBlock((String)object);
            }
            if (cCTextBlock != null) {
                if (ModuleClosedCaptionLive.this.logOnTextDataEvents) {
                    ModuleClosedCaptionLive.getLogger().info("ModuleClosedCaptionLive#OnTextDataHandler.onCallback[" + iMediaStream.getContextStr() + "]: ccTextBlock:" + cCTextBlock.text);
                }
                object = this.lock;
                synchronized (object) {
                    this.ccTextBlocks.add(cCTextBlock);
                }
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void onVideoH264Packet(IMediaStream iMediaStream, AMFPacket aMFPacket, H264SEIMessages h264SEIMessages) {
            int n = FLVUtils.getVideoCodec((AMFPacket)aMFPacket);
            if (n != 7) {
                Object object2 = this.lock;
                synchronized (object2) {
                    this.ccTextBlocks.clear();
                }
                return;
            }
            if (ModuleClosedCaptionLive.this.removeExistingCEA608) {
                ModuleClosedCaptionLive.this.removeCEA608Captions(h264SEIMessages);
            }
            ArrayList<CCTextBlock> arrayList = null;
            Object object3 = this.lock;
            synchronized (object3) {
                if (this.ccTextBlocks.size() > 0) {
                    arrayList = new ArrayList<CCTextBlock>();
                    arrayList.addAll(this.ccTextBlocks);
                    this.ccTextBlocks.clear();
                }
            }
            if (arrayList != null) {
                for (CCTextBlock object4 : arrayList) {
                    List<String> list = this.breakTextIntoLines(object4.text);
                    CCCommandSet n2 = this.getCAE608Commands(list, this.characterSet, this.channel);
                    if (n2 == null) break;
                    Object n3 = this.lock;
                    synchronized (n3) {
                        this.ccCommandSets.add(n2);
                    }
                }
            }
            object3 = null;
            Object l = this.lock;
            synchronized (l) {
                if (this.ccCommandSets.size() > 0) {
                    object3 = this.ccCommandSets.get(0);
                }
            }
            long l2 = System.currentTimeMillis();
            if (object3 != null) {
                int sArray = this.getFrameType(iMediaStream, aMFPacket);
                if (sArray != 3) {
                    byte[] byArray;
                    this.lastDisplayTime = -1L;
                    int object6 = ((CCCommandSet)object3).ccCommands.length - ((CCCommandSet)object3).cpos;
                    if (object6 > this.commandsPerFrame) {
                        object6 = this.commandsPerFrame;
                    }
                    if ((byArray = this.getClosedCaption(((CCCommandSet)object3).ccCommands, ((CCCommandSet)object3).cpos, object6)) != null) {
                        ((CCCommandSet)object3).cpos += object6;
                        h264SEIMessages.setModified(true);
                        h264SEIMessages.addMessage(new H264SEIMessage(this.payloadType, byArray, 0, byArray.length));
                    }
                }
                if (((CCCommandSet)object3).isEmpty()) {
                    Object byArray = this.lock;
                    synchronized (byArray) {
                        this.ccCommandSets.remove(object3);
                        if (this.ccCommandSets.size() <= 0) {
                            this.lastDisplayTime = l2;
                        }
                    }
                }
            }
            if (this.maxDisplayTime > 0 && this.lastDisplayTime >= 0L && l2 - this.lastDisplayTime >= (long)this.maxDisplayTime) {
                this.lastDisplayTime = -1L;
                short[] sArray = new short[]{ClosedCaptionCEA608Utils.CONTROLCODES_ENM[this.channel], ClosedCaptionCEA608Utils.CONTROLCODES_EDM[this.channel]};
                byte[] byArray = this.getClosedCaption(sArray, 0, sArray.length);
                if (byArray != null) {
                    h264SEIMessages.setModified(true);
                    h264SEIMessages.addMessage(new H264SEIMessage(this.payloadType, byArray, 0, byArray.length));
                }
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void addClosedCaptionText(String string) {
            CCTextBlock cCTextBlock = new CCTextBlock(string);
            ModuleClosedCaptionLive.getLogger().info("ModuleClosedCaptionLive.addClosedCaptionText: ccTextBlock:" + cCTextBlock.text);
            Object object = this.lock;
            synchronized (object) {
                this.ccTextBlocks.add(cCTextBlock);
            }
        }

        private byte[] getClosedCaption(short[] sArray, int n, int n2) {
            int n3 = 0;
            byte[] byArray = new byte[ClosedCaptionCEA608Utils.SEI_STARTCODE.length + 3 + n2 * 3 + 1];
            System.arraycopy(ClosedCaptionCEA608Utils.SEI_STARTCODE, 0, byArray, n3, ClosedCaptionCEA608Utils.SEI_STARTCODE.length);
            byArray[n3 += ClosedCaptionCEA608Utils.SEI_STARTCODE.length] = 3;
            byArray[++n3] = (byte)(0xC0 | n2);
            byArray[++n3] = -1;
            ++n3;
            for (int i = 0; i < n2; ++i) {
                byArray[n3] = -4;
                byArray[++n3] = ClosedCaptionCEA608Utils.calcParity((byte)((byte)(sArray[n + i] >> 8 & 0xFF)));
                byArray[++n3] = ClosedCaptionCEA608Utils.calcParity((byte)((byte)(sArray[n + i] >> 0 & 0xFF)));
                ++n3;
            }
            byArray[n3] = -1;
            ++n3;
            return byArray;
        }

        private int getFrameType(IMediaStream iMediaStream, AMFPacket aMFPacket) {
            int n = FLVUtils.getVideoFrameType((AMFPacket)aMFPacket);
            if (n == 2 && aMFPacket.getSize() > 5) {
                byte[] byArray = aMFPacket.getData();
                int n2 = 5;
                if (this.nalUnitLen < 0) {
                    this.nalUnitLen = this.getNALUnitSizeLength(iMediaStream, aMFPacket.getAbsTimecode());
                }
                n = H264Utils.extractFrameType((byte[])byArray, (int)n2, (int)(byArray.length - n2), (int)this.nalUnitLen);
            }
            return n;
        }

        private int getNALUnitSizeLength(IMediaStream iMediaStream, long l) {
            int n;
            block1: {
                H264CodecConfigInfo h264CodecConfigInfo;
                n = 4;
                AMFPacket aMFPacket = iMediaStream.getVideoCodecConfigPacket(l);
                if (aMFPacket == null) break block1;
                byte[] byArray = aMFPacket.getData();
                int n2 = aMFPacket.getSize();
                if (byArray != null && n2 > 5 && (h264CodecConfigInfo = H264Utils.decodeAVCC((byte[])byArray, (int)5)) != null) {
                    n = h264CodecConfigInfo.nalUnitLen;
                }
            }
            return n;
        }

        private String getTextData(AMFDataList aMFDataList) {
            String string;
            block0: {
                int n;
                string = null;
                if (aMFDataList.size() < 2 || aMFDataList.getType(n = 1) != 3 && aMFDataList.getType(n) != 8) break block0;
                AMFDataObj aMFDataObj = aMFDataList.getObject(n);
                string = aMFDataObj.getString("text");
            }
            return string;
        }

        private List<String> breakTextIntoLines(String string) {
            ArrayList<String> arrayList = new ArrayList<String>();
            List<String> list = this.breakOnHtmlBreaks(string);
            for (String string2 : list) {
                List<String> list2 = this.breakLongTextIntoLines(string2, this.charsPerLine);
                arrayList.addAll(list2);
            }
            return arrayList;
        }

        private List<String> breakOnHtmlBreaks(String string) {
            ArrayList<String> arrayList = new ArrayList<String>();
            if (StringUtils.isEmpty((String)string)) {
                return arrayList;
            }
            try {
                String[] stringArray;
                for (String string2 : stringArray = string.split("\n")) {
                    arrayList.add(string2);
                }
            }
            catch (Exception exception) {
                arrayList = new ArrayList();
                arrayList.add(string);
            }
            return arrayList;
        }

        private List<String> breakLongTextIntoLines(String string, int n) {
            ArrayList<String> arrayList = new ArrayList<String>();
            string = string.trim();
            do {
                String string2 = string;
                if (string.length() > n) {
                    boolean bl = false;
                    for (int i = n; i >= 0; --i) {
                        if (!Character.isWhitespace(string.charAt(i))) continue;
                        bl = true;
                        string2 = string.substring(0, i);
                        string = string.substring(i + 1);
                        break;
                    }
                    if (!bl) {
                        string2 = string.substring(0, n);
                        string = string.substring(n);
                    }
                } else {
                    string = "";
                }
                arrayList.add(string2.trim());
            } while ((string = string.trim()).length() > 0);
            return arrayList;
        }

        private byte[] charToByte(String string, int n, String string2, int n2) {
            return ClosedCaptionCEA608Utils.charUTF8ToCAE608((String)string, (int)n, (String)string2, (int)n2);
        }

        private int getCharacterCount(List<String> list, String string, int n) {
            int n2 = 0;
            for (String string2 : list) {
                int n3 = 0;
                for (int i = 0; i < string2.length(); ++i) {
                    byte[] byArray = this.charToByte(string2, i, string, n);
                    for (int j = 0; j < byArray.length; ++j) {
                        if ((byArray[j] & 0xFF) < 32 && n3 % 2 > 0) {
                            ++n3;
                        }
                        ++n3;
                    }
                }
                if (n3 % 2 > 0) {
                    ++n3;
                }
                n2 += n3;
            }
            return n2;
        }

        private CCCommandSet getCAE608Commands(List<String> list, String string, int n) {
            int n2 = 3;
            int n3 = 2;
            int n4 = 2;
            CCCommandSet cCCommandSet = new CCCommandSet();
            int n5 = this.getCharacterCount(list, string, n);
            int n6 = n2 + n3 * list.size() + n5 / 2 + n4;
            cCCommandSet.ccCommands = new short[n6];
            int n7 = 0;
            int n8 = 0;
            cCCommandSet.ccCommands[n8] = ClosedCaptionCEA608Utils.CONTROLCODES_ENM[n];
            cCCommandSet.ccCommands[++n8] = ClosedCaptionCEA608Utils.CONTROLCODES_RCL[n];
            cCCommandSet.ccCommands[++n8] = (short)(ClosedCaptionCEA608Utils.COL0_HIBYTE[n][n7] | ClosedCaptionCEA608Utils.COL0_LOWBYTE[this.color][n7]);
            ++n8;
            int n9 = 15 - list.size();
            if (n9 < 0) {
                n9 = 0;
            }
            for (int i = 0; i < Math.min(list.size(), 15); ++i) {
                cCCommandSet.ccCommands[n8] = (short)(0xFFFF & (ClosedCaptionCEA608Utils.COL0_HIBYTE[n][n9 + i] | ClosedCaptionCEA608Utils.COL0_LOWBYTE[this.color][n9 + i]));
                cCCommandSet.ccCommands[++n8] = ClosedCaptionCEA608Utils.CONTROLCODES_BAS[0];
                ++n8;
                String string2 = list.get(i);
                int n10 = 0;
                for (int j = 0; j < string2.length(); ++j) {
                    byte[] byArray = this.charToByte(string2, j, string, n);
                    for (int k = 0; k < byArray.length; ++k) {
                        if ((byArray[k] & 0xFF) < 32 && n10 % 2 > 0) {
                            int n11 = n8++;
                            cCCommandSet.ccCommands[n11] = (short)(cCCommandSet.ccCommands[n11] | 0x80);
                            ++n10;
                        }
                        if (n10 % 2 <= 0) {
                            cCCommandSet.ccCommands[n8] = byArray[k];
                            ++n10;
                            int n12 = n8;
                            cCCommandSet.ccCommands[n12] = (short)(cCCommandSet.ccCommands[n12] << 8);
                            continue;
                        }
                        int n13 = n8++;
                        cCCommandSet.ccCommands[n13] = (short)(cCCommandSet.ccCommands[n13] | byArray[k]);
                        ++n10;
                    }
                }
                if (n10 % 2 <= 0) continue;
                int n14 = n8++;
                cCCommandSet.ccCommands[n14] = (short)(cCCommandSet.ccCommands[n14] | 0x80);
            }
            cCCommandSet.ccCommands[n8] = ClosedCaptionCEA608Utils.CONTROLCODES_EDM[n];
            cCCommandSet.ccCommands[++n8] = ClosedCaptionCEA608Utils.CONTROLCODES_EOC[n];
            ++n8;
            return cCCommandSet;
        }

        public int getMaxDisplayTime() {
            return this.maxDisplayTime;
        }

        public void setMaxDisplayTime(int n) {
            this.maxDisplayTime = n;
        }

        public int getCommandsPerFrame() {
            return this.commandsPerFrame;
        }

        public void setCommandsPerFrame(int n) {
            this.commandsPerFrame = n;
        }

        public int getChannel() {
            return this.channel;
        }

        public void setChannel(int n) {
            this.channel = n;
        }

        public int getColor() {
            return this.color;
        }

        public void setColor(int n) {
            this.color = n;
        }

        public String getCharacterSet() {
            return this.characterSet;
        }

        public void setCharacterSet(String string) {
            this.characterSet = string;
        }
    }
}

