/*
 * Decompiled with CFR 0.152.
 */
package com.wowza.wms.plugin.closedcaption.test;

import com.wowza.util.BufferUtils;
import com.wowza.util.SystemUtils;
import com.wowza.wms.amf.AMFData;
import com.wowza.wms.amf.AMFDataItem;
import com.wowza.wms.amf.AMFDataObj;
import com.wowza.wms.amf.AMFPacket;
import com.wowza.wms.application.IApplicationInstance;
import com.wowza.wms.media.model.MediaCodecInfoAudio;
import com.wowza.wms.media.model.MediaCodecInfoVideo;
import com.wowza.wms.module.ModuleBase;
import com.wowza.wms.stream.IMediaStream;
import com.wowza.wms.stream.IMediaStreamActionNotify3;
import com.wowza.wms.stream.MediaStream;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileReader;
import java.nio.charset.Charset;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;

public class ModulePublishOnTextData
extends ModuleBase {
    private List<OnTextData> onTextDataList = new ArrayList<OnTextData>();
    private boolean charsetTest = false;
    private final Charset UTF8_CHARSET = Charset.forName("UTF-8");
    private int publishInterval = 6500;

    public void onAppStart(IApplicationInstance iApplicationInstance) {
        ModulePublishOnTextData.getLogger().info("ModulePublishOnTextData.onAppStart[" + iApplicationInstance.getContextStr() + "]");
        String string = "${com.wowza.wms.context.VHostConfigHome}/content/ontextdata.txt";
        this.publishInterval = iApplicationInstance.getProperties().getPropertyInt("publishOnTextDataPublishInterval", this.publishInterval);
        string = iApplicationInstance.getProperties().getPropertyStr("publishOnTextDataFile", string);
        this.charsetTest = iApplicationInstance.getProperties().getPropertyBoolean("publishOnTextCharsetTest", this.charsetTest);
        HashMap<String, String> hashMap = new HashMap<String, String>();
        hashMap.put("com.wowza.wms.context.VHost", iApplicationInstance.getVHost().getName());
        hashMap.put("com.wowza.wms.context.VHostConfigHome", iApplicationInstance.getVHost().getHomePath());
        hashMap.put("com.wowza.wms.context.Application", iApplicationInstance.getApplication().getName());
        hashMap.put("com.wowza.wms.context.ApplicationInstance", iApplicationInstance.getName());
        string = SystemUtils.expandEnvironmentVariables((String)string, hashMap);
        File file = new File(string);
        ModulePublishOnTextData.getLogger().info("ModulePublishOnTextData.onAppStart[" + iApplicationInstance.getContextStr() + "]: sendInterval: " + this.publishInterval);
        if (this.charsetTest) {
            int n;
            int n2 = 32;
            int n3 = 256;
            int n4 = 20;
            do {
                if ((n = n3 - n2) > n4) {
                    n = n4;
                }
                String string2 = "";
                for (int i = 0; i < n; ++i) {
                    int n5 = n2 + i;
                    int n6 = 0;
                    if (n5 >= 32 && n5 < 128) {
                        n6 = n5;
                    } else if (n5 >= 128 && n5 < 192) {
                        n6 = 49792 + (n5 - 128);
                    } else if (n5 >= 192 && n5 < 256) {
                        n6 = 50048 + (n5 - 192);
                    }
                    try {
                        string2 = string2 + new String(BufferUtils.intToByteArray((int)n6, (int)(n6 < 128 ? 1 : 2)), "UTF-8");
                        continue;
                    }
                    catch (Exception exception) {
                        // empty catch block
                    }
                }
                string2 = "0x" + Integer.toHexString(n2) + ":" + string2 + ":";
                this.onTextDataList.add(new OnTextData(string2));
            } while ((n2 += n) < n3);
        } else {
            ModulePublishOnTextData.getLogger().info("ModulePublishOnTextData.onAppStart[" + iApplicationInstance.getContextStr() + "]: onTextDataFile[exists:" + file.exists() + "]: " + string);
            BufferedReader bufferedReader = null;
            if (file.exists()) {
                try {
                    String string3;
                    bufferedReader = new BufferedReader(new FileReader(file));
                    while ((string3 = bufferedReader.readLine()) != null) {
                        if ((string3 = string3.trim()).startsWith("#") || string3.length() == 0) continue;
                        this.onTextDataList.add(new OnTextData(string3));
                    }
                }
                catch (Exception exception) {
                    ModulePublishOnTextData.getLogger().error("ModulePublishOnTextData.onAppStart[read]: " + exception.toString());
                }
            }
            ModulePublishOnTextData.getLogger().info("ModulePublishOnTextData.onAppStart[" + iApplicationInstance.getContextStr() + "]: onTextDataFileCount: " + this.onTextDataList.size());
            try {
                if (bufferedReader != null) {
                    bufferedReader.close();
                }
                bufferedReader = null;
            }
            catch (Exception exception) {
                ModulePublishOnTextData.getLogger().error("ModulePublishOnTextData.onAppStart[close]: " + exception.toString());
            }
        }
    }

    public void onStreamCreate(IMediaStream iMediaStream) {
        iMediaStream.addClientListener((IMediaStreamActionNotify3)new MyMediaStreamListener());
    }

    public class MyMediaStreamListener
    implements IMediaStreamActionNotify3 {
        private PublishThread publishThread = null;

        public void onPublish(IMediaStream iMediaStream, String string, boolean bl, boolean bl2) {
            IApplicationInstance iApplicationInstance = iMediaStream.getStreams().getAppInstance();
            if (!iMediaStream.isTranscodeResult()) {
                this.publishThread = new PublishThread(iApplicationInstance, iMediaStream);
                this.publishThread.setName("OnTextDataPublisher-" + iApplicationInstance.getContextStr() + "-" + string);
                this.publishThread.setDaemon(true);
                this.publishThread.setPublishInterval(ModulePublishOnTextData.this.publishInterval);
                this.publishThread.start();
            }
        }

        public void onUnPublish(IMediaStream iMediaStream, String string, boolean bl, boolean bl2) {
            if (this.publishThread != null) {
                this.publishThread.doStop();
            }
            this.publishThread = null;
        }

        public void onMetaData(IMediaStream iMediaStream, AMFPacket aMFPacket) {
        }

        public void onPauseRaw(IMediaStream iMediaStream, boolean bl, double d) {
        }

        public void onPause(IMediaStream iMediaStream, boolean bl, double d) {
        }

        public void onPlay(IMediaStream iMediaStream, String string, double d, double d2, int n) {
        }

        public void onSeek(IMediaStream iMediaStream, double d) {
        }

        public void onStop(IMediaStream iMediaStream) {
        }

        public void onCodecInfoVideo(IMediaStream iMediaStream, MediaCodecInfoVideo mediaCodecInfoVideo) {
        }

        public void onCodecInfoAudio(IMediaStream iMediaStream, MediaCodecInfoAudio mediaCodecInfoAudio) {
        }
    }

    class OnTextData {
        String text = "";

        public OnTextData(String string) {
            this.text = string;
        }
    }

    class PublishThread
    extends Thread {
        private boolean running = true;
        private Object lock = new Object();
        private int interval = 500;
        private int publishInterval = 6500;
        private long lastSend = -1L;
        private IApplicationInstance appInstance = null;
        private IMediaStream stream = null;

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void doStop() {
            Object object = this.lock;
            synchronized (object) {
                this.running = false;
            }
        }

        public PublishThread(IApplicationInstance iApplicationInstance, IMediaStream iMediaStream) {
            this.appInstance = iApplicationInstance;
            this.stream = iMediaStream;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void run() {
            ModulePublishOnTextData.getLogger().info("ModulePublishOnTextData#PublishThread.run[" + this.stream.getContextStr() + "]: START");
            int n = 0;
            while (true) {
                try {
                    long l = System.currentTimeMillis();
                    if (this.lastSend < 0L || l - this.lastSend > (long)this.publishInterval) {
                        this.lastSend = l;
                        if (ModulePublishOnTextData.this.onTextDataList.size() > 0) {
                            OnTextData onTextData = (OnTextData)ModulePublishOnTextData.this.onTextDataList.get(n % ModulePublishOnTextData.this.onTextDataList.size());
                            ++n;
                            if (onTextData != null) {
                                this.sendTextDataMessage(this.stream, onTextData);
                            }
                        }
                    }
                    Thread.sleep(this.interval);
                }
                catch (Exception exception) {
                    ModulePublishOnTextData.getLogger().error("ModulePublishOnTextData#PublishThread.run[" + this.stream.getContextStr() + "]: " + exception.toString());
                }
                Object object = this.lock;
                synchronized (object) {
                    if (!this.running) {
                        break;
                    }
                }
            }
            ModulePublishOnTextData.getLogger().info("ModulePublishOnTextData#PublishThread.run[" + this.stream.getContextStr() + "]: STOP");
        }

        public void sendTextDataMessage(IMediaStream iMediaStream, OnTextData onTextData) {
            try {
                AMFDataObj aMFDataObj = new AMFDataObj();
                aMFDataObj.put("text", (AMFData)new AMFDataItem(onTextData.text));
                aMFDataObj.put("language", (AMFData)new AMFDataItem("eng"));
                aMFDataObj.put("trackid", (AMFData)new AMFDataItem(99));
                iMediaStream.sendDirect("onTextData", new Object[]{aMFDataObj});
                ((MediaStream)iMediaStream).processSendDirectMessages();
            }
            catch (Exception exception) {
                ModulePublishOnTextData.getLogger().error("ModulePublishOnTextData#PublishThread.sendTextDataMessage[" + iMediaStream.getContextStr() + "]: " + exception.toString());
                exception.printStackTrace();
            }
        }

        public int getPublishInterval() {
            return this.publishInterval;
        }

        public void setPublishInterval(int n) {
            this.publishInterval = n;
        }
    }
}

