/*
 * Decompiled with CFR 0.152.
 */
package com.wowza.wms.plugin.collection.module;

import com.wowza.wms.amf.AMFDataList;
import com.wowza.wms.application.IApplication;
import com.wowza.wms.application.IApplicationInstance;
import com.wowza.wms.client.IClient;
import com.wowza.wms.httpstreamer.model.IHTTPStreamerSession;
import com.wowza.wms.module.ModuleBase;
import com.wowza.wms.request.RequestFunction;
import com.wowza.wms.rtp.model.RTPSession;

public class ModuleLimitConnectionsToApplication
extends ModuleBase {
    public static final int MAXCONNECTIONS = 200;
    private int maxApplicationConnections = 200;

    public void onAppStart(IApplicationInstance iApplicationInstance) {
        this.maxApplicationConnections = iApplicationInstance.getProperties().getPropertyInt("maxApplicationConnections", this.maxApplicationConnections);
        ModuleLimitConnectionsToApplication.getLogger().info("ModuleLimitConnectionsToApplication limit: " + this.maxApplicationConnections);
    }

    public void changeLimit(IClient iClient, RequestFunction requestFunction, AMFDataList aMFDataList) {
        iClient.getAppInstance().broadcastMsg("handlerName", new Object[0]);
        Integer n = aMFDataList.getInt(3);
        this.maxApplicationConnections = n;
    }

    public void onConnect(IClient iClient, RequestFunction requestFunction, AMFDataList aMFDataList) {
        IApplicationInstance iApplicationInstance = iClient.getAppInstance();
        IApplication iApplication = iApplicationInstance.getApplication();
        long l = iApplication.getConnectionCounter().getCurrent();
        String string = iClient.getFlashVer();
        ModuleLimitConnectionsToApplication.getLogger().info("Flashver: " + string);
        Boolean bl = false;
        try {
            bl = string.startsWith(iClient.getAppInstance().getProperties().getPropertyStr("AllowEncoder"));
        }
        catch (Exception exception) {
            // empty catch block
        }
        ModuleLimitConnectionsToApplication.getLogger().info("ModuleLimitConnectionsToApplication count: " + (l + 1L));
        if (l + 1L > (long)this.maxApplicationConnections && !bl.booleanValue()) {
            iClient.rejectConnection("Over application connection limit [" + iApplication.getName() + "/" + iApplicationInstance.getName() + "]: Limit is: " + this.maxApplicationConnections);
            ModuleLimitConnectionsToApplication.getLogger().info("ModuleLimitConnectionsToApplication Flash connection rejected ");
        }
    }

    public void onHTTPSessionCreate(IHTTPStreamerSession iHTTPStreamerSession) {
        IApplicationInstance iApplicationInstance = iHTTPStreamerSession.getAppInstance();
        IApplication iApplication = iApplicationInstance.getApplication();
        long l = iApplication.getConnectionCounter().getCurrent();
        ModuleLimitConnectionsToApplication.getLogger().info("ModuleLimitConnectionsToApplication count: " + (l + 1L));
        if (l + 1L > (long)this.maxApplicationConnections) {
            iHTTPStreamerSession.rejectSession();
            ModuleLimitConnectionsToApplication.getLogger().info("ModuleLimitConnectionsToApplication Smooth connection rejected ");
        }
    }

    public void onRTPSessionCreate(RTPSession rTPSession) {
        IApplicationInstance iApplicationInstance = rTPSession.getAppInstance();
        IApplication iApplication = iApplicationInstance.getApplication();
        long l = iApplication.getConnectionCounter().getCurrent();
        ModuleLimitConnectionsToApplication.getLogger().info("ModuleLimitConnectionsToApplication count: " + (l + 1L));
        if (l + 1L > (long)this.maxApplicationConnections) {
            rTPSession.rejectSession();
            ModuleLimitConnectionsToApplication.getLogger().info("ModuleLimitConnectionsToApplication RTSP connection rejected ");
        }
    }
}

