/*
 * Decompiled with CFR 0.152.
 */
package com.wowza.wms.plugin.collection.module;

import com.wowza.wms.amf.AMFDataList;
import com.wowza.wms.application.ApplicationInstance;
import com.wowza.wms.application.IApplicationInstance;
import com.wowza.wms.client.IClient;
import com.wowza.wms.httpstreamer.model.IHTTPStreamerSession;
import com.wowza.wms.module.ModuleBase;
import com.wowza.wms.request.RequestFunction;
import com.wowza.wms.rtp.model.RTPSession;
import com.wowza.wms.rtp.model.RTPUrl;
import com.wowza.wms.stream.IMediaStream;
import com.wowza.wms.stream.mediacaster.MediaStreamMediaCasterUtils;
import com.wowza.wms.util.ModuleUtils;

public class ModuleLimitStreamViewers
extends ModuleBase {
    public static final int MAXVIEWERS = 200;
    private int maxStreamViewers = 200;
    private IApplicationInstance appInstance;
    private boolean logConnectionCounts = true;
    private boolean logRejections = true;

    public void onAppStart(IApplicationInstance iApplicationInstance) {
        this.appInstance = iApplicationInstance;
        this.maxStreamViewers = iApplicationInstance.getProperties().getPropertyInt("maxStreamViewers", 200);
        this.logConnectionCounts = iApplicationInstance.getProperties().getPropertyBoolean("limitStreamViewersLogConnectionCounts", this.logConnectionCounts);
        this.logRejections = iApplicationInstance.getProperties().getPropertyBoolean("limitStreamViewersLogRejections", this.logRejections);
        ModuleLimitStreamViewers.getLogger().info("ModuleLimitStreamViewers limit: " + this.maxStreamViewers + " logConnections: " + this.logConnectionCounts);
    }

    public void play(IClient iClient, RequestFunction requestFunction, AMFDataList aMFDataList) {
        String string = aMFDataList.getString(3);
        int n = this.getViewerCounts(string = ((ApplicationInstance)this.appInstance).internalResolvePlayAlias(string, iClient), iClient);
        if (n < this.maxStreamViewers) {
            this.invokePrevious(iClient, requestFunction, aMFDataList);
        } else {
            IMediaStream iMediaStream = ModuleLimitStreamViewers.getStream((IClient)iClient, (RequestFunction)requestFunction);
            if (iMediaStream != null) {
                String string2 = "NetStream.Play.Failed";
                String string3 = "ModuleLimitViewers: Over viewer limit[" + this.maxStreamViewers + "]";
                ModuleLimitStreamViewers.sendStreamOnStatusError((IMediaStream)iMediaStream, (String)string2, (String)string3);
                if (this.logRejections) {
                    ModuleLimitStreamViewers.getLogger().info("ModuleLimitViewers: Over viewer limit[" + this.maxStreamViewers + " streamName: " + string + "]");
                }
            }
        }
    }

    public void onHTTPSessionCreate(IHTTPStreamerSession iHTTPStreamerSession) {
        String string = iHTTPStreamerSession.getStreamName();
        int n = this.getViewerCounts(string);
        if (n > this.maxStreamViewers) {
            iHTTPStreamerSession.rejectSession();
            if (this.logRejections) {
                ModuleLimitStreamViewers.getLogger().info("ModuleLimitViewers: Over viewer limit[" + this.maxStreamViewers + " streamName: " + string + "]");
            }
        }
    }

    public void onRTPSessionCreate(RTPSession rTPSession) {
        String string = rTPSession.getUri();
        RTPUrl rTPUrl = new RTPUrl(string);
        String string2 = rTPUrl.getStreamName();
        int n = this.getViewerCounts(string2 = ((ApplicationInstance)this.appInstance).internalResolvePlayAlias(string2, rTPSession));
        if (n >= this.maxStreamViewers) {
            rTPSession.rejectSession();
            if (this.logRejections) {
                ModuleLimitStreamViewers.getLogger().info("ModuleLimitViewers: Over viewer limit[" + this.maxStreamViewers + " streamName: " + string2 + "]");
            }
        }
    }

    private int getViewerCounts(String string) {
        return this.getViewerCounts(string, null);
    }

    private synchronized int getViewerCounts(String string, IClient iClient) {
        int n = 0;
        String string2 = "flv";
        int n2 = 0;
        int n3 = 0;
        int n4 = 0;
        if (string != null) {
            String[] stringArray = ModuleUtils.decodeStreamExtension((String)string, (String)string2);
            string = stringArray[0];
            string2 = stringArray[1];
            boolean bl = string.indexOf("://") >= 0;
            int n5 = string.indexOf("?");
            if (!bl && n5 >= 0) {
                string = string.substring(0, n5);
            }
            n2 += this.appInstance.getPlayStreamCount(string);
            n3 += this.appInstance.getHTTPStreamerSessionCount(string);
            n4 += this.appInstance.getRTPSessionCount(string);
            String string3 = MediaStreamMediaCasterUtils.mapMediaCasterName((IApplicationInstance)this.appInstance, (IClient)iClient, (String)string);
            if (!string3.equals(string)) {
                ModuleLimitStreamViewers.getLogger().info("ModuleLimitStreamViewers.getViewerCounts matching mediaCaster name: " + string3);
                n2 += this.appInstance.getPlayStreamCount(string3);
                n3 += this.appInstance.getHTTPStreamerSessionCount(string3);
                n4 += this.appInstance.getRTPSessionCount(string3);
            }
            n = n2 + n3 + n4;
            if (this.logConnectionCounts) {
                ModuleLimitStreamViewers.getLogger().info("ModuleLimitStreamViewers.getViewerCounts streamName: " + string + " total:" + n + " rtmp: " + n2 + " http: " + n3 + " rtp: " + n4);
            }
        }
        return n;
    }
}

