/*
 * Decompiled with CFR 0.152.
 */
package com.wowza.wms.plugin.collection.module;

import com.wowza.wms.amf.AMFDataList;
import com.wowza.wms.application.IApplicationInstance;
import com.wowza.wms.client.ConnectionCounter;
import com.wowza.wms.client.IClient;
import com.wowza.wms.httpstreamer.cupertinostreaming.httpstreamer.HTTPStreamerSessionCupertino;
import com.wowza.wms.httpstreamer.sanjosestreaming.httpstreamer.HTTPStreamerSessionSanJose;
import com.wowza.wms.httpstreamer.smoothstreaming.httpstreamer.HTTPStreamerSessionSmoothStreamer;
import com.wowza.wms.module.ModuleBase;
import com.wowza.wms.plugin.loadbalancer.LoadBalancerSender;
import com.wowza.wms.request.RequestFunction;
import com.wowza.wms.rtp.model.RTPSession;
import com.wowza.wms.server.Server;

public class ModuleLoadBalancerEdgeLimitConnections
extends ModuleBase {
    public static final int MAXCONNECTIONS = 200;
    private ConnectionCounter counter;
    private int maxEdgeConnections = 200;
    private LoadBalancerSender loadBalancerSender;

    public void onAppStart(IApplicationInstance iApplicationInstance) {
        this.counter = iApplicationInstance.getConnectionCounter();
        this.maxEdgeConnections = iApplicationInstance.getProperties().getPropertyInt("maxEdgeConnections", this.maxEdgeConnections);
        this.loadBalancerSender = (LoadBalancerSender)Server.getInstance().getProperties().get((Object)"WowzaProLoadBalancerSender");
        ModuleLoadBalancerEdgeLimitConnections.getLogger().info("ModuleLoadBalancerEdgeLimitConnections maxEdgeConnections: " + this.maxEdgeConnections);
    }

    public void changeLimitEdge(IClient iClient, RequestFunction requestFunction, AMFDataList aMFDataList) {
        Integer n = aMFDataList.getInt(3);
        this.maxEdgeConnections = n;
        ModuleLoadBalancerEdgeLimitConnections.getLogger().info("ModuleLoadBalancerEdgeLimitConnections New Limit: " + n);
    }

    private void addConnection() {
        this.loadBalancerSender = (LoadBalancerSender)Server.getInstance().getProperties().get((Object)"WowzaProLoadBalancerSender");
        if (this.loadBalancerSender == null) {
            ModuleLoadBalancerEdgeLimitConnections.getLogger().info("ModuleLoadBalancerEdgeLimitConnections Error (addConnection): Load Balancer Sender is not installed", "application", "comment");
            return;
        }
        long l = this.counter.getCurrent();
        if (l + 1L > (long)this.maxEdgeConnections) {
            this.loadBalancerSender.pause();
            ModuleLoadBalancerEdgeLimitConnections.getLogger().info("ModuleLoadBalancerEdgeLimitConnections Pause", "application", "comment");
        }
        ModuleLoadBalancerEdgeLimitConnections.getLogger().info("ModuleLoadBalancerEdgeLimitConnections Count: " + l, "application", "comment");
    }

    private void removeConnection() {
        this.loadBalancerSender = (LoadBalancerSender)Server.getInstance().getProperties().get((Object)"WowzaProLoadBalancerSender");
        if (this.loadBalancerSender == null) {
            ModuleLoadBalancerEdgeLimitConnections.getLogger().info("ModuleLoadBalancerEdgeLimitConnections Error (removeConnection): Load Balancer Sender is not installed", "application", "comment");
            return;
        }
        long l = this.counter.getCurrent();
        if (l - 1L < (long)this.maxEdgeConnections) {
            this.loadBalancerSender.unpause();
            ModuleLoadBalancerEdgeLimitConnections.getLogger().info("ModuleLoadBalancerEdgeLimitConnections UnPause", "application", "comment");
        }
        ModuleLoadBalancerEdgeLimitConnections.getLogger().info("ModuleLoadBalancerEdgeLimitConnections Count: " + l, "application", "comment");
    }

    public void onConnect(IClient iClient, RequestFunction requestFunction, AMFDataList aMFDataList) {
        this.addConnection();
    }

    public void onDisconnect(IClient iClient) {
        this.removeConnection();
    }

    public void onHTTPSmoothStreamingSessionCreate(HTTPStreamerSessionSmoothStreamer hTTPStreamerSessionSmoothStreamer) {
        this.addConnection();
    }

    public void onHTTPSmoothStreamingSessionDestroy(HTTPStreamerSessionSmoothStreamer hTTPStreamerSessionSmoothStreamer) {
        this.removeConnection();
    }

    public void onHTTPCupertinoStreamingSessionCreate(HTTPStreamerSessionCupertino hTTPStreamerSessionCupertino) {
        this.addConnection();
    }

    public void onHTTPCupertinoStreamingSessionDestroy(HTTPStreamerSessionCupertino hTTPStreamerSessionCupertino) {
        this.removeConnection();
    }

    public void onHTTPSanjoseStreamingSessionCreate(HTTPStreamerSessionSanJose hTTPStreamerSessionSanJose) {
        this.addConnection();
    }

    public void onHTTPSanjoseStreamingSessionDestroy(HTTPStreamerSessionSanJose hTTPStreamerSessionSanJose) {
        this.removeConnection();
    }

    public void onRTPSessionCreate(RTPSession rTPSession) {
        this.addConnection();
    }

    public void onRTPSessionDestroy(RTPSession rTPSession) {
        this.removeConnection();
    }
}

