/*
 * Decompiled with CFR 0.152.
 */
package com.wowza.wms.plugin.collection.module;

import com.wowza.wms.amf.AMFDataList;
import com.wowza.wms.amf.AMFDataMixedArray;
import com.wowza.wms.amf.AMFDataObj;
import com.wowza.wms.amf.AMFPacket;
import com.wowza.wms.application.IApplicationInstance;
import com.wowza.wms.logging.WMSLoggerFactory;
import com.wowza.wms.module.ModuleBase;
import com.wowza.wms.stream.IMediaStream;
import com.wowza.wms.stream.IMediaStreamMetaDataProvider;
import com.wowza.wms.stream.MediaStreamMap;
import com.wowza.wms.vhost.VHostWorkerThread;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class ModuleLogViewerCounts
extends ModuleBase {
    private MyLogger logger = null;

    public void onAppStart(IApplicationInstance iApplicationInstance) {
        this.logger = new MyLogger(iApplicationInstance);
        this.logger.setAppInstance(iApplicationInstance);
        this.logger.setName("ModuleLogViewerCounts.MyLogger");
        this.logger.setDaemon(true);
        this.logger.start();
    }

    public void onAppStop(IApplicationInstance iApplicationInstance) {
        if (this.logger != null) {
            this.logger.quit();
        }
        this.logger = null;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    class MyLogger
    extends VHostWorkerThread {
        private boolean running;
        private boolean quit;
        private int logTime;
        private long lastLogTime;
        private IApplicationInstance appInstance;

        public MyLogger(IApplicationInstance iApplicationInstance) {
            super(iApplicationInstance.getVHost());
            this.running = true;
            this.quit = false;
            this.logTime = 10000;
            this.lastLogTime = -1L;
            this.appInstance = null;
            this.appInstance = iApplicationInstance;
        }

        public void quit() {
            this.quit = true;
        }

        private Map<String, String> getMetadataInfo(IMediaStream iMediaStream) {
            HashMap<String, String> hashMap;
            block6: {
                hashMap = new HashMap<String, String>();
                try {
                    AMFPacket aMFPacket;
                    AMFDataList aMFDataList;
                    IMediaStreamMetaDataProvider iMediaStreamMetaDataProvider = iMediaStream.getMetaDataProvider();
                    if (iMediaStreamMetaDataProvider == null) break block6;
                    ArrayList arrayList = new ArrayList();
                    long l = 0L;
                    AMFPacket aMFPacket2 = iMediaStream.getLastPacket();
                    l = aMFPacket2 == null ? 0L : aMFPacket2.getAbsTimecode();
                    iMediaStreamMetaDataProvider.onStreamStart(arrayList, l);
                    if (arrayList.size() <= 0) break block6;
                    for (int i = 0; i < arrayList.size() && (aMFDataList = new AMFDataList((aMFPacket = (AMFPacket)arrayList.get(i)).getData())).size() >= 2; ++i) {
                        String string;
                        AMFDataMixedArray aMFDataMixedArray;
                        if (aMFDataList.get(1).getType() == 8) {
                            aMFDataMixedArray = (AMFDataMixedArray)aMFDataList.get(1);
                            for (String string2 : aMFDataMixedArray.getKeys()) {
                                string = aMFDataMixedArray.getString(string2);
                                if (string == null) continue;
                                hashMap.put(string2, string);
                            }
                            continue;
                        }
                        if (aMFDataList.get(1).getType() != 3) continue;
                        aMFDataMixedArray = (AMFDataObj)aMFDataList.get(1);
                        for (String string2 : aMFDataMixedArray.getKeys()) {
                            string = aMFDataMixedArray.getString(string2);
                            if (string == null) continue;
                            hashMap.put(string2, string);
                        }
                    }
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
            return hashMap;
        }

        private int toCount(Integer n) {
            int n2 = n == null ? 0 : n;
            return n2;
        }

        public void run() {
            while (true) {
                try {
                    do {
                        long l = System.currentTimeMillis();
                        if (this.lastLogTime == -1L) {
                            this.lastLogTime = l;
                        }
                        if (l - this.lastLogTime > (long)this.logTime) {
                            MediaStreamMap mediaStreamMap = this.appInstance.getStreams();
                            List list = mediaStreamMap.getPublishStreamNames();
                            Map map = this.appInstance.getPlayStreamCountsByName();
                            Map map2 = this.appInstance.getHTTPStreamerSessionCountsByName(0);
                            Map map3 = this.appInstance.getHTTPStreamerSessionCountsByName(1);
                            Map map4 = this.appInstance.getRTPSessionCountsByName();
                            for (String string : list) {
                                String string22;
                                IMediaStream iMediaStream = mediaStreamMap.getStream(string);
                                if (iMediaStream == null) continue;
                                IMediaStreamMetaDataProvider iMediaStreamMetaDataProvider = iMediaStream.getMetaDataProvider();
                                ArrayList arrayList = new ArrayList();
                                iMediaStreamMetaDataProvider.onStreamStart(arrayList, 0L);
                                int n = this.toCount((Integer)map.get(string));
                                int n2 = this.toCount((Integer)map3.get(string));
                                int n3 = this.toCount((Integer)map2.get(string));
                                int n4 = this.toCount((Integer)map4.get(string));
                                StringBuffer stringBuffer = new StringBuffer();
                                int n5 = n + n2 + n3 + n4;
                                stringBuffer.append("viewers: \"" + n5 + "\"");
                                stringBuffer.append(", viewersRTMP: \"" + n + "\"");
                                stringBuffer.append(", viewersCupertino: \"" + n2 + "\"");
                                stringBuffer.append(", viewersSmooth: \"" + n3 + "\"");
                                stringBuffer.append(", viewersRTSP: \"" + n4 + "\"");
                                Map<String, String> map5 = this.getMetadataInfo(iMediaStream);
                                for (String string22 : map5.keySet()) {
                                    String string3 = map5.get(string22);
                                    stringBuffer.append(", " + string22 + ": \"" + string3 + "\"");
                                }
                                string22 = stringBuffer.toString().replace("\n", "");
                                WMSLoggerFactory.getLoggerObj((IApplicationInstance)this.appInstance).info("{" + string22 + "}", iMediaStream, "stream", "listeners", 200, string);
                            }
                            this.lastLogTime = l;
                        }
                        MyLogger.sleep((long)100L);
                    } while (!this.quit);
                    this.running = false;
                }
                catch (Exception exception) {
                    continue;
                }
                break;
            }
        }

        public IApplicationInstance getAppInstance() {
            return this.appInstance;
        }

        public void setAppInstance(IApplicationInstance iApplicationInstance) {
            this.appInstance = iApplicationInstance;
        }
    }
}

