/*
 * Decompiled with CFR 0.152.
 */
package com.wowza.wms.plugin.collection.module;

import com.wowza.wms.application.IApplicationInstance;
import com.wowza.wms.mediacaster.IMediaCaster;
import com.wowza.wms.mediacaster.IMediaCasterNotify2;
import com.wowza.wms.module.ModuleBase;
import com.wowza.wms.stream.IMediaStream;
import com.wowza.wms.stream.IMediaStreamActionNotify;
import com.wowza.wms.stream.IMediaStreamPlay;
import com.wowza.wms.stream.publish.PlaylistItem;
import com.wowza.wms.stream.publish.Stream;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class ModuleLoopUntilLive
extends ModuleBase {
    private IApplicationInstance appInstance;
    private String liveStreamNames = "myStream";
    private String outStreamNames = "Stream1";
    private boolean reloadEntirePlaylist = true;
    private boolean handleMediaCasters = true;
    private IMediaStreamActionNotify actionNotify = new StreamListener();
    private Map<String, List<PlaylistItem>> playlists = new HashMap<String, List<PlaylistItem>>();
    private Map<String, Integer> playlistIndexes = new HashMap<String, Integer>();

    public void onAppStart(IApplicationInstance iApplicationInstance) {
        this.init(iApplicationInstance);
        ModuleLoopUntilLive.getLogger().info("ModuleLoopUntilLive onAppStart");
    }

    public void init(IApplicationInstance iApplicationInstance) {
        this.appInstance = iApplicationInstance;
        iApplicationInstance.addMediaCasterListener((IMediaCasterNotify2)new MediaCasterListener());
        this.liveStreamNames = iApplicationInstance.getProperties().getPropertyStr("loopUntilLiveStream", this.liveStreamNames);
        this.outStreamNames = iApplicationInstance.getProperties().getPropertyStr("loopUntilLiveOutStream", this.outStreamNames);
        this.reloadEntirePlaylist = iApplicationInstance.getProperties().getPropertyBoolean("loopUntilLiveReloadEntirePlaylist", this.reloadEntirePlaylist);
        this.handleMediaCasters = iApplicationInstance.getProperties().getPropertyBoolean("loopUntilLiveHandleMediaCasters", this.handleMediaCasters);
    }

    public void onStreamCreate(IMediaStream iMediaStream) {
        if (this.appInstance == null) {
            this.init(iMediaStream.getStreams().getAppInstance());
        }
        iMediaStream.addClientListener(this.actionNotify);
    }

    public void onStreamDestroy(IMediaStream iMediaStream) {
        iMediaStream.removeClientListener(this.actionNotify);
    }

    private void swapToLive(String string) {
        String[] stringArray = this.liveStreamNames.split(",");
        String[] stringArray2 = this.outStreamNames.split(",");
        for (int i = 0; i < stringArray.length; ++i) {
            String string2 = stringArray[i].trim();
            if (!string.equalsIgnoreCase(string2) || stringArray2.length <= i) continue;
            String string3 = stringArray2[i].trim();
            Stream stream = (Stream)this.appInstance.getProperties().get((Object)string3);
            if (stream == null) continue;
            List list = stream.getPlaylist();
            int n = stream.getCurrentItem().getIndex();
            this.playlists.put(string3, list);
            this.playlistIndexes.put(string3, n);
            stream.play(string2, -2, -1, true);
            ModuleLoopUntilLive.getLogger().info("ModuleLoopUntilLive.swapToLive [" + stream.getName() + "]");
        }
    }

    private void swapToPlaylist(String string) {
        String[] stringArray = this.liveStreamNames.split(",");
        String[] stringArray2 = this.outStreamNames.split(",");
        for (int i = 0; i < stringArray.length; ++i) {
            String string2 = stringArray[i].trim();
            if (!string.equalsIgnoreCase(string2) || stringArray2.length <= i) continue;
            String string3 = stringArray2[i].trim();
            Stream stream = (Stream)this.appInstance.getProperties().get((Object)string3);
            if (stream == null) continue;
            List<PlaylistItem> list = this.playlists.remove(string3);
            int n = this.playlistIndexes.remove(string3);
            if (this.reloadEntirePlaylist) {
                boolean bl = true;
                for (PlaylistItem playlistItem : list) {
                    stream.play(playlistItem.getName(), playlistItem.getStart(), playlistItem.getLength(), bl);
                    bl = false;
                }
                stream.play(n + 1);
            } else if (list.size() > n) {
                PlaylistItem playlistItem = list.get(n);
                stream.play(playlistItem.getName(), playlistItem.getStart(), playlistItem.getLength(), true);
            }
            ModuleLoopUntilLive.getLogger().info("ModuleLoopUntilLive.swapToPlaylist [" + stream.getName() + "]");
        }
    }

    public String getLiveStreamNames() {
        return this.liveStreamNames;
    }

    public void setLiveStreamNames(String string) {
        this.liveStreamNames = string;
    }

    public String getOutStreamNames() {
        return this.outStreamNames;
    }

    public void setOutStreamNames(String string) {
        this.outStreamNames = string;
    }

    public boolean isReloadEntirePlaylist() {
        return this.reloadEntirePlaylist;
    }

    public void setReloadEntirePlaylist(boolean bl) {
        this.reloadEntirePlaylist = bl;
    }

    public boolean isHandleMediaCasters() {
        return this.handleMediaCasters;
    }

    public void setHandleMediaCasters(boolean bl) {
        this.handleMediaCasters = bl;
    }

    private class MediaCasterListener
    implements IMediaCasterNotify2 {
        private MediaCasterListener() {
        }

        public void onMediaCasterCreate(IMediaCaster iMediaCaster) {
        }

        public void onMediaCasterDestroy(IMediaCaster iMediaCaster) {
        }

        public void onRegisterPlayer(IMediaCaster iMediaCaster, IMediaStreamPlay iMediaStreamPlay) {
        }

        public void onUnRegisterPlayer(IMediaCaster iMediaCaster, IMediaStreamPlay iMediaStreamPlay) {
        }

        public void onSetSourceStream(IMediaCaster iMediaCaster, IMediaStream iMediaStream) {
        }

        public void onConnectStart(IMediaCaster iMediaCaster) {
        }

        public void onConnectSuccess(IMediaCaster iMediaCaster) {
        }

        public void onConnectFailure(IMediaCaster iMediaCaster) {
        }

        public void onStreamStart(IMediaCaster iMediaCaster) {
            String[] stringArray;
            String string = iMediaCaster.getStream().getName();
            for (String string2 : stringArray = ModuleLoopUntilLive.this.liveStreamNames.split(",")) {
                if (!string2.trim().equalsIgnoreCase(string)) continue;
                ModuleLoopUntilLive.getLogger().info("ModuleLoopUntilLive.MediaCasterListener.onStreamStop Swapping to live [" + string + "]");
                ModuleLoopUntilLive.this.swapToLive(string2);
                break;
            }
        }

        public void onStreamStop(IMediaCaster iMediaCaster) {
            String[] stringArray;
            String string = iMediaCaster.getStream().getName();
            for (String string2 : stringArray = ModuleLoopUntilLive.this.liveStreamNames.split(",")) {
                if (!string2.trim().equalsIgnoreCase(string)) continue;
                ModuleLoopUntilLive.getLogger().info("ModuleLoopUntilLive.MediaCasterListener.onStreamStop Swapping to playlist [" + string + "]");
                ModuleLoopUntilLive.this.swapToPlaylist(string2);
                break;
            }
        }
    }

    private class StreamListener
    implements IMediaStreamActionNotify {
        private StreamListener() {
        }

        public void onPublish(IMediaStream iMediaStream, String string, boolean bl, boolean bl2) {
            String[] stringArray;
            for (String string2 : stringArray = ModuleLoopUntilLive.this.liveStreamNames.split(",")) {
                if (!string2.trim().equalsIgnoreCase(string)) continue;
                if (ModuleLoopUntilLive.this.appInstance.getMediaCasterStreams().getMediaCaster(string) != null && ModuleLoopUntilLive.this.handleMediaCasters) {
                    ModuleLoopUntilLive.getLogger().info("ModuleLoopUntilLive.StreamListener.onPublish Stream is MediaCaster. Swapping handled by MediaCasterListener.onStreamStart [" + string + "]");
                    return;
                }
                ModuleLoopUntilLive.getLogger().info("ModuleLoopUntilLive.StreamListener.onPublish Swapping to live [" + string + "]");
                ModuleLoopUntilLive.this.swapToLive(string2);
                break;
            }
        }

        public void onUnPublish(IMediaStream iMediaStream, String string, boolean bl, boolean bl2) {
            String[] stringArray;
            for (String string2 : stringArray = ModuleLoopUntilLive.this.liveStreamNames.split(",")) {
                if (!string2.trim().equalsIgnoreCase(string)) continue;
                if (ModuleLoopUntilLive.this.appInstance.getMediaCasterStreams().getMediaCaster(string) != null && ModuleLoopUntilLive.this.handleMediaCasters) {
                    ModuleLoopUntilLive.getLogger().info("ModuleLoopUntilLive.onUnPublish Stream is MediaCaster. Swapping handled by MediaCasterListener.onStreamStop [" + string + "]");
                    return;
                }
                ModuleLoopUntilLive.getLogger().info("ModuleLoopUntilLive.StreamListener.onPublish Swapping to playlist [" + string + "]");
                ModuleLoopUntilLive.this.swapToPlaylist(string2);
                break;
            }
        }

        public void onPause(IMediaStream iMediaStream, boolean bl, double d) {
        }

        public void onPlay(IMediaStream iMediaStream, String string, double d, double d2, int n) {
        }

        public void onSeek(IMediaStream iMediaStream, double d) {
        }

        public void onStop(IMediaStream iMediaStream) {
        }
    }
}

