/*
 * Decompiled with CFR 0.152.
 */
package com.wowza.wms.plugin.collection.module;

import com.wowza.util.HTTPUtils;
import com.wowza.wms.amf.AMFDataList;
import com.wowza.wms.application.IApplicationInstance;
import com.wowza.wms.client.IClient;
import com.wowza.wms.httpstreamer.model.IHTTPStreamerSession;
import com.wowza.wms.mediareader.h264.MediaReaderH264;
import com.wowza.wms.mediareader.h264.atom.QTAtomtrak;
import com.wowza.wms.module.ModuleBase;
import com.wowza.wms.request.RequestFunction;
import com.wowza.wms.rtp.model.RTPSession;
import com.wowza.wms.stream.IMediaReader;
import com.wowza.wms.stream.IMediaReaderActionNotify;
import com.wowza.wms.stream.IMediaStream;
import java.util.Map;

public class ModuleMP4AudioChannelSelector
extends ModuleBase {
    public static final String PROPERTY_audioindex = "audioindex";
    public static final String PROPERTY_VIDEOINDEX = "videoindex";
    public static final String PROPERTY_DATAINDEX = "dataindex";
    public static final String[] PROPERTY_INDEXES = new String[]{"audioindex", "videoindex", "dataindex"};

    public void onAppStart(IApplicationInstance iApplicationInstance) {
        iApplicationInstance.addMediaReaderListener((IMediaReaderActionNotify)new MediaReaderListener());
    }

    public void play(IClient iClient, RequestFunction requestFunction, AMFDataList aMFDataList) {
        int n;
        String string = aMFDataList.getString(3);
        ModuleMP4AudioChannelSelector.getLogger().info("ModuleMediaReaderNotify.play: " + string);
        if (string != null && (n = string.indexOf("?")) >= 0) {
            String string2 = string.substring(n + 1);
            Map map = HTTPUtils.splitQueryStr((String)string2);
            for (int i = 0; i < PROPERTY_INDEXES.length; ++i) {
                String string3 = PROPERTY_INDEXES[i];
                if (!map.containsKey(string3)) continue;
                int n2 = -1;
                try {
                    n2 = Integer.parseInt((String)map.get(string3));
                }
                catch (Exception exception) {
                    // empty catch block
                }
                if (n2 < 0) continue;
                iClient.getProperties().setProperty(string3, (Object)new Integer(n2));
                ModuleMP4AudioChannelSelector.getLogger().info("  " + string3 + ": " + n2);
            }
        }
        this.invokePrevious(iClient, requestFunction, aMFDataList);
    }

    public void onHTTPSessionCreate(IHTTPStreamerSession iHTTPStreamerSession) {
        String string = iHTTPStreamerSession.getUri();
        String string2 = iHTTPStreamerSession.getQueryStr();
        ModuleMP4AudioChannelSelector.getLogger().info("ModuleMediaReaderNotify.onHTTPSessionCreate: " + string + " queryStr:" + string2);
        Map map = HTTPUtils.splitQueryStr((String)string2);
        for (int i = 0; i < PROPERTY_INDEXES.length; ++i) {
            String string3 = PROPERTY_INDEXES[i];
            if (!map.containsKey(string3)) continue;
            int n = -1;
            try {
                n = Integer.parseInt((String)map.get(string3));
            }
            catch (Exception exception) {
                // empty catch block
            }
            if (n < 0) continue;
            iHTTPStreamerSession.getProperties().setProperty(string3, (Object)new Integer(n));
            ModuleMP4AudioChannelSelector.getLogger().info("  " + string3 + ": " + n);
        }
    }

    public void onRTPSessionCreate(RTPSession rTPSession) {
        String string = rTPSession.getUri();
        String string2 = rTPSession.getQueryStr();
        ModuleMP4AudioChannelSelector.getLogger().info("ModuleMediaReaderNotify.onRTPSessionCreate: " + string + " queryStr:" + string2);
        Map map = HTTPUtils.splitQueryStr((String)string2);
        for (int i = 0; i < PROPERTY_INDEXES.length; ++i) {
            String string3 = PROPERTY_INDEXES[i];
            if (!map.containsKey(string3)) continue;
            int n = -1;
            try {
                n = Integer.parseInt((String)map.get(string3));
            }
            catch (Exception exception) {
                // empty catch block
            }
            if (n < 0) continue;
            rTPSession.getProperties().setProperty(string3, (Object)new Integer(n));
            ModuleMP4AudioChannelSelector.getLogger().info("  " + string3 + ": " + n);
        }
    }

    class MediaReaderListener
    implements IMediaReaderActionNotify {
        MediaReaderListener() {
        }

        public void onMediaReaderCreate(IMediaReader iMediaReader) {
            ModuleMP4AudioChannelSelector.getLogger().info("ModuleMediaReaderNotify#MediaReaderListener.onMediaReaderCreate");
        }

        public void onMediaReaderInit(IMediaReader iMediaReader, IMediaStream iMediaStream) {
            ModuleMP4AudioChannelSelector.getLogger().info("ModuleMediaReaderNotify#MediaReaderListener.onMediaReaderInit: " + iMediaStream.getName());
        }

        public void onMediaReaderOpen(IMediaReader iMediaReader, IMediaStream iMediaStream) {
            block25: {
                Integer n;
                Integer n2;
                Integer n3;
                ModuleMP4AudioChannelSelector.getLogger().info("ModuleMediaReaderNotify#MediaReaderListener.onMediaReaderOpen: " + iMediaStream.getName());
                IClient iClient = null;
                RTPSession rTPSession = null;
                IHTTPStreamerSession iHTTPStreamerSession = null;
                try {
                    iClient = iMediaStream.getClient();
                }
                catch (Exception exception) {
                    // empty catch block
                }
                try {
                    rTPSession = iMediaStream.getRTPStream().getSession();
                }
                catch (Exception exception) {
                    // empty catch block
                }
                try {
                    iHTTPStreamerSession = iMediaStream.getHTTPStreamerSession();
                }
                catch (Exception exception) {
                    // empty catch block
                }
                if (iClient == null && rTPSession == null && iHTTPStreamerSession == null) break block25;
                int n4 = -1;
                int n5 = -1;
                int n6 = -1;
                if (iClient != null) {
                    n3 = (Integer)iClient.getProperties().getProperty(ModuleMP4AudioChannelSelector.PROPERTY_audioindex);
                    n2 = (Integer)iClient.getProperties().getProperty(ModuleMP4AudioChannelSelector.PROPERTY_VIDEOINDEX);
                    n = (Integer)iClient.getProperties().getProperty(ModuleMP4AudioChannelSelector.PROPERTY_DATAINDEX);
                    if (n3 != null) {
                        n4 = n3;
                    }
                    if (n2 != null) {
                        n5 = n2;
                    }
                    if (n != null) {
                        n6 = n;
                    }
                }
                if (rTPSession != null) {
                    n3 = (Integer)rTPSession.getProperties().getProperty(ModuleMP4AudioChannelSelector.PROPERTY_audioindex);
                    n2 = (Integer)rTPSession.getProperties().getProperty(ModuleMP4AudioChannelSelector.PROPERTY_VIDEOINDEX);
                    n = (Integer)rTPSession.getProperties().getProperty(ModuleMP4AudioChannelSelector.PROPERTY_DATAINDEX);
                    if (n3 != null) {
                        n4 = n3;
                    }
                    if (n2 != null) {
                        n5 = n2;
                    }
                    if (n != null) {
                        n6 = n;
                    }
                }
                if (iHTTPStreamerSession != null) {
                    n3 = (Integer)iHTTPStreamerSession.getProperties().getProperty(ModuleMP4AudioChannelSelector.PROPERTY_audioindex);
                    n2 = (Integer)iHTTPStreamerSession.getProperties().getProperty(ModuleMP4AudioChannelSelector.PROPERTY_VIDEOINDEX);
                    n = (Integer)iHTTPStreamerSession.getProperties().getProperty(ModuleMP4AudioChannelSelector.PROPERTY_DATAINDEX);
                    if (n3 != null) {
                        n4 = n3;
                    }
                    if (n2 != null) {
                        n5 = n2;
                    }
                    if (n != null) {
                        n6 = n;
                    }
                }
                if (iMediaReader instanceof MediaReaderH264) {
                    int n7;
                    long l;
                    int n8;
                    n3 = (MediaReaderH264)iMediaReader;
                    int n9 = n3.getTrackCountAudio();
                    for (n8 = 0; n8 < n9; ++n8) {
                        String string = n3.getTrackLanguageAudio(n8);
                        l = n3.getTrackAudioTrackId(n8);
                        QTAtomtrak qTAtomtrak = n3.getTrackAudioAtom(n8);
                        ModuleMP4AudioChannelSelector.getLogger().info("  audio[" + n8 + "]: trackId:" + l + " lang:" + string + " more:" + qTAtomtrak.getTkhdAtom().toString());
                    }
                    n8 = n3.getTrackCountVideo();
                    for (n7 = 0; n7 < n8; ++n7) {
                        l = n3.getTrackVideoTrackId(n7);
                        long l2 = n3.getTrackVideoWidth(n7);
                        long l3 = n3.getTrackVideoHeight(n7);
                        QTAtomtrak qTAtomtrak = n3.getTrackVideoAtom(n7);
                        ModuleMP4AudioChannelSelector.getLogger().info("  video[" + n7 + "]: trackId:" + l + " width:" + l2 + " height:" + l3 + " more:" + qTAtomtrak.getTkhdAtom().toString());
                    }
                    n7 = n3.getTrackCountData();
                    for (int i = 0; i < n7; ++i) {
                        String string = n3.getTrackLanguageData(i);
                        long l4 = n3.getTrackDataTrackId(i);
                        QTAtomtrak qTAtomtrak = n3.getTrackDataAtom(i);
                        ModuleMP4AudioChannelSelector.getLogger().info("  data[" + i + "]: trackId:" + l4 + " lang:" + string + " more:" + qTAtomtrak.getTkhdAtom().toString());
                    }
                    if (n4 >= 0) {
                        ModuleMP4AudioChannelSelector.getLogger().info("  setTrackIndexAudio: " + n4);
                        n3.setTrackIndexAudio(n4);
                    }
                    if (n5 >= 0) {
                        ModuleMP4AudioChannelSelector.getLogger().info("  setTrackIndexVideo: " + n5);
                        n3.setTrackIndexVideo(n5);
                    }
                    if (n6 >= 0) {
                        ModuleMP4AudioChannelSelector.getLogger().info("  setTrackIndexData: " + n6);
                        n3.setTrackIndexData(n6);
                    }
                }
            }
        }

        public void onMediaReaderExtractMetaData(IMediaReader iMediaReader, IMediaStream iMediaStream) {
            ModuleMP4AudioChannelSelector.getLogger().info("ModuleMediaReaderNotify#MediaReaderListener.onMediaReaderExtractMetaData: " + iMediaStream.getName());
        }

        public void onMediaReaderClose(IMediaReader iMediaReader, IMediaStream iMediaStream) {
            ModuleMP4AudioChannelSelector.getLogger().info("ModuleMediaReaderNotify#MediaReaderListener.onMediaReaderClose: " + iMediaStream.getName());
        }
    }
}

