/*
 * Decompiled with CFR 0.152.
 */
package com.wowza.wms.plugin.collection.module;

import com.wowza.wms.amf.AMFPacket;
import com.wowza.wms.application.IApplicationInstance;
import com.wowza.wms.application.WMSProperties;
import com.wowza.wms.module.ModuleBase;
import com.wowza.wms.stream.IMediaStream;
import com.wowza.wms.stream.IMediaStreamActionNotify2;
import com.wowza.wms.stream.MediaStreamMap;
import java.util.Date;
import java.util.List;
import java.util.Timer;
import java.util.TimerTask;

public class ModuleStreamWatchDog
extends ModuleBase {
    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void onStreamCreate(IMediaStream iMediaStream) {
        WMSProperties wMSProperties;
        ModuleStreamWatchDog.getLogger().info("onStreamCreate by: " + iMediaStream.getClientId());
        StreamListener streamListener = new StreamListener();
        WMSProperties wMSProperties2 = wMSProperties = iMediaStream.getProperties();
        synchronized (wMSProperties2) {
            wMSProperties.put((Object)"streamActionNotifier", (Object)streamListener);
        }
        iMediaStream.addClientListener((IMediaStreamActionNotify2)streamListener);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void onStreamDestroy(IMediaStream iMediaStream) {
        WMSProperties wMSProperties;
        ModuleStreamWatchDog.getLogger().info("onStreamDestroy by: " + iMediaStream.getClientId());
        IMediaStreamActionNotify2 iMediaStreamActionNotify2 = null;
        WMSProperties wMSProperties2 = wMSProperties = iMediaStream.getProperties();
        synchronized (wMSProperties2) {
            iMediaStreamActionNotify2 = (IMediaStreamActionNotify2)iMediaStream.getProperties().get((Object)"streamActionNotifier");
        }
        if (iMediaStreamActionNotify2 != null) {
            iMediaStream.removeClientListener(iMediaStreamActionNotify2);
            ModuleStreamWatchDog.getLogger().info("removeClientListener: " + iMediaStream.getSrc());
        }
    }

    private class StreamWatchDog {
        public Timer mTimer;
        public TimerTask mTask;
        public String streamName;
        public IApplicationInstance appInstance;
        long streamLastSeq;
        boolean isMissing = false;
        long currSeq = 0L;
        String msg;

        public StreamWatchDog() {
            this.mTask = new TimerTask(){

                public void run() {
                    ModuleStreamWatchDog.getLogger().info("Run StreamWatchDog");
                    MediaStreamMap mediaStreamMap = StreamWatchDog.this.appInstance.getStreams();
                    IMediaStream iMediaStream = mediaStreamMap.getStream(StreamWatchDog.this.streamName);
                    List list = iMediaStream.getPlayPackets();
                    if (list.size() == 0) {
                        StreamWatchDog.this.msg = "Stream not started";
                    } else {
                        AMFPacket aMFPacket = (AMFPacket)list.get(list.size() - 1);
                        StreamWatchDog.this.currSeq = aMFPacket.getSeq();
                        if (StreamWatchDog.this.currSeq != StreamWatchDog.this.streamLastSeq) {
                            StreamWatchDog.this.streamLastSeq = StreamWatchDog.this.currSeq;
                            StreamWatchDog.this.msg = "Stream OK";
                        } else {
                            StreamWatchDog.this.msg = "Stream Appears Stalled";
                        }
                    }
                    StreamWatchDog.this.appInstance.broadcastMsg("streamStats", new Object[]{StreamWatchDog.this.streamName, StreamWatchDog.this.currSeq, StreamWatchDog.this.msg, new Date()});
                }
            };
        }

        public void start() {
            if (this.mTimer == null) {
                this.mTimer = new Timer();
            }
            this.mTimer.schedule(this.mTask, 10000L, 10000L);
            ModuleStreamWatchDog.getLogger().info("Start StreamWatchDog");
        }

        public void stop() {
            if (this.mTimer != null) {
                this.mTimer.cancel();
                this.mTimer = null;
                ModuleStreamWatchDog.getLogger().info("Stop StreamWatchDog");
            }
        }
    }

    class StreamListener
    implements IMediaStreamActionNotify2 {
        StreamListener() {
        }

        public void onPlay(IMediaStream iMediaStream, String string, double d, double d2, int n) {
            string = iMediaStream.getName();
            ModuleStreamWatchDog.getLogger().info("Stream Name: " + string);
        }

        public void onMetaData(IMediaStream iMediaStream, AMFPacket aMFPacket) {
            ModuleStreamWatchDog.getLogger().info("onMetaData By: " + iMediaStream.getClientId());
        }

        public void onPauseRaw(IMediaStream iMediaStream, boolean bl, double d) {
            ModuleStreamWatchDog.getLogger().info("onPauseRaw By: " + iMediaStream.getClientId());
        }

        public void onSeek(IMediaStream iMediaStream, double d) {
            ModuleStreamWatchDog.getLogger().info("onSeek");
        }

        public void onStop(IMediaStream iMediaStream) {
            ModuleStreamWatchDog.getLogger().info("onStop By: " + iMediaStream.getClientId());
        }

        public void onUnPublish(IMediaStream iMediaStream, String string, boolean bl, boolean bl2) {
            ModuleStreamWatchDog.getLogger().info("onUNPublish");
            StreamWatchDog streamWatchDog = (StreamWatchDog)iMediaStream.getClient().getAppInstance().getProperties().getProperty(string);
            if (streamWatchDog != null) {
                streamWatchDog.stop();
            }
        }

        public void onPublish(IMediaStream iMediaStream, String string, boolean bl, boolean bl2) {
            ModuleStreamWatchDog.getLogger().info("onPublish - stream name: " + iMediaStream.getName());
            ModuleStreamWatchDog.getLogger().info("query string: " + iMediaStream.getQueryStr());
            ModuleStreamWatchDog.getLogger().info("video codec: " + iMediaStream.getPublishVideoCodecId());
            StreamWatchDog streamWatchDog = new StreamWatchDog();
            try {
                streamWatchDog.appInstance = iMediaStream.getClient().getAppInstance();
                streamWatchDog.streamName = string;
                streamWatchDog.start();
                iMediaStream.getClient().getAppInstance().getProperties().setProperty(string, (Object)streamWatchDog);
            }
            catch (Exception exception) {
                // empty catch block
            }
        }

        public void onPause(IMediaStream iMediaStream, boolean bl, double d) {
            ModuleStreamWatchDog.getLogger().info("onPause");
        }
    }
}

