/*
 * Decompiled with CFR 0.152.
 */
package com.wowza.wms.plugin.collection.oldcode;

import com.wowza.wms.application.IApplication;
import com.wowza.wms.application.IApplicationInstance;
import com.wowza.wms.logging.WMSLogger;
import com.wowza.wms.logging.WMSLoggerFactory;
import com.wowza.wms.server.IServer;
import com.wowza.wms.server.IServerNotify;
import com.wowza.wms.stream.publish.IStreamActionNotify;
import com.wowza.wms.stream.publish.Playlist;
import com.wowza.wms.stream.publish.PlaylistItem;
import com.wowza.wms.stream.publish.Stream;
import com.wowza.wms.vhost.IVHost;
import com.wowza.wms.vhost.VHostSingleton;
import java.io.File;
import java.text.DateFormat;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.HashMap;
import java.util.Map;
import java.util.Timer;
import java.util.TimerTask;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public class ServerListenerStreamPublisher
implements IServerNotify {
    WMSLogger log = WMSLoggerFactory.getLogger(null);
    Map<String, Stream> streamMap = new HashMap<String, Stream>();
    Map<String, Playlist> playlistMap = new HashMap<String, Playlist>();

    public void onServerInit(IServer iServer) {
        this.log.info("ServerListenerStreamPublisher Started.");
        IVHost iVHost = null;
        IApplication iApplication = null;
        try {
            iVHost = VHostSingleton.getInstance((String)iServer.getProperties().getPropertyStr("PublishToVHost", "_defaultVHost_"));
        }
        catch (Exception exception) {
            this.log.info("ServerListenerStreamPublisher: Failed to get Vhost can not run.");
            return;
        }
        try {
            iApplication = iVHost.getApplication(iServer.getProperties().getPropertyStr("PublishToApplication", "live"));
        }
        catch (Exception exception) {
            this.log.info("ServerListenerStreamPublisher: Failed to get Application can not run.");
            return;
        }
        if (iVHost == null || iApplication == null) {
            this.log.info("ServerListenerStreamPublisher: VHost or Application failed, not running.");
            return;
        }
        Boolean bl = iServer.getProperties().getPropertyBoolean("PassthruMetaData", true);
        bl = iApplication.getAppInstance("_definst_").getProperties().getPropertyBoolean("", bl.booleanValue());
        String string = iApplication.getAppInstance("_definst_").getProperties().getPropertyStr("", "streamschedule.smil");
        String string2 = iApplication.getAppInstance("_definst_").getStreamStorageDir();
        try {
            NodeList nodeList;
            Object object;
            Node node;
            String string3 = string2 + "/" + string;
            File file = new File(string3);
            if (!file.exists()) {
                this.log.info("ServerListenerStreamPublisher: Could not find playlist file: " + string3);
                return;
            }
            DocumentBuilderFactory documentBuilderFactory = DocumentBuilderFactory.newInstance();
            DocumentBuilder documentBuilder = null;
            Document document = null;
            try {
                documentBuilder = documentBuilderFactory.newDocumentBuilder();
                document = documentBuilder.parse("file:///" + string3);
            }
            catch (Exception exception) {
                this.log.info("ServerListenerStreamPublisher: XML Parse failed");
                return;
            }
            document.getDocumentElement().normalize();
            NodeList nodeList2 = document.getElementsByTagName("stream");
            for (int i = 0; i < nodeList2.getLength(); ++i) {
                Node node2 = nodeList2.item(i);
                if (node2.getNodeType() != 1) continue;
                node = (Element)node2;
                object = node.getAttribute("name");
                this.log.info("ServerListenerStreamPublisher: Streame name is '" + (String)object + "'");
                nodeList = Stream.createInstance((IVHost)iVHost, (String)iApplication.getName(), (String)object);
                this.streamMap.put((String)object, (Stream)nodeList);
                iApplication.getAppInstance("_definst_").getProperties().setProperty((String)object, (Object)nodeList);
            }
            NodeList nodeList3 = document.getElementsByTagName("playlist");
            if (nodeList3.getLength() == 0) {
                this.log.info("ServerListenerStreamPublisher: No playlists defined in smil file");
                return;
            }
            for (int i = 0; i < nodeList3.getLength(); ++i) {
                Object object2;
                Object object3;
                String string4;
                Object object4;
                Object object5;
                node = nodeList3.item(i);
                if (node.getNodeType() != 1) continue;
                object = (Element)node;
                nodeList = object.getElementsByTagName("video");
                if (nodeList.getLength() == 0) {
                    this.log.info("ServerListenerStreamPublisher: No videos defined in stream");
                    return;
                }
                String string5 = object.getAttribute("playOnStream");
                if (string5.length() == 0) continue;
                Playlist playlist = new Playlist(string5);
                playlist.setRepeat(!object.getAttribute("repeat").equals("false"));
                this.playlistMap.put(object.getAttribute("name"), playlist);
                for (int j = 0; j < nodeList.getLength(); ++j) {
                    object5 = nodeList.item(j);
                    if (object5.getNodeType() != 1) continue;
                    object4 = (Element)object5;
                    string4 = object4.getAttribute("src");
                    object3 = Integer.parseInt(object4.getAttribute("start"));
                    object2 = Integer.parseInt(object4.getAttribute("length"));
                    playlist.addItem(string4, ((Integer)object3).intValue(), ((Integer)object2).intValue());
                }
                String string6 = object.getAttribute("scheduled");
                object5 = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
                object4 = null;
                try {
                    object4 = ((DateFormat)object5).parse(string6);
                }
                catch (Exception exception) {
                    this.log.info("Parsing schedule time failed.");
                    return;
                }
                string4 = this.streamMap.get(string5);
                string4.setSendOnMetadata(bl.booleanValue());
                object3 = new ScheduledItem((Date)object4, playlist, (Stream)string4);
                ((ScheduledItem)object3).start();
                object2 = new StreamListener(iApplication.getAppInstance("_definst_"));
                string4.addListener((IStreamActionNotify)object2);
                this.log.info("ServerListenerStreamPublisher Scheduled: " + string4.getName() + " for: " + string6);
            }
        }
        catch (Exception exception) {
            this.log.info("ServerListenerStreamPublisher: Error from playlist manager is '" + exception.getMessage() + "'");
        }
    }

    public void onServerCreate(IServer iServer) {
    }

    public void onServerShutdownComplete(IServer iServer) {
        Stream exception;
        this.log.info("ServerListenerStreamPublisher: Shutdown server start");
        for (Map.Entry<String, Stream> entry : this.streamMap.entrySet()) {
            try {
                exception = entry.getValue();
                exception.close();
                exception = null;
                this.log.info("ServerListenerStreamPublisher Closed Stream: " + entry.getKey());
            }
            catch (Exception exception2) {
                this.log.error(exception2.getMessage());
            }
        }
        for (Map.Entry<String, Stream> entry : this.playlistMap.entrySet()) {
            try {
                exception = (Playlist)entry.getValue();
                exception = null;
            }
            catch (Exception exception3) {
                this.log.error(exception3.getMessage());
            }
        }
    }

    public void onServerShutdownStart(IServer iServer) {
    }

    class StreamListener
    implements IStreamActionNotify {
        StreamListener(IApplicationInstance iApplicationInstance) {
        }

        public void onPlaylistItemStart(Stream stream, PlaylistItem playlistItem) {
            try {
                String string = stream.getCurrentItem().getName();
                stream.getPublisher().getAppInstance().broadcastMsg("PlaylistItemStart", new Object[]{string});
                WMSLoggerFactory.getLogger(null).info("ServerListenerStreamPublisher PlayList Item Start: " + string);
            }
            catch (Exception exception) {
                WMSLoggerFactory.getLogger(null).info("ServerListenerStreamPublisher Get Item error: " + exception.getMessage());
            }
        }

        public void onPlaylistItemStop(Stream stream, PlaylistItem playlistItem) {
            if (playlistItem.getIndex() == stream.getPlaylist().size() - 1 && !stream.getRepeat()) {
                stream.close();
                WMSLoggerFactory.getLogger(null).info("ServerListenerStreamPublisher: closing stream: " + stream.getName());
            }
        }
    }

    private class ScheduledItem {
        public Timer mTimer;
        public TimerTask mTask;
        public Date mStart;
        public Playlist mPL;
        public Stream mStream;

        public ScheduledItem(Date date, Playlist playlist, Stream stream) {
            this.mStart = date;
            this.mPL = playlist;
            this.mStream = stream;
            this.mTask = new TimerTask(){

                public void run() {
                    ScheduledItem.this.mPL.open(ScheduledItem.this.mStream);
                    ServerListenerStreamPublisher.this.log.info("ServerListenerStreamPublisher Scheduled stream is now live: " + ScheduledItem.this.mStream.getName());
                }
            };
            this.mTimer = new Timer();
        }

        public void start() {
            if (this.mTimer == null) {
                this.mTimer = new Timer();
            }
            this.mTimer.schedule(this.mTask, this.mStart);
            ServerListenerStreamPublisher.this.log.info("scheduled playlist: " + this.mPL.getName() + " on stream: " + this.mStream.getName() + " for:" + this.mStart.toString());
        }

        public void stop() {
            if (this.mTimer != null) {
                this.mTimer.cancel();
                this.mTimer = null;
                ServerListenerStreamPublisher.this.log.info("cancelled playlist: " + this.mPL.getName() + " on stream: " + this.mStream.getName() + " for:" + this.mStart.toString());
            }
        }
    }
}

