/**
 * Wowza Media Server and all components Copyright 2006 - 2013, Wowza Media Systems, LLC, licensed pursuant to the Wowza Media Software End User License Agreement.
 */
package com.wowza.wms.plugin.collection.module;

import com.wowza.wms.amf.*;
import com.wowza.wms.client.*;
import com.wowza.wms.module.*;
import com.wowza.wms.request.*;
import com.wowza.wms.stream.*;
import com.wowza.wms.util.*;
import com.wowza.wms.application.*;

public class ModuleBlockDuplicateStreamNames extends ModuleBase
{
	IApplicationInstance appInstance = null;
	
	public void onAppStart(IApplicationInstance appInstance)
	{
		this.appInstance = appInstance;
	}
	
	public void publish(IClient client, RequestFunction function, AMFDataList params)
	{
		String streamName = extractStreamName(client, function, params);
		if (isDuplicateStream(client, streamName))
		{
			getLogger().info("ModuleBlockDuplicateStreamNames.publish["+appInstance.getContextStr()+"]: Stream name is already in use: "+streamName);
			IMediaStream stream = getStream(client, function);
			sendStreamOnStatusError(stream, "NetStream.Publish.BadName", "Stream name is already in use: "+streamName);
		}
		else
			invokePrevious(client, function, params);
	}

	public void releaseStream(IClient client, RequestFunction function, AMFDataList params)
	{
		String streamName = extractStreamName(client, function, params);
		if (!isDuplicateStream(client, streamName))
			invokePrevious(client, function, params);
	}

	public String extractStreamName(IClient client, RequestFunction function, AMFDataList params)
	{
		String streamName = params.getString(PARAM1);
		if (streamName != null)
		{
			String streamExt = MediaStream.BASE_STREAM_EXT;
			
			String[] streamDecode = ModuleUtils.decodeStreamExtension(streamName, streamExt);
			streamName = streamDecode[0];
			streamExt = streamDecode[1];
			
			streamName = streamName.split("\\?")[0];
		}

		return streamName;
	}
	
	public boolean isDuplicateStream(IClient client, String streamName)
	{
		if (streamName != null)
			return client.getAppInstance().getStreams().getStream(streamName) != null;
		
		return false;
	}

}
