/**
 * Wowza Media Server and all components Copyright 2006 - 2013, Wowza Media Systems, LLC, licensed pursuant to the Wowza Media Software End User License Agreement.
 */
package com.wowza.wms.plugin.collection.module;
// com.wowza.wms.plugin.collection.module.ModuleClientBWCheck
import com.wowza.util.IOPerformanceCounter;
import com.wowza.wms.amf.*;
import com.wowza.wms.client.*;
import com.wowza.wms.module.*;
import com.wowza.wms.request.*;

public class ModuleClientBWCheck extends ModuleBase {
	
	static public void onClientBWCheck(IClient p_client, RequestFunction function, AMFDataList params) {
        getLogger().info("onClientBWCheck");
        AMFDataObj statValues = new AMFDataObj();;
        
        IOPerformanceCounter stats = p_client.getTotalIOPerformanceCounter();
        
        statValues.put("cOutBytes", new AMFDataItem(stats.getMessagesInBytes()));
        statValues.put("cInBytes", new AMFDataItem(stats.getMessagesOutBytes()));
        statValues.put("time", new AMFDataItem(params.getLong(PARAM1)));
        
        sendResult(p_client, params, statValues);
    }
}
