/**
 * Wowza Media Server and all components Copyright 2006 - 2013, Wowza Media Systems, LLC, licensed pursuant to the Wowza Media Software End User License Agreement.
 */
package com.wowza.wms.plugin.collection.module;

// com.wowza.wms.plugin.collection.module.ModuleCupertinoLiveAttachPicture
import java.io.*;
import com.wowza.wms.module.*;
import com.wowza.wms.application.*;
import com.wowza.wms.httpstreamer.cupertinostreaming.livestreampacketizer.*;
import com.wowza.wms.media.mp3.model.idtags.*;
import com.wowza.wms.stream.livepacketizer.*;

public class ModuleCupertinoLiveAttachPicture extends ModuleBase
{
	public static final String[] extensions = {".jpg", ".jpeg", ".png"};
	
	Boolean debugLogging = false;
	
	class LiveActionNotify implements ILiveStreamPacketizerActionNotify
	{
		private IApplicationInstance appInstance = null;
		
		public LiveActionNotify(IApplicationInstance appInstance)
		{
			this.appInstance = appInstance;
		}

		public void onLiveStreamPacketizerCreate(ILiveStreamPacketizer liveStreamPacketizer, String streamName)
		{
		}

		public void onLiveStreamPacketizerDestroy(ILiveStreamPacketizer liveStreamPacketizer)
		{
		}

		public void onLiveStreamPacketizerInit(ILiveStreamPacketizer liveStreamPacketizer, String streamName)
		{
			while(true)
			{
				if (!(liveStreamPacketizer instanceof LiveStreamPacketizerCupertino))
					break;
				
				LiveStreamPacketizerCupertino cupertinoPacketizer = (LiveStreamPacketizerCupertino)liveStreamPacketizer;
				
				ID3Frames id3HeaderAudio = cupertinoPacketizer.getID3FramesHeaderAudio();
				
				if (id3HeaderAudio == null)
					break;

				String storagePath = appInstance.getStreamStoragePath();
				
				File file = null;
				for(int i=0;i<extensions.length;i++)
				{
					file  = new File(storagePath+"/"+streamName+extensions[i]);
					if (file.exists())
						break;
					else
						file = null;
				}
				
				if (file == null)
					break;

				ID3V2FrameAttachedPicture attachedPicture = new ID3V2FrameAttachedPicture();
				boolean success = attachedPicture.loadFile(file);
				
				if (debugLogging)
					getLogger().info("ModuleCupertinoVODAttachPicture.succes: " + success);
				
				if (success)
				{
					id3HeaderAudio.putFrame(attachedPicture);
					
					if (debugLogging)
						getLogger().info("ModuleCupertinoVODAttachPicture.picture: " + file.getName());
				}
				break;
			}
		}
	}

	public void onAppStart(IApplicationInstance appInstance)
	{
		debugLogging = appInstance.getProperties().getPropertyBoolean("debugLoggingPosterFrames", false);
		
		appInstance.addLiveStreamPacketizerListener(new LiveActionNotify(appInstance));
		getLogger().info("ModuleCupertinoLiveAttachPicture.onAppStart["+appInstance.getContextStr()+"]");
	}
	
	public void onAppStop(IApplicationInstance appInstance)
	{
		getLogger().info("ModuleCupertinoLiveAttachPicture.onAppStop["+appInstance.getContextStr()+"]");
	}
}
