/**
 * Wowza Media Server and all components Copyright 2006 - 2013, Wowza Media Systems, LLC, licensed pursuant to the Wowza Media Software End User License Agreement.
 */
package com.wowza.wms.plugin.collection.module;

import java.io.*;

import com.wowza.wms.httpstreamer.model.*;
import com.wowza.wms.module.*;
import com.wowza.wms.application.*;
import com.wowza.wms.httpstreamer.cupertinostreaming.file.*;
import com.wowza.wms.httpstreamer.cupertinostreaming.httpstreamer.*;
import com.wowza.wms.httpstreamer.cupertinostreaming.livestreampacketizer.*;
import com.wowza.wms.media.mp3.model.idtags.*;

public class ModuleCupertinoVODAttachPicture extends ModuleBase
{
	public static final String[] extensions = {".jpg", ".jpeg", ".png"};
	
	Boolean debugLogging = false;
	
	class VODActionNotify implements IHTTPStreamerCupertinoVODActionNotify
	{
		IApplicationInstance appInstance = null;
		
		public VODActionNotify(IApplicationInstance appInstance)
		{
			this.appInstance = appInstance;
		}
		
		public void onCreate(IHTTPStreamerCupertinoIndex fileIndex, IHTTPStreamerApplicationContext appContext, IHTTPStreamerSession httpStreamerSession, String rawStreamName, String streamExt,
				String streamName)
		{
		}

		public void onInit(IHTTPStreamerCupertinoIndex fileIndex, IHTTPStreamerApplicationContext appContext, IHTTPStreamerSession httpStreamerSession, String rawStreamName, String streamExt,
				String streamName)
		{
		}

		public void onOpen(IHTTPStreamerCupertinoIndex fileIndex, IHTTPStreamerApplicationContext appContext, IHTTPStreamerSession httpStreamerSession, String rawStreamName, String streamExt,
				String streamName)
		{
		}

		public void onIndex(IHTTPStreamerCupertinoIndex fileIndex, IHTTPStreamerApplicationContext appContext, IHTTPStreamerSession httpStreamerSession, String rawStreamName, String streamExt,
				String streamName)
		{
			System.out.println("ModuleCupertinoVODAttachPicture.onIndex IHTTPStreamerCupertinoIndex "+fileIndex+", IHTTPStreamerApplicationContext "+appContext+", IHTTPStreamerSession "+httpStreamerSession+", String "+rawStreamName+", String "+streamExt+", String "+streamName);
			
			while(true)
			{
				ID3Frames id3HeaderAudio = fileIndex.getStreamMode()==LiveStreamPacketizerCupertino.STREAMMODE_TS?fileIndex.getID3FramesHeaderAudio():fileIndex.getID3FramesHeader();
				
				if (id3HeaderAudio == null)
					break;

				String storagePath = appInstance.getStreamStoragePath();
				
				File file = null;
				for(int i=0;i<extensions.length;i++)
				{
					file  = new File(storagePath+"/"+streamName+extensions[i]);
					if (file.exists())
						break;
					else
						file = null;
				}
				
				if (file == null)
					break;

				ID3V2FrameAttachedPicture attachedPicture = new ID3V2FrameAttachedPicture();
				boolean success = attachedPicture.loadFile(file);
				
				if (debugLogging)
					getLogger().info("ModuleCupertinoVODAttachPicture.succes: " + success);
				
				if (success)
				{
					id3HeaderAudio.putFrame(attachedPicture);
					
					if (debugLogging)
						getLogger().info("ModuleCupertinoVODAttachPicture.picture: " + file.getName());
				}
				break;
			}
		}

		public void onFillChunkStart(IHTTPStreamerCupertinoIndex fileIndex, IHTTPStreamerCupertinoIndexItem item, LiveStreamPacketizerCupertinoChunk chunk, boolean audioOnly)
		{
		}

		public void onFillChunkEnd(IHTTPStreamerCupertinoIndex fileIndex, IHTTPStreamerCupertinoIndexItem item, LiveStreamPacketizerCupertinoChunk chunk, boolean audioOnly)
		{
		}

		public void onDestroy(IHTTPStreamerCupertinoIndex fileIndex)
		{
		}
	}
	
	public void onAppStart(IApplicationInstance appInstance)
	{
		debugLogging = appInstance.getProperties().getPropertyBoolean("debugLoggingPosterFrames", false);
		
		while(true)
		{
			IHTTPStreamerApplicationContext appContext = appInstance.getHTTPStreamerApplicationContext("cupertinostreaming", true);
			if (appContext == null)
				break;
			
			if (!(appContext instanceof HTTPStreamerApplicationContextCupertinoStreamer))
				break;
			
			HTTPStreamerApplicationContextCupertinoStreamer cupertinoAppContext = (HTTPStreamerApplicationContextCupertinoStreamer)appContext;
			cupertinoAppContext.addVODActionListener(new VODActionNotify(appInstance));
			break;
		}

		getLogger().info("ModuleCupertinoVODAttachPicture.onAppStart["+appInstance.getContextStr()+"]");
	}
	
	public void onAppStop(IApplicationInstance appInstance)
	{
		getLogger().info("ModuleCupertinoVODAttachPicture.onAppStop["+appInstance.getContextStr()+"]");
	}
}
