/**
 * Wowza Media Server and all components Copyright 2006 - 2013, Wowza Media Systems, LLC, licensed pursuant to the Wowza Media Software End User License Agreement.
 */
package com.wowza.wms.plugin.collection.module;

import com.wowza.util.*;
import com.wowza.wms.http.*;
import com.wowza.wms.httpstreamer.cupertinostreaming.httpstreamer.*;
import com.wowza.wms.module.*;
import com.wowza.wms.application.*;

public class ModuleEncryptionHandlerCupertinoStreaming extends ModuleBase
{
	public void onHTTPCupertinoEncryptionKeyRequest(HTTPStreamerSessionCupertino httpCupertinoStreamingSession, IHTTPRequest req, IHTTPResponse resp)
	{
		boolean isGood = true;
		
		String ipAddress = httpCupertinoStreamingSession.getIpAddress();
		String queryStr = req.getQueryString();
		String referrer = httpCupertinoStreamingSession.getReferrer();
		String cookieStr = httpCupertinoStreamingSession.getCookieStr();
		String userAgent = httpCupertinoStreamingSession.getUserAgent();
		String sessionId = httpCupertinoStreamingSession.getSessionId();
		
		IApplicationInstance appInstance = httpCupertinoStreamingSession.getAppInstance();
		String streamName = httpCupertinoStreamingSession.getStreamName();
		
		// reject encryption key requests that are not delivered over SSL
		//if (!req.isSecure())
		//	isGood = false;

		getLogger().info("ModuleEncryptionHandlerCupertinoStreaming.onHTTPCupertinoEncryptionKeyRequest["+appInstance.getContextStr()+"/"+httpCupertinoStreamingSession.getStreamName()+"]: accept:"+isGood);
		
		if (!isGood)
			httpCupertinoStreamingSession.rejectSession();
	}
	
	public void onHTTPCupertinoEncryptionKeyCreateLive(IApplicationInstance appInstance, String streamName, byte[] encKey)
	{
		String mySharedSecret = appInstance.getProperties().getPropertyStr("cupertinoEncryptionSharedSecret", "");
		
		String hashStr = mySharedSecret+":"+appInstance.getApplication().getName()+":"+appInstance.getName()+":"+streamName;

		byte[] tmpBytes = MD5DigestUtils.generateHashBytes(hashStr);
		if (tmpBytes != null)
			System.arraycopy(tmpBytes, 0, encKey, 0, encKey.length);
		
		getLogger().info("ModuleEncryptionHandlerCupertinoStreaming.onHTTPCupertinoEncryptionKeyCreateLive["+appInstance.getContextStr()+"/"+streamName+"]: *"+BufferUtils.encodeHexString(encKey).substring(28));
	}

	public void onHTTPCupertinoEncryptionKeyCreateVOD(HTTPStreamerSessionCupertino httpCupertinoStreamingSession, byte[] encKey)
	{
		String ipAddress = httpCupertinoStreamingSession.getIpAddress();
		String queryStr = httpCupertinoStreamingSession.getQueryStr();
		String referrer = httpCupertinoStreamingSession.getReferrer();
		String cookieStr = httpCupertinoStreamingSession.getCookieStr();
		String userAgent = httpCupertinoStreamingSession.getUserAgent();
		
		IApplicationInstance appInstance = httpCupertinoStreamingSession.getAppInstance();
		String streamName = httpCupertinoStreamingSession.getStreamName();
		String sessionId = httpCupertinoStreamingSession.getSessionId();

		String mySharedSecret = appInstance.getProperties().getPropertyStr("cupertinoEncryptionSharedSecret", "");
		
		String hashStr = mySharedSecret+":"+(httpCupertinoStreamingSession.isHTTPOrigin() ? "" : sessionId+":")+appInstance.getApplication().getName()+":"+appInstance.getName()+":"+httpCupertinoStreamingSession.getStreamName();
				
		byte[] tmpBytes = MD5DigestUtils.generateHashBytes(hashStr);
		if (tmpBytes != null)
			System.arraycopy(tmpBytes, 0, encKey, 0, encKey.length);
		
		getLogger().info("ModuleEncryptionHandlerCupertinoStreaming.onHTTPCupertinoEncryptionKeyCreateVOD["+appInstance.getContextStr()+"/"+httpCupertinoStreamingSession.getStreamName()+"]: *"+BufferUtils.encodeHexString(encKey).substring(28));
	}

}
