/**
 * Wowza Media Server and all components Copyright 2006 - 2013, Wowza Media Systems, LLC, licensed pursuant to the Wowza Media Software End User License Agreement.
 */
package com.wowza.wms.plugin.collection.module;

import com.wowza.wms.amf.*;
import com.wowza.wms.application.IApplicationInstance;
import com.wowza.wms.client.*;
import com.wowza.wms.module.*;
import com.wowza.wms.request.*;

public class ModuleHotlinkDenial extends ModuleBase {

	private boolean logConnections = false;
	private boolean logRejections = true;

	public void onAppStart(IApplicationInstance appinstance)
	{
		this.logConnections  = appinstance.getProperties().getPropertyBoolean("hotlinkLogConnections", this.logConnections);
		this.logRejections  = appinstance.getProperties().getPropertyBoolean("hotlinkLogRejections", this.logRejections);
	}
	
	public void onConnect(IClient client, RequestFunction function, AMFDataList params)
	{
		if(logConnections)
			getLogger().info("ModuleHotlinkDenial onConnect: " + client.getClientId());
  
		String flashver = client.getFlashVer().toLowerCase();
		if(logConnections)
			getLogger().info("ModuleHotlinkDenial Client Flashver: " + flashver);
		
		try
		{ 
			String[] allowedEncoder = null;  
			    
			allowedEncoder = client.getAppInstance().getProperties().getPropertyStr("AllowEncoder","").toLowerCase().split(","); 
			if ( allowedEncoder != null )
				{ 
				for (int i = 0; i < allowedEncoder.length; i++) 
				{  
					if (flashver.startsWith(allowedEncoder[i].trim()) && allowedEncoder[i].length()>0) 
					{ 
						if(logConnections)
							getLogger().info("ModuleHotlinkDenial Encoder Allowed: "+flashver+" matches "+allowedEncoder[i]); 
						return;
					}  
				} 
			} 
		} 
		catch (Exception e) 
		{
			getLogger().info("ModuleHotlinkDenial Exception: " + e.getMessage()); 
		}

		boolean reject = true;
		String[] domainLocks = null;
		String[] domainUrl = null;;
		
		String pageUrl = "";
		try 
		{ 
		domainLocks = client.getAppInstance().getProperties().getPropertyStr("domainLock").toLowerCase().split(",");
		pageUrl = client.getProperties().getPropertyStr("connectpageUrl").toLowerCase();
		domainUrl = pageUrl.split("/");
		if(logConnections)
			getLogger().info("domainLock: " + client.getAppInstance().getProperties().getPropertyStr("domainLock").toLowerCase());
		if(logConnections)
			getLogger().info("pageUrl: " + pageUrl);
		for (int i = 0; i < domainLocks.length; i++)
		{ 
			if (domainLocks[i].trim().startsWith("*"))
			{
				String lock = domainLocks[i].trim().substring(1);
				if (domainUrl[2].endsWith(lock))
				{
					reject = false;
				}
			} 
			else if (domainUrl[2].equalsIgnoreCase(domainLocks[i].trim()))
			{
				reject = false; 
			}
		}
		} 
		catch(Exception ex)
		{
			reject = true;
		}
		if (reject)
		{
			if(logRejections)
				getLogger().info("Client Rejected. IP: " + client.getIp() + ": domainLock: " + client.getAppInstance().getProperties().getPropertyStr("domainLock").toLowerCase() + ": pageUrl: " + pageUrl);
			client.rejectConnection();
		}
	}

	public boolean isLogConnections() {
		return logConnections;
	}

	public void setLogConnections(boolean logConnections) {
		this.logConnections = logConnections;
	}

	public boolean isLogRejections() {
		return logRejections;
	}

	public void setLogRejections(boolean logRejections) {
		this.logRejections = logRejections;
	}
}
