/**
 * Wowza Media Server and all components Copyright 2006 - 2013, Wowza Media Systems, LLC, licensed pursuant to the Wowza Media Software End User License Agreement.
 */
package com.wowza.wms.plugin.collection.module;

import com.wowza.wms.amf.*;
import com.wowza.wms.application.*;
import com.wowza.wms.client.*;
import com.wowza.wms.httpstreamer.model.IHTTPStreamerSession;
import com.wowza.wms.request.*;
import com.wowza.wms.rtp.model.*;
import com.wowza.wms.module.*;

public class ModuleLimitConnectionsToApplication extends ModuleBase
{
	static final public int MAXCONNECTIONS = 200;
	
	private int maxApplicationConnections = MAXCONNECTIONS;
	
	public void onAppStart(IApplicationInstance appInstance)
	{
		this.maxApplicationConnections = appInstance.getProperties().getPropertyInt("maxApplicationConnections", maxApplicationConnections);
		getLogger().info("ModuleLimitConnectionsToApplication limit: " + maxApplicationConnections);
	}
	
	public void changeLimit(IClient client, RequestFunction function,
			AMFDataList params) {
		client.getAppInstance().broadcastMsg("handlerName");
		Integer newLimit = params.getInt(PARAM1);
		this.maxApplicationConnections = newLimit;
	}
	
	public void onConnect(IClient client, RequestFunction function, AMFDataList params)
	{	 
		IApplicationInstance appInstance = client.getAppInstance();
		IApplication app = appInstance.getApplication();
		long count = app.getConnectionCounter().getCurrent(); 
		
		String flashver = client.getFlashVer();
		getLogger().info("Flashver: " + flashver);
		
		Boolean isPublisher = false;
		try
		{
		isPublisher = flashver.startsWith(client.getAppInstance().getProperties().getPropertyStr("AllowEncoder"));
		}
		catch(Exception ex) 
		{
		}
		
		getLogger().info("ModuleLimitConnectionsToApplication count: " + (count + 1));
		
		if ((count+1) > this.maxApplicationConnections && !isPublisher)
		{
			client.rejectConnection("Over application connection limit ["+app.getName()+"/"+appInstance.getName()+"]: Limit is: "+this.maxApplicationConnections);
			getLogger().info("ModuleLimitConnectionsToApplication Flash connection rejected ");
		}
	}
	
	public void onHTTPSessionCreate(IHTTPStreamerSession httpSession)
	{
		IApplicationInstance appInstance = httpSession.getAppInstance();
		IApplication app = appInstance.getApplication();
		long count = app.getConnectionCounter().getCurrent();
		
		getLogger().info("ModuleLimitConnectionsToApplication count: " + (count + 1));
		
		if ((count+1) > this.maxApplicationConnections)
		{
			httpSession.rejectSession();
			getLogger().info("ModuleLimitConnectionsToApplication Smooth connection rejected ");
		}		
	}


	public void onRTPSessionCreate(RTPSession rtpSession)
	{
		IApplicationInstance appInstance = rtpSession.getAppInstance();
		IApplication app = appInstance.getApplication();
		long count = app.getConnectionCounter().getCurrent();

		getLogger().info("ModuleLimitConnectionsToApplication count: " + (count + 1));
		
		if ((count+1) > this.maxApplicationConnections)
		{
			rtpSession.rejectSession();
			getLogger().info("ModuleLimitConnectionsToApplication RTSP connection rejected ");
		}
	}	
}
