/**
 * Wowza Media Server and all components Copyright 2006 - 2013, Wowza Media Systems, LLC, licensed pursuant to the Wowza Media Software End User License Agreement.
 */
package com.wowza.wms.plugin.collection.module;
// com.wowza.wms.plugin.collection.module.ModuleLoadBalancerEdgeLimitConnections
import com.wowza.wms.amf.AMFDataList;
import com.wowza.wms.application.IApplicationInstance;
import com.wowza.wms.client.ConnectionCounter;
import com.wowza.wms.client.IClient;
import com.wowza.wms.httpstreamer.cupertinostreaming.httpstreamer.HTTPStreamerSessionCupertino;
import com.wowza.wms.httpstreamer.sanjosestreaming.httpstreamer.HTTPStreamerSessionSanJose;
import com.wowza.wms.httpstreamer.smoothstreaming.httpstreamer.HTTPStreamerSessionSmoothStreamer;
import com.wowza.wms.logging.WMSLoggerIDs;
import com.wowza.wms.module.ModuleBase;
import com.wowza.wms.plugin.loadbalancer.LoadBalancerSender;
import com.wowza.wms.plugin.loadbalancer.ServerListenerLoadBalancerSender;
import com.wowza.wms.request.RequestFunction;
import com.wowza.wms.rtp.model.RTPSession;
import com.wowza.wms.server.Server;

public class ModuleLoadBalancerEdgeLimitConnections extends ModuleBase
{
	static final public int MAXCONNECTIONS = 200;
	
	private ConnectionCounter counter;
	private int maxEdgeConnections = MAXCONNECTIONS;
	
	private LoadBalancerSender loadBalancerSender;
	
	public void onAppStart(IApplicationInstance appInstance)
	{
		this.counter = appInstance.getConnectionCounter();
		this.maxEdgeConnections = appInstance.getProperties().getPropertyInt("maxEdgeConnections", maxEdgeConnections);
		loadBalancerSender = (LoadBalancerSender)Server.getInstance().getProperties().get(ServerListenerLoadBalancerSender.PROP_LOADBALANCERSENDER);
		getLogger().info("ModuleLoadBalancerEdgeLimitConnections maxEdgeConnections: " + maxEdgeConnections);
	}
	
	public void changeLimitEdge(IClient client, RequestFunction function,
			AMFDataList params) {
		Integer newLimit = params.getInt(PARAM1);
		this.maxEdgeConnections = newLimit;
		getLogger().info("ModuleLoadBalancerEdgeLimitConnections New Limit: " + newLimit);
	}
	
	private void addConnection() {
		
		loadBalancerSender = (LoadBalancerSender)Server.getInstance().getProperties().get(ServerListenerLoadBalancerSender.PROP_LOADBALANCERSENDER);
		
		if (loadBalancerSender == null)
		{
			getLogger().info("ModuleLoadBalancerEdgeLimitConnections Error (addConnection): Load Balancer Sender is not installed", WMSLoggerIDs.CAT_application, WMSLoggerIDs.EVT_comment);
			return;
		}
		
		long count = counter.getCurrent(); 
		
		if ((count+1) > this.maxEdgeConnections)
		{
			loadBalancerSender.pause();
			getLogger().info("ModuleLoadBalancerEdgeLimitConnections Pause", WMSLoggerIDs.CAT_application, WMSLoggerIDs.EVT_comment);
		}
		getLogger().info("ModuleLoadBalancerEdgeLimitConnections Count: " + count, WMSLoggerIDs.CAT_application, WMSLoggerIDs.EVT_comment);
	}
	
	private void removeConnection() {
		loadBalancerSender = (LoadBalancerSender)Server.getInstance().getProperties().get(ServerListenerLoadBalancerSender.PROP_LOADBALANCERSENDER);
		if (loadBalancerSender == null)
		{
			getLogger().info("ModuleLoadBalancerEdgeLimitConnections Error (removeConnection): Load Balancer Sender is not installed", WMSLoggerIDs.CAT_application, WMSLoggerIDs.EVT_comment);
			return;
		}
		
		long count = counter.getCurrent(); 
		
		if ((count-1) < this.maxEdgeConnections)
		{
			loadBalancerSender.unpause();
			getLogger().info("ModuleLoadBalancerEdgeLimitConnections UnPause", WMSLoggerIDs.CAT_application, WMSLoggerIDs.EVT_comment);
		}
		getLogger().info("ModuleLoadBalancerEdgeLimitConnections Count: " + count, WMSLoggerIDs.CAT_application, WMSLoggerIDs.EVT_comment);
	}
	
	public void onConnect(IClient client, RequestFunction function, AMFDataList params)
	{		
		addConnection();
	}
	
	public void onDisconnect(IClient client) {
		removeConnection();
	}
	
	public void onHTTPSmoothStreamingSessionCreate(HTTPStreamerSessionSmoothStreamer httpSmoothStreamingSession)
	{
		addConnection();		
	}
	
	public void onHTTPSmoothStreamingSessionDestroy(HTTPStreamerSessionSmoothStreamer httpSmoothStreamingSession)
	{
		removeConnection();		
	}
	
	public void onHTTPCupertinoStreamingSessionCreate(HTTPStreamerSessionCupertino httpCupertinoStreamingSession)
	{
		addConnection();		
	}

	public void onHTTPCupertinoStreamingSessionDestroy(HTTPStreamerSessionCupertino httpCupertinoStreamingSession)
	{
		removeConnection();		
	}
	
	public void onHTTPSanjoseStreamingSessionCreate(HTTPStreamerSessionSanJose httpSanJoseStreamingSession)
	{
		addConnection();
	}
	
	public void onHTTPSanjoseStreamingSessionDestroy(HTTPStreamerSessionSanJose httpSanJoseStreamingSession)
	{
		removeConnection();
	}

	public void onRTPSessionCreate(RTPSession rtpSession)
	{
		addConnection();	
	}

	public void onRTPSessionDestroy(RTPSession rtpSession)
	{
		removeConnection();
	}
}
