/**
 * Wowza Media Server and all components Copyright 2006 - 2013, Wowza Media Systems, LLC, licensed pursuant to the Wowza Media Software End User License Agreement.
 */
package com.wowza.wms.plugin.collection.module;

import com.wowza.wms.amf.*;
import com.wowza.wms.application.IApplicationInstance;
import com.wowza.wms.client.*;
import com.wowza.wms.httpstreamer.model.IHTTPStreamerSession;
import com.wowza.wms.module.*;
import com.wowza.wms.request.*;
import com.wowza.wms.rtp.model.RTPSession;

public class ModuleOverridePlayBlackListIP extends ModuleBase {
	
	private String[] ipList = null;
	
	public void onAppStart(IApplicationInstance appInstance) {
		ipList = appInstance.getProperties().getPropertyStr("IpList").toLowerCase().split(",");
	}
	
	public void play(IClient client, RequestFunction function,
	        AMFDataList params) {
		getLogger().info("Overriding Play");
		
		boolean reject = false;
			
		try 
		{
		String clientIP = client.getIp();
		for (int i = 0; i < ipList.length; i++)
		{ 
			if (clientIP.equalsIgnoreCase(ipList[i].trim()))
			{
				reject = true;
				break;
			}
		} 
		} 
		catch(Exception ex)
		{
			reject = false;
		}
		if (reject)
		{
			getLogger().info("Client Rejected. IP: " + client.getIp());
			sendClientOnStatusError(client, "NetStream.Play.Failed", "The client IP was rejected");
		} 
		else
		{			
			ModuleCore.play(client, function, params);	
		}		
	}
	
	public void onHTTPSessionCreate(IHTTPStreamerSession httpSession)
	{
		boolean isGood = true;
		
		String clientIP = httpSession.getIpAddress();		
		boolean reject = false;
		
		try 
		{
		for (int i = 0; i < ipList.length; i++)
		{ 
			if (clientIP.equalsIgnoreCase(ipList[i].trim()))
			{
				reject = true;
				break;
			}
		} 
		} 
		catch(Exception ex)
		{
			reject = false;
		}
		if (reject)
		{
			httpSession.rejectSession();
			getLogger().info("HTTP Client Rejected. IP: " + clientIP);
		} 		
	}
	
	public void onRTPSessionCreate(RTPSession rtpSession)
	{
		boolean isGood = true;
		
		String clientIP = rtpSession.getIp();		
		boolean reject = false;
		
		try 
		{
		for (int i = 0; i < ipList.length; i++)
		{ 
			if (clientIP.equalsIgnoreCase(ipList[i].trim()))
			{
				reject = true;
				break;
			}
		} 
		} 
		catch(Exception ex)
		{
			reject = false;
		}
		if (reject)
		{
			rtpSession.rejectSession();
			getLogger().info("RTSP Client Rejected. IP: " + clientIP);
		}
	}
}
