/**
 * Wowza Media Server and all components Copyright 2006 - 2013, Wowza Media Systems, LLC, licensed pursuant to the Wowza Media Software End User License Agreement.
 */
package com.wowza.wms.plugin.collection.module;

// com.wowza.wms.plugin.collection.module.ModuleOverridePublishRestrictIP

import com.wowza.wms.amf.*;
import com.wowza.wms.client.*;
import com.wowza.wms.module.*;
import com.wowza.wms.request.*;

public class ModuleOverridePublishRestrictIP extends ModuleBase {
	
	public void publish(IClient client, RequestFunction function,
	        AMFDataList params) {
		getLogger().info("Overriding Publish");
		
		boolean reject = true;
		String[] ipList = null;
			
		try 
		{ 
		ipList = client.getAppInstance().getProperties().getPropertyStr("ipList").toLowerCase().split(",");
		String clientIP = client.getIp();
		for (int i = 0; i < ipList.length; i++)
		{ 
			if (clientIP.equalsIgnoreCase(ipList[i].trim()))
			{
				reject = false; 
			}
		} 
		} 
		catch(Exception ex)
		{
			reject = true;
		}
		if (reject)
		{	
			sendClientOnStatusError(client, "NetStream.Publish.Denied", "The publisher's IP was rejected");
			getLogger().info("Client Rejected. IP: " + client.getIp());
		} 
		else
		{	
			invokePrevious(client, function, params);
		}		
	}
	
	public void releaseStream(IClient client, RequestFunction function, AMFDataList params)
	{
		getLogger().info("Overriding streamRelease");
		
		boolean reject = true;
		String[] ipList = null;
			
		try 
		{ 
		ipList = client.getAppInstance().getProperties().getPropertyStr("ipList").toLowerCase().split(",");
		String clientIP = client.getIp();
		for (int i = 0; i < ipList.length; i++)
		{ 
			if (clientIP.equalsIgnoreCase(ipList[i].trim()))
			{
				reject = false; 
			}
		} 
		} 
		catch(Exception ex)
		{
			reject = true;
		}
		if (reject)
		{
			sendClientOnStatusError(client, "NetStream.Publish.Denied", "The publisher's IP was rejected");
			getLogger().info("Client Rejected. IP: " + client.getIp());
		} 
		else
		{			
			invokePrevious(client, function, params);	
		}		
		
	}
	
}
