/**
 * Wowza Media Server and all components Copyright 2006 - 2013, Wowza Media Systems, LLC, licensed pursuant to the Wowza Media Software End User License Agreement.
 */
package com.wowza.wms.plugin.collection.module;

import com.wowza.util.StringUtils;
import com.wowza.wms.application.IApplicationInstance;
import com.wowza.wms.module.ModuleBase;
import com.wowza.wms.stream.IMediaStream;
import com.wowza.wms.stream.livepacketizer.ILiveStreamPacketizerControl;


public class ModulePacketizerControl extends ModuleBase  {

	private class PacketizerControl implements ILiveStreamPacketizerControl {

		public boolean isLiveStreamPacketize(String packetizer, IMediaStream stream) {
			getLogger().info("PacketizerControl.isLiveStreamPacketize ["+packetizer+" : "+stream.getName()+" : "+suffixes+"]", stream);
			if(suffixes.equals("*")) {
				getLogger().info("PacketizerControl.isLiveStreamPacketize ["+packetizer+" : "+stream.getName()+" :  suffixes is wildcard. returning "+matchAllow+"]", stream);
				return matchAllow;
			}
			if (StringUtils.isEmpty(suffixes)) {
				getLogger().info("PacketizerControl.isLiveStreamPacketize ["+packetizer+" : "+stream.getName()+" : suffixes is empty. returning "+noMatchAllow+"]", stream);
				return noMatchAllow;
			}
				
			String[] suffixArray = suffixes.split(",");
			for(String suffix : suffixArray) {
				if(stream.getName().endsWith(suffix.trim())) {
					getLogger().info("PacketizerControl.isLiveStreamPacketize ["+packetizer+" : "+stream.getName()+" : match found : "+suffix.trim()+" : returning "+matchAllow+"]", stream);
					return matchAllow;
				}
			}
			getLogger().info("PacketizerControl.isLiveStreamPacketize ["+packetizer+" : "+stream.getName()+" : No match found : returning "+noMatchAllow+"]", stream);
			return noMatchAllow;
		}
	}

	private String suffixes = "*";
	private boolean matchAllow = true;
	private boolean noMatchAllow = false;

	public void onAppStart(IApplicationInstance appInstance) {
		suffixes = appInstance.getProperties().getPropertyStr("packetizerControlSuffixes", suffixes);
		matchAllow = appInstance.getProperties().getPropertyBoolean("packetizerControlMatchAllow", matchAllow);
		noMatchAllow = appInstance.getProperties().getPropertyBoolean("packetizerControlNoMatchAllow", noMatchAllow);

		appInstance.setLiveStreamPacketizerControl(new PacketizerControl());
	}
}
