/**
 * Wowza Media Server and all components Copyright 2006 - 2013, Wowza Media Systems, LLC, licensed pursuant to the Wowza Media Software End User License Agreement.
 */
package com.wowza.wms.plugin.collection.module;

// com.wowza.wms.plugin.collection.module.ModuleRequireSecureConnection
// com.wowza.wms.plugin.collection.module.ModuleRequireSecureConnection

import com.wowza.wms.amf.*;
import com.wowza.wms.application.IApplicationInstance;
import com.wowza.wms.client.*;
import com.wowza.wms.module.*;
import com.wowza.wms.request.*;

public class ModuleRequireSecureConnection extends ModuleBase
{
	public void onAppStart(IApplicationInstance appInstance)
	{
		getLogger().info("ModuleRequireSecureConnection started");
	}
	
	public void onConnect(IClient client, RequestFunction function, AMFDataList params)
	{
		
		String flashver = client.getFlashVer();
		getLogger().info("Flashver (ModuleRequireSecureConnection): " + flashver);
		
		Boolean isPublisher = false;
		try
		{
			String allowEncoder = client.getAppInstance().getProperties().getPropertyStr("AllowEncoder");
			getLogger().info("AllowedEncoder (ModuleRequireSecureConnection): " + allowEncoder);
			
		isPublisher = flashver.startsWith(allowEncoder);
		} 
		catch(Exception ex)
		{
		} 
		
		if (!client.isSecure() && !isPublisher)
		{
			getLogger().info("ModuleRequireSecureConnection Connection Rejected");
			client.rejectConnection("Secure connection required.");
			getLogger().info("ModuleRequireSecureConnection.onConnect: rejectConnection: clientId:"+client.getClientId());
		}
		else
		{
			getLogger().info("ModuleRequireSecureConnection Connection Accepted");
		}
	}
} 
