package com.wowza.wms.plugin.collection.module;

import java.util.Map;

import com.wowza.wms.amf.*;
import com.wowza.wms.application.*;
import com.wowza.wms.client.*;
import com.wowza.wms.module.*;
import com.wowza.wms.plugin.collection.serverlistener.ServerListenerStreamPublisher;
import com.wowza.wms.request.*;
import com.wowza.wms.server.Server;
import com.wowza.wms.stream.publish.Stream;

public class ModuleStreamPublisher extends ModuleBase
{
	private ServerListenerStreamPublisher streamPublisher;
	private IApplicationInstance appInstance;

	/**
	 * 
	 * Flash client loadSchedule method.
	 */
	public void loadSchedule(IClient client, RequestFunction function, AMFDataList params)
	{
		sendResult(client, params, loadSchedule());
	}

	/**
	 * 
	 * Get the StreamPublisher and save it as a Server property if it doesn't already exist then load schedule.
	 */
	public void onAppStart(IApplicationInstance appInstance)
	{
		this.appInstance = appInstance;
		streamPublisher = (ServerListenerStreamPublisher)Server.getInstance().getProperties().get(ServerListenerStreamPublisher.PROP_STREAMPUBLISHER);
		if(streamPublisher == null)
		{
			streamPublisher = new ServerListenerStreamPublisher();
			Server.getInstance().getProperties().setProperty(ServerListenerStreamPublisher.PROP_STREAMPUBLISHER, streamPublisher);
		}
		String ret = loadSchedule();
		appInstance.getProperties().setProperty("streamPublisherScheduleLoaded", true);
		getLogger().info("ModuleStreamPublisher.onAppStart: ["+appInstance.getContextStr()+"]: "+ret);
	}

	/**
	 * 
	 * Stop streams and remove local reference to streamPublisher.
	 */
	public void onAppStop(IApplicationInstance appInstance)
	{
		unloadSchedule();
		streamPublisher = null;
	}
	
	/**
	 * public loadSchedule method.  Can be called from JMX.
	 */
	public String loadSchedule()
	{
		return streamPublisher.loadSchedule(appInstance);
	}
	
	/**
	 * public unloadSchedule method.  Can be called from JMX.
	 */
	public void unloadSchedule()
	{
		Map<String, Stream> streams = (Map<String, Stream>)appInstance.getProperties().remove("streamPublisherStreams");
		if(streams != null)
		{
			for(Stream stream : streams.values())
			{
				streamPublisher.shutdownStream(appInstance, stream);
			}
			streams.clear();
		}
	}

}
