/*
 * Decompiled with CFR 0.152.
 */
package com.wowza.wms.plugin;

import com.wowza.wms.application.IApplicationInstance;
import com.wowza.wms.logging.WMSLoggerFactory;
import com.wowza.wms.module.ModuleBase;
import com.wowza.wms.plugin.AddAudioLogger;
import com.wowza.wms.plugin.AddAudioWorker;
import com.wowza.wms.stream.IMediaStream;
import com.wowza.wms.stream.IMediaStreamActionNotify;
import java.util.HashMap;

public class AddAudioTrack
extends ModuleBase {
    private AddAudioLogger log = null;
    private AddAudioWorker worker = null;
    private String sourceStream = "";
    private HashMap<String, AddAudioWorker> workers = new HashMap();
    private IApplicationInstance appInstance = null;
    private IMediaStreamActionNotify actionNotify = new StreamListener();
    private String audioSourceFile = "mp4:sample.mp4";

    public void onAppStart(IApplicationInstance iApplicationInstance) {
        String string = iApplicationInstance.getApplication().getName() + "/" + iApplicationInstance.getName();
        this.log = new AddAudioLogger(WMSLoggerFactory.getLoggerObj((IApplicationInstance)iApplicationInstance));
        this.log.LogMessage("Started: " + string);
        this.audioSourceFile = iApplicationInstance.getProperties().getPropertyStr("addAudioTrackAudioSourceFilename", "mp4:sample.mp4");
        this.appInstance = iApplicationInstance;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void onAppStop(IApplicationInstance iApplicationInstance) {
        String string = iApplicationInstance.getApplication().getName() + "/" + iApplicationInstance.getName();
        HashMap<String, AddAudioWorker> hashMap = this.workers;
        synchronized (hashMap) {
            for (String string2 : this.workers.keySet()) {
                AddAudioWorker addAudioWorker = this.workers.get(string2);
                addAudioWorker.quit();
            }
        }
        this.log.LogMessage("Stopped: " + string);
        this.log = null;
    }

    public AddAudioWorker returnVideoWorker() {
        return this.worker;
    }

    public void onStreamCreate(IMediaStream iMediaStream) {
        iMediaStream.addClientListener(this.actionNotify);
    }

    public void onStreamDestroy(IMediaStream iMediaStream) {
        iMediaStream.removeClientListener(this.actionNotify);
    }

    class StreamListener
    implements IMediaStreamActionNotify {
        StreamListener() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void onPublish(IMediaStream iMediaStream, String string, boolean bl, boolean bl2) {
            if (!string.contains("-audiodestin") && !string.contains("-audiosource")) {
                HashMap hashMap = AddAudioTrack.this.workers;
                synchronized (hashMap) {
                    AddAudioWorker addAudioWorker;
                    if (AddAudioTrack.this.workers.containsKey(string)) {
                        addAudioWorker = (AddAudioWorker)AddAudioTrack.this.workers.remove(string);
                        addAudioWorker.quit();
                    }
                    addAudioWorker = new AddAudioWorker(AddAudioTrack.this.appInstance, AddAudioTrack.this.log);
                    addAudioWorker.setSourceStream(string);
                    addAudioWorker.setDestinStream(string + "-audiodestin");
                    addAudioWorker.SetAudioSourceFile(AddAudioTrack.this.audioSourceFile);
                    addAudioWorker.setDaemon(true);
                    addAudioWorker.start();
                    AddAudioTrack.this.workers.put(string, addAudioWorker);
                }
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void onUnPublish(IMediaStream iMediaStream, String string, boolean bl, boolean bl2) {
            HashMap hashMap = AddAudioTrack.this.workers;
            synchronized (hashMap) {
                if (AddAudioTrack.this.workers.containsKey(string)) {
                    AddAudioWorker addAudioWorker = (AddAudioWorker)AddAudioTrack.this.workers.remove(string);
                    addAudioWorker.quit();
                }
            }
        }

        public void onPause(IMediaStream iMediaStream, boolean bl, double d) {
        }

        public void onPlay(IMediaStream iMediaStream, String string, double d, double d2, int n) {
        }

        public void onSeek(IMediaStream iMediaStream, double d) {
        }

        public void onStop(IMediaStream iMediaStream) {
        }
    }
}

