/*
 * Decompiled with CFR 0.152.
 */
package com.wowza.wms.plugin.akamaivalidate;

import com.wowza.util.Base64;
import com.wowza.util.DebugUtils;
import com.wowza.util.MD5DigestUtils;
import com.wowza.util.StringUtils;
import com.wowza.wms.amf.AMFDataList;
import com.wowza.wms.application.WMSProperties;
import com.wowza.wms.client.IClient;
import com.wowza.wms.logging.WMSLogger;
import com.wowza.wms.logging.WMSLoggerFactory;
import com.wowza.wms.request.RequestFunction;
import com.wowza.wms.server.RtmpRequestMessage;
import com.wowza.wms.vhost.HostPort;
import com.wowza.wms.vhost.IVHost;
import com.wowza.wms.vhost.IVHostHTTPStreamerRequestValidator;
import com.wowza.wms.vhost.IVHostNotify;
import com.wowza.wms.vhost.VHost;
import java.util.HashMap;
import java.util.Map;
import java.util.SortedMap;
import java.util.TreeMap;
import java.util.regex.Pattern;
import javax.crypto.Mac;
import javax.crypto.spec.SecretKeySpec;

public class VHostListenerAkamaiValidate
implements IVHostNotify {
    public static final String CLASS_NAME = "AkamaiValidator";
    public static final String PROP_NAME_PREFIX = "akamaiValidator";
    public static final String AUTH_TYPE_VIA = "via";
    public static final String AUTH_TYPE_UA = "userAgent";
    public static final String AUTH_TYPE_COOKIE = "cookie";
    public static final String AUTH_TYPE_SIGNATURE = "signature";
    public static final String AUTH_VALUE_VIA = "1.1 akamai.net (ghost) (AkamaiGHost)";
    public static final String AUTH_VALUE_UA = "Akamai Edge";
    public static final String AUTH_SIGNATURE_DATA_HEADER = "X-Akamai-G2O-Auth-Data";
    public static final String AUTH_SIGNATURE_SIGN_HEADER = "X-Akamai-G2O-Auth-Sign";
    public static final String CHAR_ENCODE_STR = "UTF-8";
    private static final String HMAC_MD5_ALGORITHM = "HmacMD5";
    private static final String HMAC_SHA1_ALGORITHM = "HmacSHA1";
    private static final String HMAC_SHA256_ALGORITHM = "HmacSHA256";
    private static final int AUTH_SIGNATURE_VERSION_1 = 1;
    private static final int AUTH_SIGNATURE_VERSION_2 = 2;
    private static final int AUTH_SIGNATURE_VERSION_3 = 3;
    private static final int AUTH_SIGNATURE_VERSION_4 = 4;
    private static final int AUTH_SIGNATURE_VERSION_5 = 5;

    public void onVHostCreate(IVHost iVHost) {
    }

    public void onVHostInit(IVHost iVHost) {
        iVHost.setHTTPStreamerRequestValidator((IVHostHTTPStreamerRequestValidator)new AkamaiValidator(iVHost));
    }

    public void onVHostShutdownStart(IVHost iVHost) {
    }

    public void onVHostShutdownComplete(IVHost iVHost) {
    }

    public void onVHostClientConnect(IVHost iVHost, IClient iClient, RequestFunction requestFunction, AMFDataList aMFDataList) {
    }

    private class AkamaiValidator
    implements IVHostHTTPStreamerRequestValidator {
        private IVHost vhost;
        private String authType;
        private String viaValue;
        private String authCookie;
        private String authDataHeaderName;
        private String authSignHeaderName;
        private String authSecret;
        private String authNonceSecrets;
        private Map<String, String> secrets = new HashMap<String, String>();
        private SortedMap<Long, String> pastData = new TreeMap<Long, String>();
        private WMSLogger logger;
        private String pathPattern = "";
        private boolean validateMatchingPaths = true;
        private boolean checkViaOnAllRequests;
        private boolean debugLog;

        private AkamaiValidator(IVHost iVHost) {
            this.vhost = iVHost;
            this.logger = WMSLoggerFactory.getLoggerObj((IVHost)iVHost);
            WMSProperties wMSProperties = iVHost.getProperties();
            this.pathPattern = wMSProperties.getPropertyStr("akamaiValidatorPathPattern", this.pathPattern);
            this.validateMatchingPaths = wMSProperties.getPropertyBoolean("akamaiValidatorValidateMatchingPaths", this.validateMatchingPaths);
            this.authType = wMSProperties.getPropertyStr("akamaiValidatorAuthType", VHostListenerAkamaiValidate.AUTH_TYPE_VIA);
            this.checkViaOnAllRequests = wMSProperties.getPropertyBoolean("akamaiValidatorCheckViaHeader", false);
            this.viaValue = wMSProperties.getPropertyStr("akamaiValidatorViaValue", VHostListenerAkamaiValidate.AUTH_VALUE_VIA);
            this.authCookie = wMSProperties.getPropertyStr("akamaiValidatorAuthCookie");
            this.authDataHeaderName = wMSProperties.getPropertyStr("akamaiValidatorAuthDataHeader", VHostListenerAkamaiValidate.AUTH_SIGNATURE_DATA_HEADER);
            this.authSignHeaderName = wMSProperties.getPropertyStr("akamaiValidatorAuthSignHeader", VHostListenerAkamaiValidate.AUTH_SIGNATURE_SIGN_HEADER);
            this.authSecret = wMSProperties.getPropertyStr("akamaiValidatorAuthSecret");
            this.authNonceSecrets = wMSProperties.getPropertyStr("akamaiValidatorAuthNonceSecrets");
            if (this.authNonceSecrets != null) {
                String[] stringArray;
                for (String string : stringArray = this.authNonceSecrets.split("\\|")) {
                    String[] stringArray2 = string.trim().split(",");
                    if (stringArray2.length != 2) continue;
                    this.secrets.put(stringArray2[0].trim(), stringArray2[1].trim());
                }
            }
            this.debugLog = wMSProperties.getPropertyBoolean("akamaiValidatorDebugLog", false);
            if (this.logger.isDebugEnabled()) {
                this.debugLog = true;
            }
            this.logger.info("AkamaiValidatorstarted: [authType: " + this.authType + ", checkViaHeader: " + this.checkViaOnAllRequests + ", viaValue: " + this.viaValue + ", authCookie: " + this.authCookie + ", authDataHeader: " + this.authDataHeaderName + ", authSignHeader: " + this.authSignHeaderName + ", authSecret: " + this.authSecret + ", authNonceSecrets: " + this.authNonceSecrets + ", debugLog: " + this.debugLog + "]", "vhost", "comment");
        }

        public boolean validateHTTPStreamerRequest(RtmpRequestMessage rtmpRequestMessage, HostPort hostPort, String string) {
            boolean bl = ((VHost)this.vhost).validateHTTPStreamerRequest(rtmpRequestMessage, hostPort, string);
            if (bl) {
                String string2 = new String(rtmpRequestMessage.getBody().array());
                if (this.debugLog) {
                    this.logger.info("AkamaiValidator.validateHTTPStreamerRequest [req: " + string2 + "]", "vhost", "comment");
                }
                if (this.checkPath(string = this.getPathFromRequest(string2))) {
                    if (this.authType.equalsIgnoreCase(VHostListenerAkamaiValidate.AUTH_TYPE_VIA)) {
                        bl = this.doViaAuth(string2);
                    } else if (this.authType.equalsIgnoreCase(VHostListenerAkamaiValidate.AUTH_TYPE_UA)) {
                        bl = this.doUAAuth(string2);
                    } else if (this.authType.equalsIgnoreCase(VHostListenerAkamaiValidate.AUTH_TYPE_COOKIE)) {
                        bl = this.doCookieAuth(string2);
                    } else if (this.authType.equalsIgnoreCase(VHostListenerAkamaiValidate.AUTH_TYPE_SIGNATURE)) {
                        bl = this.doSignatureAuth(string2, string);
                    }
                }
            } else if (this.debugLog) {
                this.logger.warn("AkamaiValidator.validateHTTPStreamerRequest failed path check [path: " + string + "]", "vhost", "comment");
            }
            return bl;
        }

        private String getPathFromRequest(String string) {
            String[] stringArray;
            String string2 = "";
            String[] stringArray2 = (string = string.replace("\r\n", "\n").replace("\r", "\n")).split("\n");
            if (stringArray2.length > 0 && (stringArray = stringArray2[0].split(" ")).length > 1) {
                string2 = stringArray[1];
            }
            return string2;
        }

        private boolean checkPath(String string) {
            if (this.debugLog) {
                this.logger.info("AkamaiValidator.checkPath checking [path: " + string + ", pathPattern: " + this.pathPattern.trim() + "]", "vhost", "comment");
            }
            boolean bl = false;
            try {
                if (StringUtils.isEmpty((String)this.pathPattern)) {
                    if (this.debugLog) {
                        this.logger.info("AkamaiValidator.checkPath pathPattern is empty. return true. [path: " + string + "]", "vhost", "comment");
                    }
                    return true;
                }
                if (this.pathPattern.equals("*")) {
                    if (this.debugLog) {
                        this.logger.info("AkamaiValidator.checkPath pathPattern = *. [path: " + string + "]", "vhost", "comment");
                    }
                    bl = true;
                } else if (Pattern.matches(this.pathPattern.trim(), string)) {
                    if (this.debugLog) {
                        this.logger.info("AkamaiValidator.checkPath match found. [path: " + string + ", pathPattern: " + this.pathPattern.trim() + "]", "vhost", "comment");
                    }
                    bl = true;
                }
            }
            catch (Exception exception) {
                this.logger.error("AkamaiValidator.checkPath Exception: ", (Throwable)exception);
            }
            if (this.debugLog) {
                this.logger.info("AkamaiValidator.checkPath [path: " + string + ", pathPattern: " + this.pathPattern.trim() + ", match: " + bl + ", validateMatchingPaths: " + this.validateMatchingPaths + ", return: " + (bl == this.validateMatchingPaths) + "]", "vhost", "comment");
            }
            return bl == this.validateMatchingPaths;
        }

        private boolean doViaAuth(String string) {
            String string2 = this.getHeader(string, "Via");
            if (string2 != null && string2.contains(this.viaValue)) {
                return true;
            }
            if (this.debugLog) {
                this.logger.warn("AkamaiValidator.doViaAuth failed Via check [header: " + string2 + ", expected: " + this.viaValue + "]", "vhost", "comment");
            }
            return false;
        }

        private boolean doUAAuth(String string) {
            if (this.checkViaOnAllRequests && !this.doViaAuth(string)) {
                return false;
            }
            String string2 = this.getHeader(string, "User-Agent");
            if (string2 != null && string2.equals(VHostListenerAkamaiValidate.AUTH_VALUE_UA)) {
                return true;
            }
            if (this.debugLog) {
                this.logger.warn("AkamaiValidator.doUAAuth failed UA check [header: " + string2 + ", expected: Akamai Edge]", "vhost", "comment");
            }
            return false;
        }

        private boolean doCookieAuth(String string) {
            if (this.checkViaOnAllRequests && !this.doViaAuth(string)) {
                return false;
            }
            if (StringUtils.isEmpty((String)this.authCookie)) {
                if (this.debugLog) {
                    this.logger.warn("AkamaiValidator.doCookieAuth cookie not set in properties", "vhost", "comment");
                }
                return false;
            }
            String string2 = this.getHeader(string, "Cookie");
            if (string2 != null && string2.contains(this.authCookie)) {
                return true;
            }
            if (this.debugLog) {
                this.logger.warn("AkamaiValidator.doCookieAuth failed UA check [header: " + string2 + ", expected: " + this.authCookie + "]", "vhost", "comment");
            }
            return false;
        }

        private boolean doSignatureAuth(String string, String string2) {
            Object object;
            if (this.checkViaOnAllRequests && !this.doViaAuth(string)) {
                return false;
            }
            if (StringUtils.isEmpty((String)this.authSecret) && this.secrets.size() == 0) {
                if (this.debugLog) {
                    this.logger.warn("AkamaiValidator.doSignatureAuth failed. no secrets set in properties", "vhost", "comment");
                }
                return false;
            }
            String string3 = this.getHeader(string, this.authDataHeaderName);
            String string4 = this.getHeader(string, this.authSignHeaderName);
            if (StringUtils.isEmpty((String)string3) || StringUtils.isEmpty((String)string4)) {
                if (this.debugLog) {
                    this.logger.warn("AkamaiValidator.doSignatureAuth failed. data and / or signature header missing [data: " + string3 + ", signature: " + string4 + "]", "vhost", "comment");
                }
                return false;
            }
            long l = System.currentTimeMillis();
            while (!this.pastData.isEmpty() && this.pastData.firstKey() < l - 60000L) {
                long l2 = this.pastData.firstKey();
                object = (String)this.pastData.remove(l2);
                if (!this.debugLog) continue;
                this.logger.info("AkamaiValidator.doSignatureAuth delete old data [now: " + l + ", key: " + l2 + ", data: " + (String)object + "]", "vhost", "comment");
            }
            if (this.pastData.containsValue(string3)) {
                if (this.debugLog) {
                    this.logger.warn("AkamaiValidator.doSignatureAuth failed. data already used [data: " + string3 + "]", "vhost", "comment");
                }
                return false;
            }
            byte[] byArray = null;
            boolean bl = false;
            try {
                long l3;
                int n;
                object = string3.split(",");
                if (((String[])object).length != 6) {
                    if (this.debugLog) {
                        this.logger.warn("AkamaiValidator.doSignatureAuth failed. data too small. expected 6 values [data: " + string3 + "]", "vhost", "comment");
                    }
                    return false;
                }
                try {
                    n = Integer.parseInt(object[0].trim());
                }
                catch (Exception exception) {
                    if (this.debugLog) {
                        this.logger.warn("AkamaiValidator.doSignatureAuth failed. version should be a number [version: " + object[0].trim() + "]", "vhost", "comment");
                    }
                    return false;
                }
                try {
                    l3 = Long.parseLong(object[3].trim()) * 1000L;
                }
                catch (Exception exception) {
                    if (this.debugLog) {
                        this.logger.warn("AkamaiValidator.doSignatureAuth failed. time should be a number [time: " + object[3].trim() + "]", "vhost", "comment");
                    }
                    return false;
                }
                if (l3 < l - 30000L || l3 > l + 30000L) {
                    if (this.debugLog) {
                        this.logger.warn("AkamaiValidator.doSignatureAuth failed. time out of range [time: " + l3 + ", range: " + (l - 30000L) + "-" + (l + 30000L) + "]", "vhost", "comment");
                    }
                    return false;
                }
                String string5 = object[5];
                if (!this.secrets.containsKey(string5) && StringUtils.isEmpty((String)this.authSecret)) {
                    if (this.debugLog) {
                        this.logger.warn("AkamaiValidator.doSignatureAuth failed. no secret for nonce and no default secret [nonce: " + string5 + ", secrets: " + this.secrets.toString() + "]", "vhost", "comment");
                    }
                    return false;
                }
                String string6 = this.secrets.containsKey(string5) ? this.secrets.get(string5) : this.authSecret;
                String string7 = string6 + string3 + string2;
                if (this.debugLog) {
                    this.logger.info("AkamaiValidator.doSignatureAuth building version " + n + " hash from [secret: " + string6 + ", values: " + string7 + "]", "vhost", "comment");
                }
                byte[] byArray2 = string7.getBytes(VHostListenerAkamaiValidate.CHAR_ENCODE_STR);
                switch (n) {
                    case 1: {
                        byArray = MD5DigestUtils.generateHashBytes((byte[])byArray2);
                        if (this.debugLog) {
                            this.logger.info("AkamaiValidator.doSignatureAuth building version " + n + " [hash: " + DebugUtils.formatBytesShort((byte[])byArray) + "]", "vhost", "comment");
                        }
                        break;
                    }
                    case 2: {
                        byte[] byArray3 = string6.getBytes(VHostListenerAkamaiValidate.CHAR_ENCODE_STR);
                        byte[] byArray4 = MD5DigestUtils.generateHashBytes((byte[])byArray2);
                        byte[] byArray5 = new byte[byArray3.length + byArray4.length];
                        System.arraycopy(byArray3, 0, byArray5, 0, byArray3.length);
                        System.arraycopy(byArray4, 0, byArray5, byArray3.length, byArray4.length);
                        byArray = MD5DigestUtils.generateHashBytes((byte[])byArray5);
                        if (this.debugLog) {
                            this.logger.info("AkamaiValidator.doSignatureAuth building version " + n + " [firstPass: " + DebugUtils.formatBytesShort((byte[])byArray4) + "]", "vhost", "comment");
                            this.logger.info("AkamaiValidator.doSignatureAuth building version " + n + " [secretBytes: " + DebugUtils.formatBytesShort((byte[])byArray3) + "]", "vhost", "comment");
                            this.logger.info("AkamaiValidator.doSignatureAuth building version " + n + " [secondBytes: " + DebugUtils.formatBytesShort((byte[])byArray5) + "]", "vhost", "comment");
                            this.logger.info("AkamaiValidator.doSignatureAuth building version " + n + " [hash: " + DebugUtils.formatBytesShort((byte[])byArray) + "]", "vhost", "comment");
                        }
                        break;
                    }
                    case 3: 
                    case 4: 
                    case 5: {
                        String string8 = VHostListenerAkamaiValidate.HMAC_MD5_ALGORITHM;
                        if (n == 4) {
                            string8 = VHostListenerAkamaiValidate.HMAC_SHA1_ALGORITHM;
                        }
                        if (n == 5) {
                            string8 = VHostListenerAkamaiValidate.HMAC_SHA256_ALGORITHM;
                        }
                        SecretKeySpec secretKeySpec = new SecretKeySpec(string6.getBytes(VHostListenerAkamaiValidate.CHAR_ENCODE_STR), string8);
                        if (this.debugLog) {
                            this.logger.info("AkamaiValidator.doSignatureAuth building version " + n + "create key [algorithm: " + string8 + ", sectet: " + DebugUtils.formatBytesShort((byte[])string6.getBytes(VHostListenerAkamaiValidate.CHAR_ENCODE_STR)) + ", key: " + DebugUtils.formatBytesShort((byte[])secretKeySpec.getEncoded()) + "]", "vhost", "comment");
                        }
                        Mac mac = Mac.getInstance(string8);
                        mac.init(secretKeySpec);
                        mac.update(string3.getBytes(VHostListenerAkamaiValidate.CHAR_ENCODE_STR));
                        if (this.debugLog) {
                            this.logger.info("AkamaiValidator.doSignatureAuth building version " + n + "add data [data: " + DebugUtils.formatBytesShort((byte[])string3.getBytes(VHostListenerAkamaiValidate.CHAR_ENCODE_STR)) + "]", "vhost", "comment");
                        }
                        mac.update(string2.getBytes(VHostListenerAkamaiValidate.CHAR_ENCODE_STR));
                        if (this.debugLog) {
                            this.logger.info("AkamaiValidator.doSignatureAuth building version " + n + "add path [path: " + DebugUtils.formatBytesShort((byte[])string2.getBytes(VHostListenerAkamaiValidate.CHAR_ENCODE_STR)) + "]", "vhost", "comment");
                        }
                        byArray = mac.doFinal();
                        if (this.debugLog) {
                            this.logger.info("AkamaiValidator.doSignatureAuth building version " + n + "get hash [hash: " + DebugUtils.formatBytesShort((byte[])byArray) + "]", "vhost", "comment");
                        }
                        break;
                    }
                    default: {
                        if (this.debugLog) {
                            this.logger.warn("AkamaiValidator.doSignatureAuth building version " + n + "not supported.", "vhost", "comment");
                        }
                        break;
                    }
                }
            }
            catch (Exception exception) {
                this.logger.error("AkamaiValidator.doSignatureAuth failed with exception: " + exception.getMessage(), (Throwable)exception);
            }
            if (byArray != null) {
                object = Base64.encodeBytes(byArray);
                if (this.debugLog) {
                    this.logger.info("AkamaiValidator.doSignatureAuth b64 of hash: " + (String)object, "vhost", "comment");
                }
                if (string4.equals(object)) {
                    if (this.debugLog) {
                        this.logger.info("AkamaiValidator.doSignatureAuth b64 of hash matches signature [b64: " + (String)object + ", signature: " + string4 + "]", "vhost", "comment");
                        this.logger.info("AkamaiValidator.doSignatureAuth adding data to pastData [time: " + l + ", data: " + string3 + "]", "vhost", "comment");
                    }
                    this.pastData.put(l, string3);
                    bl = true;
                } else if (this.debugLog) {
                    this.logger.warn("AkamaiValidator.doSignatureAuth failed. b64 of hash doesn't match signature [b64: " + (String)object + ", signature: " + string4 + "]", "vhost", "comment");
                    this.logger.warn("AkamaiValidator.doSignatureAuth failed. b64 of hash doesn't match signature [generated hash: " + DebugUtils.formatBytesShort(byArray) + ", signature hash: " + DebugUtils.formatBytesShort((byte[])Base64.decode((String)string4)) + "]", "vhost", "comment");
                }
            } else if (this.debugLog) {
                this.logger.warn("AkamaiValidator.doSignatureAuth failed. hash is null", "vhost", "comment");
            }
            return bl;
        }

        private String getHeader(String string, String string2) {
            String[] stringArray;
            String string3 = null;
            string = string.replace("\r\n", "\n").replace("\r", "\n");
            for (String string4 : stringArray = string.split("\n")) {
                if (this.debugLog) {
                    this.logger.info("AkamaiValidator.getHeader looking for header: " + string2 + ", line: " + string4, "vhost", "comment");
                }
                if (StringUtils.isEmpty((String)string4) || !string4.toLowerCase().startsWith(string2.toLowerCase())) continue;
                int n = string4.indexOf(":");
                if (n == -1) break;
                try {
                    string3 = string4.substring(n + 1).trim();
                    if (!this.debugLog) break;
                    this.logger.info("AkamaiValidator.getHeader found header: " + string2 + ", value: " + string3, "vhost", "comment");
                }
                catch (Exception exception) {}
                break;
            }
            return string3;
        }
    }
}

