/*
 * Decompiled with CFR 0.152.
 */
package com.wowza.wms.plugin;

import com.wowza.util.StringUtils;
import com.wowza.wms.application.IApplicationInstance;
import com.wowza.wms.application.WMSProperties;
import com.wowza.wms.client.IClient;
import com.wowza.wms.httpstreamer.model.IHTTPStreamerSession;
import com.wowza.wms.logging.WMSLogger;
import com.wowza.wms.logging.WMSLoggerFactory;
import com.wowza.wms.mediacaster.IMediaCaster;
import com.wowza.wms.mediacaster.IMediaCasterNotify2;
import com.wowza.wms.mediacaster.MediaCasterNotifyBase;
import com.wowza.wms.module.ModuleBase;
import com.wowza.wms.plugin.GoogleAnalytics;
import com.wowza.wms.rtp.model.IRTSPActionNotify;
import com.wowza.wms.rtp.model.RTPSession;
import com.wowza.wms.rtp.model.RTPStream;
import com.wowza.wms.rtp.model.RTSPActionNotifyBase;
import com.wowza.wms.rtsp.RTSPRequestMessage;
import com.wowza.wms.rtsp.RTSPResponseMessages;
import com.wowza.wms.server.Server;
import com.wowza.wms.stream.IMediaStream;
import com.wowza.wms.stream.IMediaStreamActionNotify3;
import com.wowza.wms.stream.MediaStreamActionNotifyBase;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.Reader;
import java.net.URL;
import java.net.URLConnection;
import java.net.URLEncoder;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.concurrent.TimeUnit;

public class Analytics
extends ModuleBase {
    private static String PROP_NAME_PREFIX = "wowzalytics";
    private static String MODULE_NAME = "Wowzalytics";
    private static final String PROP_GA_COOKIE = "googleAnalyticsCOOK";
    private static ThreadPoolExecutor eventRequestThreadPool;
    private static long wowzalyticsDelayForFailedRequests;
    private static int wowzalyticsHTTPRetries;
    public static boolean serverDebug;
    private static WMSProperties serverProps;
    private GoogleAnalytics googleAnalytics = null;
    private WMSLogger logger = null;
    private boolean moduleDebug = false;
    private IApplicationInstance appInstance = null;
    private String statsNotificationUrls = null;
    private StreamListener streamListener = new StreamListener();
    private MediaCasterListener mediaCasterListener = new MediaCasterListener();
    private RTSPListener rtspListener = new RTSPListener();

    private boolean getPropertyValueBoolean(String string, boolean bl) {
        boolean bl2 = serverProps.getPropertyBoolean(string, bl);
        bl2 = this.appInstance.getProperties().getPropertyBoolean(string, bl2);
        return bl2;
    }

    private String getPropertyValueStr(String string) {
        String string2 = serverProps.getPropertyStr(string);
        string2 = this.appInstance.getProperties().getPropertyStr(string, string2);
        return string2;
    }

    public void onAppCreate(IApplicationInstance iApplicationInstance) {
        this.appInstance = iApplicationInstance;
        this.logger = WMSLoggerFactory.getLoggerObj((IApplicationInstance)iApplicationInstance);
        this.moduleDebug = this.getPropertyValueBoolean(PROP_NAME_PREFIX + "Debug", false);
        if (this.logger.isDebugEnabled()) {
            this.moduleDebug = true;
        }
        if (this.moduleDebug) {
            this.logger.info(MODULE_NAME + " DEBUG mode is ON");
        } else {
            this.logger.info(MODULE_NAME + " DEBUG mode is OFF");
        }
        this.statsNotificationUrls = this.getPropertyValueStr(PROP_NAME_PREFIX + "StatsNotificationUrls");
        this.googleAnalytics = new GoogleAnalytics(iApplicationInstance.getApplication().getName() + "/" + iApplicationInstance.getName(), this.getPropertyValueStr(PROP_NAME_PREFIX + "GACode"), this.getPropertyValueStr(PROP_NAME_PREFIX + "GADomain"), this.getPropertyValueStr(PROP_NAME_PREFIX + "GAHost"), this.getPropertyValueStr(PROP_NAME_PREFIX + "GAPrefix"));
        iApplicationInstance.addMediaCasterListener((IMediaCasterNotify2)this.mediaCasterListener);
    }

    public void onAppStop(IApplicationInstance iApplicationInstance) {
        this.googleAnalytics = null;
    }

    public void onStreamCreate(IMediaStream iMediaStream) {
        iMediaStream.addClientListener((IMediaStreamActionNotify3)this.streamListener);
    }

    public void onStreamDestroy(IMediaStream iMediaStream) {
        iMediaStream.removeClientListener((IMediaStreamActionNotify3)this.streamListener);
    }

    public void onRTPSessionCreate(RTPSession rTPSession) {
        rTPSession.addActionListener((IRTSPActionNotify)this.rtspListener);
    }

    public void onRTPSessionDestroy(RTPSession rTPSession) {
        rTPSession.removeActionListener((IRTSPActionNotify)this.rtspListener);
    }

    public String getHTTPProtocol(IHTTPStreamerSession iHTTPStreamerSession) {
        String string = "HTTP";
        switch (iHTTPStreamerSession.getSessionProtocol()) {
            case 1: {
                string = "HTTPCupertino";
                break;
            }
            case 4: {
                string = "HTTPMpegDash";
                break;
            }
            case 0: {
                string = "HTTPSmooth";
                break;
            }
            case 2: {
                string = "HTTPSanjose";
            }
        }
        return string;
    }

    public void onHTTPSessionCreate(IHTTPStreamerSession iHTTPStreamerSession) {
        String string = iHTTPStreamerSession.getHTTPHeader("x-playback-session-id");
        if (this.moduleDebug) {
            this.logger.info(MODULE_NAME + " onHTTPSessionCreate::stream.getName()::" + iHTTPStreamerSession.getStreamName() + ":" + string);
        }
        String string2 = this.getHTTPProtocol(iHTTPStreamerSession);
        String string3 = this.sendStatsToGoogle(iHTTPStreamerSession.getSessionId(), iHTTPStreamerSession.getProperties().getPropertyStr(PROP_GA_COOKIE, ""), iHTTPStreamerSession.getStreamName(), "", iHTTPStreamerSession.getIpAddress(), "play", string2);
        if (string3 != null) {
            iHTTPStreamerSession.getProperties().setProperty(PROP_GA_COOKIE, (Object)string3);
        }
        this.sendStatsToRemoteServer(iHTTPStreamerSession.getStreamName(), iHTTPStreamerSession.getAppInstance());
    }

    public void onHTTPSessionDestroy(IHTTPStreamerSession iHTTPStreamerSession) {
        String string = this.getHTTPProtocol(iHTTPStreamerSession);
        String string2 = this.sendStatsToGoogle(iHTTPStreamerSession.getSessionId(), iHTTPStreamerSession.getProperties().getPropertyStr(PROP_GA_COOKIE, ""), iHTTPStreamerSession.getStreamName(), string + "Connect", iHTTPStreamerSession.getIpAddress(), "stop", string);
        if (string2 != null) {
            iHTTPStreamerSession.getProperties().setProperty(PROP_GA_COOKIE, (Object)"");
        }
        this.sendStatsToRemoteServer(iHTTPStreamerSession.getStreamName(), iHTTPStreamerSession.getAppInstance());
    }

    private String sendStatsToGoogle(String string, String string2, String string3, String string4, String string5, String string6, String string7) {
        try {
            if (this.googleAnalytics != null) {
                String string8 = this.googleAnalytics.makeVisitorID(string, string2);
                String string9 = this.googleAnalytics.makeReferrer(URLEncoder.encode(string4, "UTF-8"));
                String string10 = this.googleAnalytics.makeGARequest(URLEncoder.encode(string3, "UTF-8"), string9, string5, string8, URLEncoder.encode(string6, "UTF-8"), URLEncoder.encode(string7, "UTF-8"), URLEncoder.encode(string, "UTF-8"));
                eventRequestThreadPool.submit(new Request(this.logger, string10, string9, this.googleAnalytics.makeGoogleCookie(string8)));
                return string8;
            }
        }
        catch (Exception exception) {
            this.logger.error(MODULE_NAME + ".sendStatsToGoogle exception:" + exception.getMessage(), (Throwable)exception);
        }
        return null;
    }

    private void sendStatsToRemoteServer(String string, IApplicationInstance iApplicationInstance) {
        String[] stringArray;
        if (!StringUtils.isEmpty((String)this.statsNotificationUrls) && (stringArray = this.statsNotificationUrls.split(",")).length > 0) {
            for (int i = 0; i < stringArray.length; ++i) {
                eventRequestThreadPool.submit(new Request(this.logger, stringArray[i].trim() + "?streamType=" + string, string, ""));
            }
        }
    }

    static {
        wowzalyticsDelayForFailedRequests = 1000L;
        wowzalyticsHTTPRetries = 5;
        serverDebug = false;
        serverProps = Server.getInstance().getProperties();
        int n = serverProps.getPropertyInt(PROP_NAME_PREFIX + "ThreadPoolSize", 5);
        int n2 = serverProps.getPropertyInt(PROP_NAME_PREFIX + "ThreadIdleTimeout", 60);
        serverDebug = serverProps.getPropertyBoolean(PROP_NAME_PREFIX + "Debug", false);
        if (WMSLoggerFactory.getLogger(Analytics.class).isDebugEnabled()) {
            serverDebug = true;
        }
        wowzalyticsDelayForFailedRequests = serverProps.getPropertyLong(PROP_NAME_PREFIX + "DelayForFailedRequests", wowzalyticsDelayForFailedRequests);
        wowzalyticsHTTPRetries = serverProps.getPropertyInt(PROP_NAME_PREFIX + "HTTPMaxRetries", wowzalyticsHTTPRetries);
        eventRequestThreadPool = new ThreadPoolExecutor(n, n, n2, TimeUnit.SECONDS, new LinkedBlockingQueue<Runnable>());
        Runtime.getRuntime().addShutdownHook(new Thread(){

            @Override
            public void run() {
                try {
                    if (serverDebug) {
                        WMSLoggerFactory.getLogger(this.getClass()).info(MODULE_NAME + " Runtime.getRuntime().addShutdownHook");
                    }
                    eventRequestThreadPool.shutdown();
                    int n = serverProps.getPropertyInt(PROP_NAME_PREFIX + "ThreadPoolTerminationTimeout", 5);
                    if (!eventRequestThreadPool.awaitTermination(n, TimeUnit.SECONDS)) {
                        eventRequestThreadPool.shutdownNow();
                    }
                }
                catch (InterruptedException interruptedException) {
                    WMSLoggerFactory.getLogger(this.getClass()).error(MODULE_NAME + ".ShutdownHook.run() InterruptedException", (Throwable)interruptedException);
                }
            }
        });
    }

    class Request
    implements Runnable {
        private WMSLogger requestLogger = null;
        final String url;
        final String cookie;
        final String referer;

        public Request(WMSLogger wMSLogger, String string, String string2, String string3) {
            this.requestLogger = wMSLogger;
            this.url = string;
            this.cookie = string3;
            this.referer = string2;
        }

        @Override
        public void run() {
            if (!StringUtils.isEmpty((String)this.url)) {
                if (Analytics.this.moduleDebug) {
                    this.requestLogger.info(MODULE_NAME + " URL is " + this.url + " Cookie is " + this.cookie + " Referer is " + this.referer);
                }
                int n = 0;
                while (true) {
                    boolean bl;
                    if (Analytics.this.moduleDebug) {
                        this.requestLogger.info(MODULE_NAME + " This would fire url of " + this.url + " with cookie of " + this.cookie + " count is " + n);
                    }
                    if (bl = this.httpEvent(this.url, this.referer, this.cookie, 2000)) {
                        this.requestLogger.info(MODULE_NAME + " URL " + this.url + " Success");
                        break;
                    }
                    if (++n >= wowzalyticsHTTPRetries) {
                        this.requestLogger.info(MODULE_NAME + " URL " + this.url + " has failed " + n + " times.");
                        break;
                    }
                    try {
                        if (Analytics.this.moduleDebug) {
                            this.requestLogger.info(MODULE_NAME + " Sleep for " + wowzalyticsDelayForFailedRequests + " milliseconds");
                        }
                        Thread.sleep(wowzalyticsDelayForFailedRequests);
                    }
                    catch (InterruptedException interruptedException) {
                        this.requestLogger.error(MODULE_NAME + ".RequestManager.run() InterruptedException", (Throwable)interruptedException);
                    }
                }
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private boolean httpEvent(String string, String string2, String string3, int n) {
            Reader reader = null;
            try {
                int n2;
                URL uRL = new URL(string);
                URLConnection uRLConnection = uRL.openConnection();
                uRLConnection.setConnectTimeout(n);
                uRLConnection.setReadTimeout(n);
                uRLConnection.setRequestProperty("User-Agent", "WowzaServer");
                if (string3 != null) {
                    uRLConnection.setRequestProperty("Set-Cookie", string3);
                }
                if (string2 != null && string2.length() > 0) {
                    uRLConnection.setRequestProperty("referer", string2);
                }
                uRLConnection.setDoOutput(true);
                StringBuffer stringBuffer = new StringBuffer();
                reader = new BufferedReader(new InputStreamReader(uRLConnection.getInputStream()));
                while ((n2 = reader.read()) > -1) {
                    stringBuffer.append((char)n2);
                }
                boolean bl = true;
                return bl;
            }
            catch (Exception exception) {
                this.requestLogger.error(MODULE_NAME + ".RequestManager.httpEvent() Exception", (Throwable)exception);
                boolean bl = false;
                return bl;
            }
            finally {
                if (reader != null) {
                    try {
                        reader.close();
                    }
                    catch (IOException iOException) {}
                }
            }
        }
    }

    class RTSPListener
    extends RTSPActionNotifyBase {
        RTSPListener() {
        }

        public void onPlay(RTPSession rTPSession, RTSPRequestMessage rTSPRequestMessage, RTSPResponseMessages rTSPResponseMessages) {
            String[] stringArray = rTPSession.getUri().split("/");
            if (stringArray != null && stringArray.length > 0) {
                String string = stringArray[stringArray.length - 1];
                String string2 = "play";
                String string3 = Analytics.this.sendStatsToGoogle(rTPSession.getSessionId(), rTPSession.getProperties().getPropertyStr(Analytics.PROP_GA_COOKIE, ""), string, "RTPConnect", rTPSession.getIp(), string2, "rtp");
                if (string3 != null) {
                    rTPSession.getProperties().setProperty(Analytics.PROP_GA_COOKIE, (Object)"");
                }
                Analytics.this.sendStatsToRemoteServer(string, rTPSession.getAppInstance());
            }
        }

        public void onTeardown(RTPSession rTPSession, RTSPRequestMessage rTSPRequestMessage, RTSPResponseMessages rTSPResponseMessages) {
            String[] stringArray;
            if (rTPSession.getRTSPStream() != null && !rTPSession.getRTSPStream().isModePublish() && (stringArray = rTPSession.getUri().split("/")) != null && stringArray.length > 0) {
                String string = stringArray[stringArray.length - 1];
                String string2 = "stop";
                String string3 = Analytics.this.sendStatsToGoogle(rTPSession.getSessionId(), rTPSession.getProperties().getPropertyStr(Analytics.PROP_GA_COOKIE, ""), string, "RTPConnect", rTPSession.getIp(), string2, "rtp");
                if (string3 != null) {
                    rTPSession.getProperties().setProperty(Analytics.PROP_GA_COOKIE, (Object)"");
                }
                Analytics.this.sendStatsToRemoteServer(string, rTPSession.getAppInstance());
            }
        }
    }

    class StreamListener
    extends MediaStreamActionNotifyBase {
        StreamListener() {
        }

        public void onPlay(IMediaStream iMediaStream, String string, double d, double d2, int n) {
            IClient iClient;
            if (Analytics.this.moduleDebug) {
                Analytics.getLogger().info(MODULE_NAME + " onPlay()::Stream Name: " + string);
            }
            if ((iClient = iMediaStream.getClient()) != null) {
                String string2 = Analytics.this.sendStatsToGoogle(String.valueOf(iClient.getClientId()), iClient.getProperties().getPropertyStr(Analytics.PROP_GA_COOKIE, ""), string, "", iClient.getIp(), "play", "rtmp");
                if (string2 != null) {
                    iClient.getProperties().setProperty(Analytics.PROP_GA_COOKIE, (Object)string2);
                }
                Analytics.this.sendStatsToRemoteServer(string, iClient.getAppInstance());
            }
        }

        public void onStop(IMediaStream iMediaStream) {
            String string = iMediaStream.getName();
            IClient iClient = iMediaStream.getClient();
            if (iClient != null) {
                String string2 = Analytics.this.sendStatsToGoogle(String.valueOf(iClient.getClientId()), iClient.getProperties().getPropertyStr(Analytics.PROP_GA_COOKIE, ""), string, "RTMPConnect-" + string, iClient.getIp(), "stop", "rtmp");
                if (string2 != null) {
                    iClient.getProperties().setProperty(Analytics.PROP_GA_COOKIE, (Object)"");
                }
                Analytics.this.sendStatsToRemoteServer(string, iClient.getAppInstance());
            }
        }

        public void onUnPublish(IMediaStream iMediaStream, String string, boolean bl, boolean bl2) {
            Object object;
            RTPStream rTPStream;
            if (Analytics.this.appInstance.getMediaCasterStreams().getMediaCaster(string) != null) {
                return;
            }
            String string2 = "internal";
            String string3 = "internal";
            String string4 = "localhost";
            IClient iClient = iMediaStream.getClient();
            if (iClient != null) {
                string2 = "rtmp";
                string3 = String.valueOf(iClient.getClientId());
                string4 = iClient.getIp();
            }
            if ((rTPStream = iMediaStream.getRTPStream()) != null && (object = rTPStream.getSession()) != null) {
                string2 = "rtsp";
                string3 = object.getSessionId();
                string4 = object.getIp();
            }
            if ((object = Analytics.this.sendStatsToGoogle(string3, iMediaStream.getProperties().getPropertyStr(Analytics.PROP_GA_COOKIE, ""), string, "", string4, "unpublish", string2)) != null) {
                iMediaStream.getProperties().setProperty(Analytics.PROP_GA_COOKIE, object);
            }
            Analytics.this.sendStatsToRemoteServer(string, Analytics.this.appInstance);
        }

        public void onPublish(IMediaStream iMediaStream, String string, boolean bl, boolean bl2) {
            Object object;
            RTPStream rTPStream;
            if (Analytics.this.appInstance.getMediaCasterStreams().getMediaCaster(string) != null) {
                return;
            }
            String string2 = "internal";
            String string3 = "internal";
            String string4 = "localhost";
            IClient iClient = iMediaStream.getClient();
            if (iClient != null) {
                string2 = "rtmp";
                string3 = String.valueOf(iClient.getClientId());
                string4 = iClient.getIp();
            }
            if ((rTPStream = iMediaStream.getRTPStream()) != null && (object = rTPStream.getSession()) != null) {
                string2 = "rtsp";
                string3 = object.getSessionId();
                string4 = object.getIp();
            }
            if ((object = Analytics.this.sendStatsToGoogle(string3, iMediaStream.getProperties().getPropertyStr(Analytics.PROP_GA_COOKIE, ""), string, "", string4, "publish", string2)) != null) {
                iMediaStream.getProperties().setProperty(Analytics.PROP_GA_COOKIE, object);
            }
            Analytics.this.sendStatsToRemoteServer(string, Analytics.this.appInstance);
        }
    }

    class MediaCasterListener
    extends MediaCasterNotifyBase {
        MediaCasterListener() {
        }

        public void onStreamStart(IMediaCaster iMediaCaster) {
            this.sendNotification(iMediaCaster, "publish");
        }

        public void onStreamStop(IMediaCaster iMediaCaster) {
            this.sendNotification(iMediaCaster, "unpublish");
        }

        private void sendNotification(IMediaCaster iMediaCaster, String string) {
            Object object;
            IMediaStream iMediaStream = iMediaCaster.getStream();
            String string2 = iMediaStream.getName();
            String string3 = "";
            String string4 = "";
            IApplicationInstance iApplicationInstance = null;
            WMSProperties wMSProperties = null;
            String string5 = "";
            if (iMediaStream.getRTPStream() != null) {
                object = iMediaStream.getRTPStream().getSession();
                string3 = object.getIp();
                string4 = object.getSessionId();
                wMSProperties = object.getProperties();
                iApplicationInstance = object.getAppInstance();
                string5 = "rtp";
            } else if (iMediaStream.getClient() != null) {
                object = iMediaStream.getClient();
                string3 = object.getIp();
                string4 = String.valueOf(object.getClientId());
                wMSProperties = object.getProperties();
                iApplicationInstance = object.getAppInstance();
                string5 = "rtmp";
            } else if (iMediaStream.getHTTPStreamerSession() != null) {
                object = iMediaStream.getHTTPStreamerSession();
                string3 = object.getIpAddress();
                string4 = object.getSessionId();
                wMSProperties = object.getProperties();
                iApplicationInstance = object.getAppInstance();
                string5 = Analytics.this.getHTTPProtocol((IHTTPStreamerSession)object);
            } else {
                string3 = "127.0.0.1";
                string4 = String.valueOf(iMediaCaster.getMediaCasterStreamItem().getUniqueId());
                wMSProperties = iMediaStream.getProperties();
                iApplicationInstance = iMediaCaster.getAppInstance();
                string5 = "rtmp";
                Analytics.getLogger().info(MODULE_NAME + " ****** sendNotification()::clientId : " + string4);
                Analytics.getLogger().info(MODULE_NAME + " ****** sendNotification()::mediaCaster.getMediaCasterDef().getName : " + iMediaCaster.getMediaCasterDef().getName());
            }
            if (iApplicationInstance != null && wMSProperties != null) {
                object = Analytics.this.sendStatsToGoogle(string4, wMSProperties.getPropertyStr(Analytics.PROP_GA_COOKIE, ""), string2, "", string3, string, string5);
                if (object != null) {
                    wMSProperties.setProperty(Analytics.PROP_GA_COOKIE, object);
                }
                Analytics.this.sendStatsToRemoteServer(string2, iApplicationInstance);
            }
        }
    }
}

