/*
 * Decompiled with CFR 0.152.
 */
package com.wowza.wms.plugin;

import com.wowza.util.StringUtils;
import com.wowza.wms.application.IApplicationInstance;
import com.wowza.wms.livestreamrecord.manager.StreamRecorderParameters;
import com.wowza.wms.logging.WMSLogger;
import com.wowza.wms.logging.WMSLoggerFactory;
import com.wowza.wms.module.ModuleBase;
import com.wowza.wms.stream.IMediaStream;
import com.wowza.wms.stream.IMediaStreamActionNotify3;
import com.wowza.wms.stream.MediaStreamActionNotifyBase;
import com.wowza.wms.vhost.IVHost;
import java.util.regex.PatternSyntaxException;

public class ModuleAutoRecord
extends ModuleBase {
    public static final String CLASSNAME = "ModuleAutoRecord";
    private WMSLogger logger = null;
    private IApplicationInstance appInstance = null;
    private IVHost vhost = null;
    private StreamListener actionNotify = new StreamListener();
    private String namesStr = null;
    private String namesStrDelimiter = "(\\||,)";
    private RecordType recordType = RecordType.all;
    private Boolean debugLog = false;
    private StreamRecorderParameters recordParams = null;
    private boolean shutDownRecorderOnUnPublish = true;

    public void onAppCreate(IApplicationInstance iApplicationInstance) {
        String string;
        this.logger = WMSLoggerFactory.getLoggerObj((IApplicationInstance)iApplicationInstance);
        this.logger.info("ModuleAutoRecord.onAppCreate[" + iApplicationInstance.getContextStr() + "] Build #6", "application", "comment");
        this.appInstance = iApplicationInstance;
        this.vhost = iApplicationInstance.getVHost();
        this.debugLog = iApplicationInstance.getStreamRecorderProperties().getPropertyBoolean("streamRecorderDebugEnable", this.debugLog.booleanValue());
        this.debugLog = iApplicationInstance.getStreamRecorderProperties().getPropertyBoolean("streamRecorderAutoRecordDebugLog", this.debugLog.booleanValue());
        if (this.logger.isDebugEnabled()) {
            this.debugLog = true;
        }
        if ((string = iApplicationInstance.getStreamType()).contains("-record")) {
            String string2 = string.replace("-record", "");
            iApplicationInstance.setStreamType(string2);
            this.logger.info("ModuleAutoRecord.onAppCreate[" + iApplicationInstance.getContextStr() + "] Application has " + string + " stream type set. Changing to " + string2 + " stream type to prevent conflict.", "application", "comment");
        }
        try {
            this.recordType = RecordType.valueOf(iApplicationInstance.getStreamRecorderProperties().getPropertyStr("streamRecorderRecordType", this.recordType.toString()).toLowerCase());
        }
        catch (Exception exception) {
            this.logger.warn("ModuleAutoRecord.onAppCreate[" + iApplicationInstance.getContextStr() + "] streamRecorderRecordType value not correct. Disabling Automatic recording", "application", "comment");
            this.recordType = RecordType.none;
        }
        this.namesStr = iApplicationInstance.getStreamRecorderProperties().getPropertyStr("streamRecorderStreamNames", null);
        this.namesStrDelimiter = iApplicationInstance.getStreamRecorderProperties().getPropertyStr("streamRecorderStreamNamesDelimiter", this.namesStrDelimiter);
        this.recordParams = new StreamRecorderParameters(iApplicationInstance);
        boolean bl = iApplicationInstance.getStreamRecorderProperties().getPropertyBoolean("streamRecorderRecordAllStreams", this.recordType == RecordType.all);
        bl = iApplicationInstance.getProperties().getPropertyBoolean("streamRecorderRecordAllStreams", bl);
        if (bl) {
            this.recordType = RecordType.all;
        }
        if (this.recordType == RecordType.all) {
            iApplicationInstance.getVHost().getLiveStreamRecordManager().startRecording(iApplicationInstance, this.recordParams);
            this.logger.info("ModuleAutoRecord.onAppCreate[" + iApplicationInstance.getContextStr() + "] recording all streams", "application", "comment");
        }
        this.shutDownRecorderOnUnPublish = iApplicationInstance.getStreamRecorderProperties().getPropertyBoolean("streamRecorderShutDownRecorderOnUnPublish", this.shutDownRecorderOnUnPublish);
        this.shutDownRecorderOnUnPublish = iApplicationInstance.getProperties().getPropertyBoolean("streamRecorderShutDownRecorderOnUnPublish", this.shutDownRecorderOnUnPublish);
        this.logger.info("ModuleAutoRecord.onAppCreate[" + iApplicationInstance.getContextStr() + "] recorders will " + (!this.shutDownRecorderOnUnPublish ? "not " : "") + "be shut down on unpublish", "application", "comment");
    }

    public void onStreamCreate(IMediaStream iMediaStream) {
        iMediaStream.addClientListener((IMediaStreamActionNotify3)this.actionNotify);
    }

    class StreamListener
    extends MediaStreamActionNotifyBase {
        StreamListener() {
        }

        public void onPublish(IMediaStream iMediaStream, String string, boolean bl, boolean bl2) {
            if (ModuleAutoRecord.this.recordType == RecordType.all || ModuleAutoRecord.this.vhost.getLiveStreamRecordManager().getRecorder(ModuleAutoRecord.this.appInstance, string) != null) {
                return;
            }
            boolean bl3 = false;
            boolean bl4 = false;
            switch (ModuleAutoRecord.this.recordType) {
                case allow: {
                    bl3 = this.checkNames(string);
                    if (!bl3) break;
                    bl4 = true;
                    break;
                }
                case deny: {
                    bl3 = this.checkNames(string);
                    if (bl3) break;
                    bl4 = true;
                    break;
                }
                case source: {
                    if (iMediaStream.isTranscodeResult()) break;
                    bl4 = true;
                    break;
                }
                case transcoder: {
                    if (!iMediaStream.isTranscodeResult()) break;
                    bl4 = true;
                    break;
                }
            }
            if (bl4) {
                if (ModuleAutoRecord.this.debugLog.booleanValue()) {
                    ModuleAutoRecord.this.logger.info("ModuleAutoRecord.onPublish [" + ModuleAutoRecord.this.appInstance.getContextStr() + "/" + string + "] starting recording. RecordType: " + ModuleAutoRecord.this.recordType, "application", "comment");
                }
                ModuleAutoRecord.this.vhost.getLiveStreamRecordManager().startRecording(ModuleAutoRecord.this.appInstance, string, ModuleAutoRecord.this.recordParams);
            } else if (ModuleAutoRecord.this.debugLog.booleanValue()) {
                ModuleAutoRecord.this.logger.info("ModuleAutoRecord.onPublish [" + ModuleAutoRecord.this.appInstance.getContextStr() + "/" + string + "] not starting recording. RecordType: " + ModuleAutoRecord.this.recordType, "application", "comment");
            }
        }

        private boolean checkNames(String string) {
            boolean bl = false;
            if (!StringUtils.isEmpty((String)ModuleAutoRecord.this.namesStr)) {
                if (ModuleAutoRecord.this.namesStr.equals("*")) {
                    if (ModuleAutoRecord.this.debugLog.booleanValue()) {
                        ModuleAutoRecord.this.logger.info("ModuleAutoRecord.checkNames [" + ModuleAutoRecord.this.appInstance.getContextStr() + "/" + string + "] match found against *", "application", "comment");
                    }
                    bl = true;
                } else {
                    String[] stringArray;
                    for (String string2 : stringArray = ModuleAutoRecord.this.namesStr.split(ModuleAutoRecord.this.namesStrDelimiter)) {
                        string2 = string2.trim();
                        if (ModuleAutoRecord.this.debugLog.booleanValue()) {
                            ModuleAutoRecord.this.logger.info("ModuleAutoRecord.checkNames [" + ModuleAutoRecord.this.appInstance.getContextStr() + "/" + string + "] regex check against " + string2, "application", "comment");
                        }
                        if (string2.startsWith("*")) {
                            if (ModuleAutoRecord.this.debugLog.booleanValue()) {
                                ModuleAutoRecord.this.logger.info("ModuleAutoRecord.checkNames [" + ModuleAutoRecord.this.appInstance.getContextStr() + "/" + string + "] wildcard suffix check against " + string2, "application", "comment");
                            }
                            if (string.endsWith(string2 = string2.substring(1))) {
                                if (ModuleAutoRecord.this.debugLog.booleanValue()) {
                                    ModuleAutoRecord.this.logger.info("ModuleAutoRecord.checkNames [" + ModuleAutoRecord.this.appInstance.getContextStr() + "/" + string + "] wildcard suffix match found against " + string2, "application", "comment");
                                }
                                bl = true;
                                break;
                            }
                        }
                        if (string2.endsWith("*")) {
                            if (ModuleAutoRecord.this.debugLog.booleanValue()) {
                                ModuleAutoRecord.this.logger.info("ModuleAutoRecord.checkNames [" + ModuleAutoRecord.this.appInstance.getContextStr() + "/" + string + "] wildcard prefix check against " + string2, "application", "comment");
                            }
                            if (string.startsWith(string2 = string2.substring(0, string2.length() - 1))) {
                                if (ModuleAutoRecord.this.debugLog.booleanValue()) {
                                    ModuleAutoRecord.this.logger.info("ModuleAutoRecord.checkNames [" + ModuleAutoRecord.this.appInstance.getContextStr() + "/" + string + "] wildcard prefix match found against " + string2, "application", "comment");
                                }
                                bl = true;
                                break;
                            }
                        }
                        try {
                            if (!string.matches(string2)) continue;
                            if (ModuleAutoRecord.this.debugLog.booleanValue()) {
                                ModuleAutoRecord.this.logger.info("ModuleAutoRecord.checkNames [" + ModuleAutoRecord.this.appInstance.getContextStr() + "/" + string + "] regex match found against " + string2, "application", "comment");
                            }
                            bl = true;
                            break;
                        }
                        catch (PatternSyntaxException patternSyntaxException) {
                            if (!ModuleAutoRecord.this.debugLog.booleanValue()) continue;
                            ModuleAutoRecord.this.logger.warn("ModuleAutoRecord.checkNames [" + ModuleAutoRecord.this.appInstance.getContextStr() + "/" + string + "] exception: " + patternSyntaxException.getMessage(), "application", "comment");
                        }
                    }
                }
            } else if (ModuleAutoRecord.this.debugLog.booleanValue()) {
                ModuleAutoRecord.this.logger.info("ModuleAutoRecord.checkNames [" + ModuleAutoRecord.this.appInstance.getContextStr() + "/" + string + "] streamRecorderStreamNames list is empty", "application", "comment");
            }
            return bl;
        }

        public void onUnPublish(IMediaStream iMediaStream, String string, boolean bl, boolean bl2) {
            if (ModuleAutoRecord.this.shutDownRecorderOnUnPublish) {
                if (ModuleAutoRecord.this.debugLog.booleanValue()) {
                    ModuleAutoRecord.this.logger.info("ModuleAutoRecord.onUnPublish [" + ModuleAutoRecord.this.appInstance.getContextStr() + "/" + string + "] shutting down recorder", "application", "comment");
                }
                ModuleAutoRecord.this.vhost.getLiveStreamRecordManager().stopRecording(ModuleAutoRecord.this.appInstance, string);
            }
        }
    }

    private static enum RecordType {
        all,
        source,
        transcoder,
        allow,
        whitelist,
        deny,
        blacklist,
        none;

    }
}

