/*
 * Decompiled with CFR 0.152.
 */
package com.wowza.wms.plugin.avmix;

import com.wowza.util.StringUtils;
import com.wowza.wms.application.IApplicationInstance;
import com.wowza.wms.logging.WMSLogger;
import com.wowza.wms.logging.WMSLoggerFactory;
import com.wowza.wms.plugin.avmix.OutputStream;
import com.wowza.wms.plugin.avmix.StreamInfo;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.Timer;
import java.util.TimerTask;

public class AVMixer {
    private static final String CLASS_NAME = "AVMixer";
    private WMSLogger logger;
    private IApplicationInstance appInstance;
    private Map<String, OutputStream> outputStreams = new HashMap<String, OutputStream>();
    private Map<String, StreamInfo> streamNames = new HashMap<String, StreamInfo>();
    private Timer pendingShutdownChecker = null;
    private Object lock = new Object();
    private boolean debugLog = false;

    public AVMixer(IApplicationInstance iApplicationInstance) {
        this.appInstance = iApplicationInstance;
        this.logger = WMSLoggerFactory.getLoggerObj((IApplicationInstance)iApplicationInstance);
        this.debugLog = iApplicationInstance.getProperties().getPropertyBoolean("avMixDebugLog", this.debugLog);
        if (this.logger.isDebugEnabled()) {
            this.debugLog = true;
        }
        this.pendingShutdownChecker = new Timer("AVMixer.PendingShutdownChecker [" + iApplicationInstance.getContextStr() + "]");
        this.pendingShutdownChecker.schedule(new TimerTask(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void run() {
                Object object = AVMixer.this.lock;
                synchronized (object) {
                    Iterator iterator = AVMixer.this.outputStreams.keySet().iterator();
                    while (iterator.hasNext()) {
                        OutputStream outputStream = (OutputStream)AVMixer.this.outputStreams.get(iterator.next());
                        if (outputStream.isRunning()) continue;
                        if (AVMixer.this.debugLog) {
                            AVMixer.this.logger.info("AVMixer.PendingShutdownChecker.run(): [removing output stream " + outputStream.getName() + "]", "application", "comment");
                        }
                        iterator.remove();
                    }
                }
            }
        }, 1000L, 1000L);
        this.logger.info("AVMixer.constructor: [" + iApplicationInstance.getContextStr() + "]", "application", "comment");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String addOrUpdateOutputStream(String string, String string2, String string3, long l, boolean bl) {
        Object object;
        if (StringUtils.isEmpty((String)string)) {
            return "Output Name not set. ";
        }
        Object object2 = "";
        if (StringUtils.isEmpty((String)string2)) {
            string2 = null;
        }
        if (StringUtils.isEmpty((String)string3)) {
            string3 = null;
        }
        Object object3 = this.lock;
        synchronized (object3) {
            object = this.streamNames.get(string);
            if (object == null) {
                object = new StreamInfo();
                ((StreamInfo)object).setOutputName(string);
                this.streamNames.put(string, (StreamInfo)object);
                object2 = (String)object2 + "Adding Output StreamInfo: " + string + ". ";
            } else {
                object2 = (String)object2 + "Updating Output Stream Info: " + string + ". ";
            }
            ((StreamInfo)object).setVideoName(string2);
            ((StreamInfo)object).setAudioName(string3);
            ((StreamInfo)object).setSortDelay(l);
            ((StreamInfo)object).setUseOriginalTimeCodes(bl);
        }
        object2 = (String)object2 + "Video Source set to " + string2 + ". Audio Source set to " + string3 + ". ";
        object = this.lock;
        synchronized (object) {
            object3 = this.outputStreams.get(string);
        }
        if (object3 != null && ((OutputStream)object3).isRunning()) {
            ((OutputStream)object3).setVideoName(string2);
            ((OutputStream)object3).setAudioName(string3);
            object2 = (String)object2 + "Updating Output Stream: " + string + ". Video Source set to " + string2 + ". Audio Source set to " + string3 + ". ";
        } else {
            object2 = (String)object2 + this.startOutputStream(string, string2, string3, l, bl);
        }
        return object2;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String setVideoSource(String string, String string2) {
        StreamInfo streamInfo;
        if (StringUtils.isEmpty((String)string)) {
            return "Output Name not set. ";
        }
        if (StringUtils.isEmpty((String)string2)) {
            string2 = null;
        }
        Object object = "";
        Object object2 = this.lock;
        synchronized (object2) {
            streamInfo = this.streamNames.get(string);
            if (streamInfo == null) {
                streamInfo = new StreamInfo();
                streamInfo.setOutputName(string);
                this.streamNames.put(string, streamInfo);
            }
            streamInfo.setVideoName(string2);
        }
        object = "Updating Output Stream Info: " + string + ". Video Source set to " + string2 + ". ";
        Object object3 = this.lock;
        synchronized (object3) {
            object2 = this.outputStreams.get(string);
        }
        if (object2 != null && ((OutputStream)object2).isRunning()) {
            ((OutputStream)object2).setVideoName(string2);
        } else {
            object = (String)object + this.startOutputStream(string, string2, streamInfo.getAudioName(), streamInfo.getSortDelay(), streamInfo.isUseOriginalTimeCodes());
        }
        return object;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String setAudioSource(String string, String string2) {
        StreamInfo streamInfo;
        if (StringUtils.isEmpty((String)string)) {
            return "Output Name not set. ";
        }
        if (StringUtils.isEmpty((String)string2)) {
            string2 = null;
        }
        Object object = "";
        Object object2 = this.lock;
        synchronized (object2) {
            streamInfo = this.streamNames.get(string);
            if (streamInfo == null) {
                streamInfo = new StreamInfo();
                streamInfo.setOutputName(string);
                this.streamNames.put(string, streamInfo);
            }
            streamInfo.setAudioName(string2);
        }
        object = "Updating Output Stream Info: " + string + ". Audio Source set to " + string2 + ". ";
        Object object3 = this.lock;
        synchronized (object3) {
            object2 = this.outputStreams.get(string);
        }
        if (object2 != null && ((OutputStream)object2).isRunning()) {
            ((OutputStream)object2).setAudioName(string2);
        } else {
            object = (String)object + this.startOutputStream(string, streamInfo.getVideoName(), string2, streamInfo.getSortDelay(), streamInfo.isUseOriginalTimeCodes());
        }
        return object;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String removeOutputStream(String string) {
        if (StringUtils.isEmpty((String)string)) {
            return "Output Name not set";
        }
        Object object = "";
        Object object2 = this.lock;
        synchronized (object2) {
            this.streamNames.remove(string);
        }
        object = "Removed Output Stream Info: " + string + ". ";
        object = (String)object + this.stopOutputStream(string, true);
        return object;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addStream(String string) {
        Object object = this.lock;
        synchronized (object) {
            for (StreamInfo streamInfo : this.streamNames.values()) {
                if (!streamInfo.getVideoName().equals(string) && !streamInfo.getAudioName().equals(string)) continue;
                String string2 = "";
                string2 = this.startOutputStream(streamInfo.getOutputName(), streamInfo.getVideoName(), streamInfo.getAudioName(), streamInfo.getSortDelay(), streamInfo.isUseOriginalTimeCodes());
                this.logger.info("AVMixer.addStream [" + string2 + "]");
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeStream(String string) {
        Object object = this.lock;
        synchronized (object) {
            for (StreamInfo streamInfo : this.streamNames.values()) {
                OutputStream outputStream;
                if (streamInfo.getVideoName().equals(string) && (outputStream = this.outputStreams.get(streamInfo.getOutputName())) != null) {
                    outputStream.setVideoName(null);
                    this.logger.info("AVMixer.removeStream [" + this.appInstance.getContextStr() + ": Video Source: " + string + " removed from " + streamInfo.getOutputName() + "]");
                }
                if (streamInfo.getAudioName().equals(string) && (outputStream = this.outputStreams.get(streamInfo.getOutputName())) != null) {
                    outputStream.setAudioName(null);
                    this.logger.info("AVMixer.removeStream [" + this.appInstance.getContextStr() + ": Audio Source: " + string + " removed from " + streamInfo.getOutputName() + "]");
                }
                if (!streamInfo.getOutputName().equals(string)) continue;
                this.outputStreams.remove(string);
                this.logger.info("AVMixer.removeStream [" + this.appInstance.getContextStr() + ": OutputStream: " + string + " unPublished]");
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private String startOutputStream(String string, String string2, String string3, long l, boolean bl) {
        Object object = "";
        OutputStream outputStream = null;
        Object object2 = this.lock;
        synchronized (object2) {
            outputStream = this.outputStreams.get(string);
        }
        if (outputStream != null && outputStream.isRunning()) {
            outputStream.setVideoName(string2);
            outputStream.setAudioName(string3);
            object = "Output Stream Updated: [" + this.appInstance.getContextStr() + "/" + string + " Video Source: " + string2 + ", Audio Source: " + string3 + "]. ";
        } else {
            object2 = this.lock;
            synchronized (object2) {
                outputStream = new OutputStream(this.appInstance, string, System.currentTimeMillis(), l, bl);
                outputStream.setVideoName(string2);
                outputStream.setAudioName(string3);
                outputStream.setName("AVMixOutputStream: [" + this.appInstance.getContextStr() + "/" + string + "]");
                outputStream.setDaemon(true);
                outputStream.start();
                this.outputStreams.put(string, outputStream);
                object = "Output Stream Started: [" + this.appInstance.getContextStr() + "/" + string + " Video Source: " + string2 + ", Audio Source: " + string3 + "]. ";
            }
        }
        return object;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private String stopOutputStream(String string, boolean bl) {
        OutputStream outputStream;
        if (StringUtils.isEmpty((String)string)) {
            return "Output Name not set. ";
        }
        Object object = "";
        Object object2 = this.lock;
        synchronized (object2) {
            outputStream = this.outputStreams.get(string);
        }
        if (outputStream != null) {
            if (bl) {
                outputStream.close();
            } else {
                outputStream.setVideoName(null);
                outputStream.setAudioName(null);
            }
            object = "Stopping Output Stream: " + this.appInstance.getContextStr() + "/" + string + ". Delayed: " + !bl;
        } else {
            object = "Output Stream already stopped: " + this.appInstance.getContextStr() + "/" + string + ". ";
        }
        return object;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Map<String, OutputStream> getCurrentOutputStreams() {
        Object object = this.lock;
        synchronized (object) {
            HashMap<String, OutputStream> hashMap = new HashMap<String, OutputStream>();
            hashMap.putAll(this.outputStreams);
            return hashMap;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Map<String, StreamInfo> getConfiguredOutputStreams() {
        Object object = this.lock;
        synchronized (object) {
            HashMap<String, StreamInfo> hashMap = new HashMap<String, StreamInfo>();
            hashMap.putAll(this.streamNames);
            return hashMap;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void close() {
        ArrayList<String> arrayList = new ArrayList<String>();
        Iterator iterator = this.lock;
        synchronized (iterator) {
            if (this.pendingShutdownChecker != null) {
                this.pendingShutdownChecker.cancel();
            }
            this.pendingShutdownChecker = null;
            arrayList.addAll(this.outputStreams.keySet());
        }
        for (String string : arrayList) {
            this.stopOutputStream(string, true);
        }
        this.outputStreams.clear();
    }

    public void finalize() {
        this.close();
    }
}

