/*
 * Decompiled with CFR 0.152.
 */
package com.wowza.wms.plugin.avmix;

import com.wowza.util.StringUtils;
import com.wowza.wms.application.IApplicationInstance;
import com.wowza.wms.logging.WMSLogger;
import com.wowza.wms.logging.WMSLoggerFactory;
import com.wowza.wms.mediacaster.IMediaCaster;
import com.wowza.wms.mediacaster.IMediaCasterNotify;
import com.wowza.wms.mediacaster.IMediaCasterNotify2;
import com.wowza.wms.mediacaster.MediaCasterNotifyBase;
import com.wowza.wms.module.ModuleBase;
import com.wowza.wms.plugin.avmix.AVMixer;
import com.wowza.wms.stream.IMediaStream;
import com.wowza.wms.stream.IMediaStreamActionNotify3;
import com.wowza.wms.stream.MediaStreamActionNotifyBase;

public class ModuleAVMix
extends ModuleBase {
    public static final String MODULE_NAME = "ModuleAVMix";
    private WMSLogger logger;
    private boolean debugLog = false;
    private IApplicationInstance appInstance;
    private AVMixer mixer;
    private StreamListener streamListener = new StreamListener();
    private MediaCasterListener mediaCasterListener = new MediaCasterListener();

    public void onAppStart(IApplicationInstance iApplicationInstance) {
        this.logger = WMSLoggerFactory.getLoggerObj((IApplicationInstance)iApplicationInstance);
        this.appInstance = iApplicationInstance;
        this.debugLog = iApplicationInstance.getProperties().getPropertyBoolean("avMixDebugLog", this.debugLog);
        if (this.logger.isDebugEnabled()) {
            this.debugLog = true;
        }
        iApplicationInstance.addMediaCasterListener((IMediaCasterNotify2)this.mediaCasterListener);
        this.mixer = new AVMixer(iApplicationInstance);
        String string = iApplicationInstance.getProperties().getPropertyStr("avMixNames");
        if (!StringUtils.isEmpty((String)string)) {
            this.loadConfig(string);
        } else {
            this.logger.info("ModuleAVMix.onAppStart No AVMixer config set in properties", "application", "comment");
        }
    }

    private void loadConfig(String string) {
        if (!StringUtils.isEmpty((String)string)) {
            String[] stringArray;
            for (String string2 : stringArray = string.split("\\|")) {
                String string3 = null;
                String string4 = null;
                String string5 = null;
                long l = this.appInstance.getProperties().getPropertyLong("avMixSortDelay", 10000L);
                boolean bl = this.appInstance.getProperties().getPropertyBoolean("avMixUseOriginalTimecodes", false);
                String[] stringArray2 = string2.trim().split(",");
                for (String string6 : stringArray2) {
                    String[] stringArray3 = string6.trim().split(":");
                    if (stringArray3.length != 2) continue;
                    if (stringArray3[0].trim().equalsIgnoreCase("outputName")) {
                        string3 = stringArray3[1].trim();
                    }
                    if (stringArray3[0].trim().equalsIgnoreCase("videoName")) {
                        string4 = stringArray3[1].trim();
                    }
                    if (stringArray3[0].trim().equalsIgnoreCase("audioName")) {
                        string5 = stringArray3[1].trim();
                    }
                    try {
                        if (stringArray3[0].trim().equalsIgnoreCase("sortDelay")) {
                            l = Long.parseLong(stringArray3[1].trim());
                        }
                    }
                    catch (NumberFormatException numberFormatException) {
                        this.logger.warn("ModuleAVMix.loadConfig invalid valule for sortDelay [" + stringArray3[1].trim() + "]", "application", "comment");
                    }
                    if (!stringArray3[0].trim().equalsIgnoreCase("useOriginalTimecodes")) continue;
                    bl = Boolean.parseBoolean(stringArray3[1].trim());
                }
                Object object = "";
                Object object2 = "";
                if (string3 == null) {
                    object = (String)object + "Output Name is empty.  Cannot create Output Stream.";
                } else {
                    if (string4 == null) {
                        object2 = "Video Name not set for Output Stream: " + string3 + " ";
                    }
                    if (string5 == null) {
                        object2 = (String)object2 + "Audio Name not set for Output Stream: " + string3 + " ";
                    }
                }
                if (!((String)object).equals("")) {
                    this.logger.error("ModuleAVMix.loadConfig " + (String)object + " [" + string2 + "]", "application", "comment");
                    continue;
                }
                if (!((String)object2).equals("")) {
                    this.logger.warn("ModuleAVMix.loadConfig " + (String)object2 + " [" + string2 + "]", "application", "comment");
                }
                String string7 = this.mixer.addOrUpdateOutputStream(string3, string4, string5, l, bl);
                this.logger.info("ModuleAVMix.loadConfig " + string7 + " [" + string2 + "]", "application", "comment");
            }
        }
    }

    public void onAppStop(IApplicationInstance iApplicationInstance) {
        if (this.mixer != null) {
            this.mixer.close();
        }
        this.mixer = null;
        iApplicationInstance.removeMediaCasterListener((IMediaCasterNotify)this.mediaCasterListener);
    }

    public void onStreamCreate(IMediaStream iMediaStream) {
        iMediaStream.addClientListener((IMediaStreamActionNotify3)this.streamListener);
    }

    public void onStreamDestroy(IMediaStream iMediaStream) {
        iMediaStream.removeClientListener((IMediaStreamActionNotify3)this.streamListener);
    }

    public String addOrUpdateOutputStream(String string, String string2, String string3, long l, boolean bl) {
        return this.mixer.addOrUpdateOutputStream(string, string2, string3, l, bl);
    }

    public String setVideoSource(String string, String string2) {
        return this.mixer.setVideoSource(string, string2);
    }

    public String setAudioSource(String string, String string2) {
        return this.mixer.setAudioSource(string, string2);
    }

    public String removeOutputStream(String string) {
        return this.mixer.removeOutputStream(string);
    }

    public String[] getOutputNames() {
        return this.mixer.getConfiguredOutputStreams().keySet().toArray(new String[0]);
    }

    private class MediaCasterListener
    extends MediaCasterNotifyBase {
        private MediaCasterListener() {
        }

        public void onStreamStart(IMediaCaster iMediaCaster) {
            String string = iMediaCaster.getStream().getName();
            if (ModuleAVMix.this.mixer != null) {
                ModuleAVMix.this.mixer.addStream(string);
            }
        }

        public void onStreamStop(IMediaCaster iMediaCaster) {
            String string = iMediaCaster.getStream().getName();
            if (ModuleAVMix.this.mixer != null) {
                ModuleAVMix.this.mixer.removeStream(string);
            }
        }
    }

    private class StreamListener
    extends MediaStreamActionNotifyBase {
        private StreamListener() {
        }

        public void onPublish(IMediaStream iMediaStream, String string, boolean bl, boolean bl2) {
            if (ModuleAVMix.this.appInstance.getMediaCasterStreams().getMediaCaster(string) != null) {
                return;
            }
            if (ModuleAVMix.this.mixer != null) {
                ModuleAVMix.this.mixer.addStream(string);
            }
        }

        public void onUnPublish(IMediaStream iMediaStream, String string, boolean bl, boolean bl2) {
            if (ModuleAVMix.this.appInstance.getMediaCasterStreams().getMediaCaster(string) != null) {
                return;
            }
            if (ModuleAVMix.this.mixer != null) {
                ModuleAVMix.this.mixer.removeStream(string);
            }
        }
    }
}

