/*
 * Decompiled with CFR 0.152.
 */
package com.wowza.wms.plugin.avmix;

import com.wowza.util.FLVUtils;
import com.wowza.wms.amf.AMFPacket;
import com.wowza.wms.application.IApplicationInstance;
import com.wowza.wms.logging.WMSLogger;
import com.wowza.wms.logging.WMSLoggerFactory;
import com.wowza.wms.stream.IMediaStream;
import com.wowza.wms.stream.IMediaStreamMetaDataProvider;
import com.wowza.wms.stream.publish.Publisher;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.List;
import java.util.PriorityQueue;
import java.util.Queue;

public class OutputStream
extends Thread {
    public static final String CLASS_NAME = "OutputStream";
    private IApplicationInstance appInstance;
    private WMSLogger logger;
    private IMediaStream audioSource;
    private IMediaStream videoSource;
    private Publisher publisher;
    private Queue<AMFPacket> packets = new PriorityQueue<AMFPacket>(16, new PacketComparator());
    private String outputName;
    private volatile String audioName;
    private volatile String videoName;
    private long startTime = -1L;
    private long delayOffset = -1L;
    private long audioOffset = -1L;
    private long videoOffset = -1L;
    private long sortDelay = 10000L;
    private long flushInterval = 250L;
    private long audioSeq = -1L;
    private long videoSeq = -1L;
    private long lastTC = -1L;
    private long lastProcessedAudioTC = -1L;
    private long lastProcessedVideoTC = -1L;
    private long videoSwitchTimecode = -1L;
    private long audioSwitchTimecode = -1L;
    private boolean useOriginalTimecodes = false;
    private boolean addAudioData = true;
    private boolean addVideoData = true;
    private boolean isFirstAudio = true;
    private boolean isFirstVideo = true;
    private boolean foundFirstAudio = false;
    private boolean foundFirstVideo = false;
    private boolean waitForKeyframe = true;
    private boolean pendingVideoSwitch = false;
    private boolean pendingAudioSwitch = false;
    private boolean debugLog = false;
    private boolean doQuit;
    private boolean running = true;

    public OutputStream(IApplicationInstance iApplicationInstance, String string, long l, long l2, boolean bl) {
        this.appInstance = iApplicationInstance;
        this.outputName = string;
        this.startTime = l;
        this.sortDelay = l2;
        this.useOriginalTimecodes = bl;
        this.logger = WMSLoggerFactory.getLoggerObj((IApplicationInstance)iApplicationInstance);
        this.debugLog = iApplicationInstance.getProperties().getPropertyBoolean("avMixDebugLog", this.debugLog);
        if (this.logger.isDebugEnabled()) {
            this.debugLog = true;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void run() {
        try {
            while (true) {
                OutputStream outputStream = this;
                synchronized (outputStream) {
                    if (this.doQuit) {
                        if (this.debugLog) {
                            this.logger.info("OutputStream.run(): [" + this.appInstance.getContextStr() + "/" + this.outputName + " doQuit]", "application", "comment");
                        }
                        this.running = false;
                        break;
                    }
                }
                this.processVideoSource();
                this.processAudioSource();
                this.processOutput();
                outputStream = this;
                synchronized (outputStream) {
                    long l = System.currentTimeMillis();
                    if (this.packets.isEmpty() && this.videoSource == null && this.audioSource == null) {
                        if (this.sortDelay >= 0L) {
                            if (this.useOriginalTimecodes) {
                                if (l - this.sortDelay > (this.lastTC == -1L ? this.startTime : this.lastTC + this.delayOffset)) {
                                    if (this.debugLog) {
                                        this.logger.info("OutputStream.run(): [" + this.appInstance.getContextStr() + "/" + this.outputName + " shutdown : " + this.packets.size() + " : " + (l - this.sortDelay) + " : " + (this.lastTC + this.delayOffset) + " : " + this.startTime + "]", "application", "comment");
                                    }
                                    this.running = false;
                                    break;
                                }
                            } else if (l - this.sortDelay > (this.lastTC == -1L ? this.startTime : this.lastTC)) {
                                if (this.debugLog) {
                                    this.logger.info("OutputStream.run(): [" + this.appInstance.getContextStr() + "/" + this.outputName + " shutdown : " + this.packets.size() + " : " + (l - this.sortDelay) + " : " + this.lastTC + " : " + this.startTime + "]", "application", "comment");
                                }
                                this.running = false;
                                break;
                            }
                        } else {
                            if (this.debugLog) {
                                this.logger.info("OutputStream.run(): [" + this.appInstance.getContextStr() + "/" + this.outputName + " shutdown : empty packet list and no sources]", "application", "comment");
                            }
                            this.running = false;
                            break;
                        }
                    }
                }
                try {
                    Thread.sleep(this.flushInterval);
                }
                catch (InterruptedException interruptedException) {}
            }
        }
        catch (Exception exception) {
            this.logger.error("OutputStream.run() Exception: " + exception.getMessage(), (Throwable)exception);
        }
        finally {
            if (this.publisher != null) {
                this.publisher.unpublish();
                this.publisher.close();
            }
            this.publisher = null;
            this.running = false;
        }
    }

    /*
     * Enabled aggressive block sorting
     */
    private void processVideoSource() {
        AMFPacket aMFPacket;
        int n;
        int n2;
        List list;
        block28: {
            IMediaStream iMediaStream;
            block30: {
                block29: {
                    if (this.debugLog) {
                        this.logger.info("OutputStream.processVideoSource(): [" + this.appInstance.getContextStr() + "/" + this.outputName + "]", "application", "comment");
                    }
                    if ((iMediaStream = this.appInstance.getStreams().getStream(this.videoName)) == null) {
                        this.videoSource = null;
                        if (!this.debugLog) return;
                        this.logger.info("OutputStream.processVideoSource(): [" + this.appInstance.getContextStr() + "/" + this.outputName + " video source not running]", "application", "comment");
                        return;
                    }
                    if (iMediaStream == this.videoSource) break block28;
                    if (this.videoSource != null) {
                        this.pendingVideoSwitch = true;
                    }
                    if (!this.pendingVideoSwitch || !this.useOriginalTimecodes || !this.waitForKeyframe) break block29;
                    list = iMediaStream.getLastKeyFrame();
                    if (this.videoSwitchTimecode != -1L) break block30;
                    if (list != null && this.lastProcessedVideoTC != -1L && list.getAbsTimecode() > this.lastProcessedVideoTC) {
                        this.videoSwitchTimecode = list.getAbsTimecode();
                        if (this.debugLog) {
                            this.logger.info("OutputStream.processVideoSource(): [" + this.appInstance.getContextStr() + "/" + this.outputName + " setting switchTimecode " + this.videoSwitchTimecode + "]", "application", "comment");
                        }
                        break block30;
                    } else {
                        if (!this.debugLog) return;
                        this.logger.info("OutputStream.processVideoSource(): [" + this.appInstance.getContextStr() + "/" + this.outputName + " pending switch waiting for new stream to catch up " + (list != null ? list.getAbsTimecode() : 0L) + ": " + this.lastProcessedVideoTC + "]", "application", "comment");
                        return;
                    }
                }
                this.pendingVideoSwitch = false;
            }
            if (!this.pendingVideoSwitch) {
                this.videoSource = iMediaStream;
                this.videoOffset = -1L;
                this.videoSeq = -1L;
                this.foundFirstVideo = false;
                this.isFirstVideo = true;
                if (this.debugLog) {
                    this.logger.info("OutputStream.processVideoSource(): [" + this.appInstance.getContextStr() + "/" + this.outputName + " video source reset]", "application", "comment");
                }
            }
        }
        if ((list = this.videoSource.getPlayPackets()) == null || list.isEmpty()) {
            if (!this.debugLog) return;
            this.logger.info("OutputStream.processVideoSource(): [" + this.appInstance.getContextStr() + "/" + this.outputName + " video source no packets]", "application", "comment");
            return;
        }
        long l = ((AMFPacket)list.get(0)).getSeq();
        int n3 = n2 = this.videoSeq == -1L ? 0 : (int)(this.videoSeq - l + 1L);
        if (n2 < 0) {
            n2 = 0;
        }
        if (n2 >= list.size()) {
            return;
        }
        if (!this.foundFirstVideo) {
            for (n = list.size() - 1; n >= 0; --n) {
                aMFPacket = (AMFPacket)list.get(n);
                if (!FLVUtils.isVideoKeyFrame((AMFPacket)aMFPacket) || this.videoSwitchTimecode != -1L && aMFPacket.getAbsTimecode() != this.videoSwitchTimecode) continue;
                this.videoSwitchTimecode = -1L;
                this.foundFirstVideo = true;
                n2 = n;
                if (this.useOriginalTimecodes) {
                    if (this.delayOffset == -1L) {
                        this.delayOffset = System.currentTimeMillis() - aMFPacket.getAbsTimecode();
                    }
                } else {
                    this.videoOffset = System.currentTimeMillis() - aMFPacket.getAbsTimecode();
                    if (this.videoOffset + aMFPacket.getAbsTimecode() <= this.lastProcessedVideoTC) {
                        this.videoOffset = this.lastProcessedVideoTC + aMFPacket.getTimecode() - aMFPacket.getAbsTimecode();
                    }
                }
                if (!this.debugLog) break;
                this.logger.info("OutputStream.processVideoSource(): [" + this.appInstance.getContextStr() + "/" + this.outputName + " found video start. " + this.lastProcessedVideoTC + " : " + System.currentTimeMillis() + " : " + this.videoOffset + " : " + n2 + "]", "application", "comment");
                break;
            }
            if (!this.foundFirstVideo) {
                return;
            }
        }
        n = n2;
        while (n < list.size()) {
            aMFPacket = (AMFPacket)list.get(n);
            int n4 = aMFPacket.getType();
            if (n4 != 8 && (n4 != 18 && n4 != 15 || this.addVideoData)) {
                AMFPacket aMFPacket2;
                long l2;
                if (this.videoSwitchTimecode != -1L && aMFPacket.getAbsTimecode() >= this.videoSwitchTimecode) {
                    if (this.debugLog) {
                        this.logger.info("OutputStream.processVideoSource(): [" + this.appInstance.getContextStr() + "/" + this.outputName + " (packet.getAbsTimecode() >= switchTimecode) " + aMFPacket + "]", "application", "comment");
                    }
                    this.videoSource = null;
                    this.pendingVideoSwitch = false;
                    return;
                }
                long l3 = l2 = this.useOriginalTimecodes ? aMFPacket.getAbsTimecode() : this.videoOffset + aMFPacket.getAbsTimecode();
                if (this.isFirstVideo && n4 == 9) {
                    IMediaStreamMetaDataProvider iMediaStreamMetaDataProvider;
                    aMFPacket2 = this.videoSource.getVideoCodecConfigPacket(aMFPacket.getAbsTimecode());
                    if (aMFPacket2 != null) {
                        iMediaStreamMetaDataProvider = new AMFPacket(9, 0, aMFPacket2.getData());
                        iMediaStreamMetaDataProvider.setAbsTimecode(l2);
                        this.packets.add((AMFPacket)iMediaStreamMetaDataProvider);
                        if (this.debugLog) {
                            this.logger.info("OutputStream.processVideoSource(): [" + this.appInstance.getContextStr() + "/" + this.outputName + " add video config packet. " + aMFPacket2 + " : " + (AMFPacket)iMediaStreamMetaDataProvider + "]", "application", "comment");
                        }
                    }
                    if (this.addVideoData && (iMediaStreamMetaDataProvider = this.videoSource.getMetaDataProvider()) != null) {
                        ArrayList arrayList = new ArrayList();
                        iMediaStreamMetaDataProvider.onStreamStart(arrayList, aMFPacket.getAbsTimecode());
                        for (AMFPacket aMFPacket3 : arrayList) {
                            if (aMFPacket3 == null || aMFPacket3.getSize() <= 0 || aMFPacket3.getData() == null) continue;
                            AMFPacket aMFPacket4 = new AMFPacket(18, 0, aMFPacket3.getData());
                            aMFPacket4.setAbsTimecode(l2);
                            this.packets.add(aMFPacket4);
                            if (!this.debugLog) continue;
                            this.logger.info("OutputStream.processVideoSource(): [" + this.appInstance.getContextStr() + "/" + this.outputName + " add video metadata packet. " + aMFPacket3 + " : " + aMFPacket4 + "]", "application", "comment");
                        }
                    }
                    this.isFirstVideo = false;
                }
                aMFPacket2 = new AMFPacket(n4, 0, aMFPacket.getData());
                aMFPacket2.setAbsTimecode(l2);
                this.packets.add(aMFPacket2);
                if (this.debugLog) {
                    this.logger.info("OutputStream.processVideoSource(): [" + this.appInstance.getContextStr() + "/" + this.outputName + " add video packet. " + aMFPacket + " : " + aMFPacket2 + "]", "application", "comment");
                }
                this.videoSeq = aMFPacket.getSeq();
                this.lastProcessedVideoTC = l2;
            }
            ++n;
        }
    }

    /*
     * Enabled aggressive block sorting
     */
    private void processAudioSource() {
        AMFPacket aMFPacket;
        int n;
        int n2;
        List list;
        block27: {
            IMediaStream iMediaStream;
            block29: {
                block28: {
                    if (this.debugLog) {
                        this.logger.info("OutputStream.processAudioSource(): [" + this.appInstance.getContextStr() + "/" + this.outputName + "]", "application", "comment");
                    }
                    if ((iMediaStream = this.appInstance.getStreams().getStream(this.audioName)) == null) {
                        this.audioSource = null;
                        if (!this.debugLog) return;
                        this.logger.info("OutputStream.processAudioSource(): [" + this.appInstance.getContextStr() + "/" + this.outputName + " audio source not running]", "application", "comment");
                        return;
                    }
                    if (iMediaStream == this.audioSource) break block27;
                    if (this.audioSource != null) {
                        this.pendingAudioSwitch = true;
                    }
                    if (!this.pendingAudioSwitch || !this.useOriginalTimecodes) break block28;
                    long l = iMediaStream.getAudioTC();
                    if (this.audioSwitchTimecode != -1L) break block29;
                    if (this.lastProcessedAudioTC != -1L && l > this.lastProcessedAudioTC) {
                        this.audioSwitchTimecode = l;
                        if (this.debugLog) {
                            this.logger.info("OutputStream.processAudioSource(): [" + this.appInstance.getContextStr() + "/" + this.outputName + " setting switchTimecode " + this.audioSwitchTimecode + "]", "application", "comment");
                        }
                        break block29;
                    } else {
                        if (!this.debugLog) return;
                        this.logger.info("OutputStream.processAudioSource(): [" + this.appInstance.getContextStr() + "/" + this.outputName + " pending switch waiting for new stream to catch up " + l + ": " + this.lastProcessedAudioTC + "]", "application", "comment");
                        return;
                    }
                }
                this.pendingAudioSwitch = false;
            }
            if (!this.pendingAudioSwitch) {
                this.audioSource = iMediaStream;
                this.audioOffset = -1L;
                this.audioSeq = -1L;
                this.foundFirstAudio = false;
                this.isFirstAudio = true;
            }
        }
        if ((list = this.audioSource.getPlayPackets()) == null) return;
        if (list.isEmpty()) {
            return;
        }
        long l = ((AMFPacket)list.get(0)).getSeq();
        int n3 = n2 = this.audioSeq == -1L ? 0 : (int)(this.audioSeq - l + 1L);
        if (n2 < 0) {
            n2 = 0;
        }
        if (n2 >= list.size()) {
            return;
        }
        if (!this.foundFirstAudio) {
            for (n = list.size() - 1; n >= 0; --n) {
                aMFPacket = (AMFPacket)list.get(n);
                if (!aMFPacket.isAudio() || this.audioSwitchTimecode != -1L && aMFPacket.getAbsTimecode() != this.audioSwitchTimecode) continue;
                this.audioSwitchTimecode = -1L;
                this.foundFirstAudio = true;
                n2 = n;
                if (this.useOriginalTimecodes) {
                    if (this.delayOffset == -1L) {
                        this.delayOffset = System.currentTimeMillis() - aMFPacket.getAbsTimecode();
                    }
                } else {
                    this.audioOffset = System.currentTimeMillis() - aMFPacket.getAbsTimecode();
                    if (this.audioOffset + aMFPacket.getAbsTimecode() <= this.lastProcessedAudioTC) {
                        this.audioOffset = this.lastProcessedAudioTC + aMFPacket.getTimecode() - aMFPacket.getAbsTimecode();
                    }
                }
                if (!this.debugLog) break;
                this.logger.info("OutputStream.processAudioSource(): [" + this.appInstance.getContextStr() + "/" + this.outputName + " found audio start. " + this.audioOffset + " : " + this.lastProcessedAudioTC + " : " + System.currentTimeMillis() + " : " + aMFPacket.getAbsTimecode() + "]", "application", "comment");
                break;
            }
            if (!this.foundFirstAudio) {
                return;
            }
        }
        n = n2;
        while (n < list.size()) {
            aMFPacket = (AMFPacket)list.get(n);
            int n4 = aMFPacket.getType();
            if (n4 != 9 && (n4 != 18 && n4 != 15 || this.addAudioData)) {
                AMFPacket aMFPacket2;
                long l2;
                if (this.audioSwitchTimecode != -1L && aMFPacket.getAbsTimecode() >= this.audioSwitchTimecode) {
                    if (this.debugLog) {
                        this.logger.info("OutputStream.processAudioSource(): [" + this.appInstance.getContextStr() + "/" + this.outputName + " (packet.getAbsTimecode() >= switchTimecode) " + aMFPacket + "]", "application", "comment");
                    }
                    this.audioSource = null;
                    this.pendingAudioSwitch = false;
                    return;
                }
                long l3 = l2 = this.useOriginalTimecodes ? aMFPacket.getAbsTimecode() : this.audioOffset + aMFPacket.getAbsTimecode();
                if (this.isFirstAudio && n4 == 8) {
                    IMediaStreamMetaDataProvider iMediaStreamMetaDataProvider;
                    aMFPacket2 = this.audioSource.getAudioCodecConfigPacket(aMFPacket.getAbsTimecode());
                    if (aMFPacket2 != null) {
                        iMediaStreamMetaDataProvider = new AMFPacket(8, 0, aMFPacket2.getData());
                        iMediaStreamMetaDataProvider.setAbsTimecode(l2);
                        this.packets.add((AMFPacket)iMediaStreamMetaDataProvider);
                        if (this.debugLog) {
                            this.logger.info("OutputStream.processAudioSource(): [" + this.appInstance.getContextStr() + "/" + this.outputName + " add audio config packet. " + aMFPacket2 + " : " + (AMFPacket)iMediaStreamMetaDataProvider + "]", "application", "comment");
                        }
                    }
                    if (this.addAudioData && (iMediaStreamMetaDataProvider = this.audioSource.getMetaDataProvider()) != null) {
                        ArrayList arrayList = new ArrayList();
                        iMediaStreamMetaDataProvider.onStreamStart(arrayList, aMFPacket.getAbsTimecode());
                        for (AMFPacket aMFPacket3 : arrayList) {
                            if (aMFPacket3 == null || aMFPacket3.getSize() <= 0 || aMFPacket3.getData() == null) continue;
                            AMFPacket aMFPacket4 = new AMFPacket(18, 0, aMFPacket3.getData());
                            aMFPacket4.setAbsTimecode(l2);
                            this.packets.add(aMFPacket4);
                            if (!this.debugLog) continue;
                            this.logger.info("OutputStream.processAudioSource(): [" + this.appInstance.getContextStr() + "/" + this.outputName + " add audio metadata packet. " + aMFPacket3 + " : " + aMFPacket4 + "]", "application", "comment");
                        }
                    }
                    this.isFirstAudio = false;
                }
                aMFPacket2 = new AMFPacket(n4, 0, aMFPacket.getData());
                aMFPacket2.setAbsTimecode(l2);
                this.packets.add(aMFPacket2);
                if (this.debugLog) {
                    this.logger.info("OutputStream.processAudioSource(): [" + this.appInstance.getContextStr() + "/" + this.outputName + " add audio packet. " + aMFPacket + " : " + aMFPacket2 + "]", "application", "comment");
                }
                this.audioSeq = aMFPacket.getSeq();
                this.lastProcessedAudioTC = l2;
            }
            ++n;
        }
    }

    private void processOutput() {
        if (this.debugLog) {
            this.logger.info("OutputStream.processOutput(): [" + this.appInstance.getContextStr() + "/" + this.outputName + "]", "application", "comment");
        }
        long l = System.currentTimeMillis();
        while (true) {
            AMFPacket aMFPacket;
            if ((aMFPacket = this.packets.peek()) == null) {
                if (!this.debugLog) break;
                this.logger.info("OutputStream.processOutput(): [" + this.appInstance.getContextStr() + "/" + this.outputName + " no packets available]", "application", "comment");
                break;
            }
            if (this.useOriginalTimecodes) {
                if (this.sortDelay >= 0L && aMFPacket.getAbsTimecode() + this.delayOffset > l - this.sortDelay) {
                    if (!this.debugLog) break;
                    this.logger.info("OutputStream.processOutput(): [" + this.appInstance.getContextStr() + "/" + this.outputName + " no packets available. (packet.getAbsTimecode() + delayOffset > now - sortDelay) timecode: " + aMFPacket.getAbsTimecode() + ", delayOffset: " + this.delayOffset + ", now: " + l + ", sortDelay: " + this.sortDelay + "]", "application", "comment");
                    break;
                }
            } else if (this.sortDelay >= 0L && aMFPacket.getAbsTimecode() > l - this.sortDelay) {
                if (!this.debugLog) break;
                this.logger.info("OutputStream.processOutput(): [" + this.appInstance.getContextStr() + "/" + this.outputName + " no packets available. (packet.getAbsTimecode() > now - sortDelay) timecode: " + aMFPacket.getAbsTimecode() + ", now: " + l + ", sortDelay: " + this.sortDelay + "]", "application", "comment");
                break;
            }
            long l2 = aMFPacket.getAbsTimecode();
            byte[] byArray = aMFPacket.getData();
            if (this.publisher == null && !this.initPublisher()) {
                return;
            }
            switch (aMFPacket.getType()) {
                case 8: {
                    this.publisher.addAudioData(byArray, l2);
                    if (!this.debugLog) break;
                    this.logger.info("OutputStream.processOutput(): [" + this.appInstance.getContextStr() + "/" + this.outputName + " add output audio packet. " + aMFPacket + "]", "application", "comment");
                    break;
                }
                case 9: {
                    this.publisher.addVideoData(byArray, l2);
                    if (!this.debugLog) break;
                    this.logger.info("OutputStream.processOutput(): [" + this.appInstance.getContextStr() + "/" + this.outputName + " add output video packet. " + aMFPacket + "]", "application", "comment");
                    break;
                }
                case 15: 
                case 18: {
                    this.publisher.addDataData(byArray, l2);
                    if (!this.debugLog) break;
                    this.logger.info("OutputStream.processOutput(): [" + this.appInstance.getContextStr() + "/" + this.outputName + " add output data packet. " + aMFPacket + "]", "application", "comment");
                }
            }
            this.lastTC = aMFPacket.getAbsTimecode();
            this.packets.remove();
        }
    }

    private boolean initPublisher() {
        IMediaStream iMediaStream = this.appInstance.getStreams().getStream(this.outputName);
        if (iMediaStream != null) {
            this.logger.error("OutputStream.init(): Cannot create Publisher. Stream already exists [" + this.appInstance.getContextStr() + "/" + this.outputName + "]", "application", "comment");
            return false;
        }
        this.publisher = Publisher.createInstance((IApplicationInstance)this.appInstance);
        if (this.publisher != null) {
            this.publisher.setStreamType(this.appInstance.getStreamType());
            this.publisher.publish(this.outputName);
            iMediaStream = this.publisher.getStream();
            iMediaStream.setMergeOnMetadata(this.appInstance.getProperties().getPropertyBoolean("avMixMergeMetadata", true));
            this.flushInterval = iMediaStream.getProperties().getPropertyLong("flushInterval", this.appInstance.getProperties().getPropertyLong("avMixflushInterval", this.flushInterval));
            this.logger.info("OutputStream.init(): Publisher created [" + this.appInstance.getContextStr() + "/" + this.outputName + "]", "application", "comment");
            return true;
        }
        this.logger.error("OutputStream.init(): Cannot create Publisher [" + this.appInstance.getContextStr() + "/" + this.outputName + "]", "application", "comment");
        return false;
    }

    public String getAudioName() {
        return this.audioName;
    }

    public void setAudioName(String string) {
        this.audioName = string;
    }

    public String getVideoName() {
        return this.videoName;
    }

    public void setVideoName(String string) {
        this.videoName = string;
    }

    public String getOutputName() {
        return this.outputName;
    }

    public Publisher getPublisher() {
        return this.publisher;
    }

    public long getSortDelay() {
        return this.sortDelay;
    }

    public void setSortDelay(long l) {
        this.sortDelay = l;
    }

    public long getSleepTime() {
        return this.flushInterval;
    }

    public void setSleepTime(long l) {
        this.flushInterval = l;
    }

    public boolean isAddAudioData() {
        return this.addAudioData;
    }

    public void setAddAudioData(boolean bl) {
        this.addAudioData = bl;
    }

    public boolean isAddVideoData() {
        return this.addVideoData;
    }

    public void setAddVideoData(boolean bl) {
        this.addVideoData = bl;
    }

    public boolean isWaitForKeyframe() {
        return this.waitForKeyframe;
    }

    public void setWaitForKeyframe(boolean bl) {
        this.waitForKeyframe = bl;
    }

    public boolean isUseOriginalTimecodes() {
        return this.useOriginalTimecodes;
    }

    public void setUseOriginalTimecodes(boolean bl) {
        this.useOriginalTimecodes = bl;
    }

    public boolean isDebugLog() {
        return this.debugLog;
    }

    public void setDebugLog(boolean bl) {
        this.debugLog = bl;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void close() {
        OutputStream outputStream = this;
        synchronized (outputStream) {
            this.doQuit = true;
            this.interrupt();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean isRunning() {
        OutputStream outputStream = this;
        synchronized (outputStream) {
            return this.running;
        }
    }

    class PacketComparator
    implements Comparator<AMFPacket> {
        PacketComparator() {
        }

        @Override
        public int compare(AMFPacket aMFPacket, AMFPacket aMFPacket2) {
            if (aMFPacket == aMFPacket2) {
                return 0;
            }
            return aMFPacket.getAbsTimecode() > aMFPacket2.getAbsTimecode() ? 1 : -1;
        }
    }
}

