/*
 * Decompiled with CFR 0.152.
 */
package com.wowza.wms.plugin.blacklist;

import com.wowza.wms.bootstrap.Bootstrap;
import com.wowza.wms.logging.WMSLogger;
import com.wowza.wms.logging.WMSLoggerFactory;
import com.wowza.wms.plugin.blacklist.ServerListenerBlacklistStreams;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileWriter;
import java.io.IOException;
import java.io.InputStreamReader;
import java.util.ArrayList;

public class BlackListUtils {
    private static ArrayList<String> streamBlackList = new ArrayList();
    private static String blacklistConfigPath = Bootstrap.getServerHome((int)2) + "/conf/blacklist.txt";
    static String separatorChar = ":";
    private static WMSLogger logger = WMSLoggerFactory.getLogger(BlackListUtils.class);

    public static void setConfigPath(String string) {
        blacklistConfigPath = string;
    }

    public static void setSeparatorChar(String string) {
        separatorChar = string;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void blackListStream(String string, String string2, String string3) {
        BlackListUtils.mergeData();
        ArrayList<String> arrayList = streamBlackList;
        synchronized (arrayList) {
            String string4 = string + separatorChar + string2 + separatorChar + string3;
            if (!streamBlackList.contains(string4)) {
                streamBlackList.add(string4);
                BlackListUtils.printContents();
                BlackListUtils.saveFile();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void removeStreamFromList(String string, String string2, String string3) {
        BlackListUtils.mergeData();
        String string4 = string + separatorChar + string2 + separatorChar + string3;
        if (ServerListenerBlacklistStreams.debug) {
            logger.info("ServerListenerBlacklistStreams.removeStreamFromList[" + string4 + "] Stream is initiated ");
        }
        ArrayList<String> arrayList = streamBlackList;
        synchronized (arrayList) {
            if (streamBlackList.contains(string4)) {
                if (streamBlackList.remove(string4)) {
                    BlackListUtils.saveFile();
                    BlackListUtils.printContents();
                    logger.info("ServerListenerBlacklistStreams.removeStreamFromList[" + string4 + "] Completed ");
                } else {
                    logger.info("ServerListenerBlacklistStreams.removeStreamFromList[" + string4 + "] Does not exist-2 ");
                }
            } else {
                logger.info("ServerListenerBlacklistStreams.removeStreamFromList[" + string4 + "] Does not exist ");
            }
        }
    }

    public static boolean isStreamBlackListed(String string, String string2, String string3) {
        BlackListUtils.mergeData();
        String string4 = string + separatorChar + string2 + separatorChar + string3;
        return streamBlackList.contains(string4);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static ArrayList<String> getBlackListedStreams() {
        BlackListUtils.mergeData();
        ArrayList<String> arrayList = streamBlackList;
        synchronized (arrayList) {
            return streamBlackList;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void mergeData() {
        ArrayList<String> arrayList = streamBlackList;
        synchronized (arrayList) {
            ArrayList<String> arrayList2 = BlackListUtils.getStoredBlacklistItems();
            if (arrayList2.size() > 0) {
                for (int i = 0; i < arrayList2.size(); ++i) {
                    if (streamBlackList.contains(arrayList2.get(i))) continue;
                    streamBlackList.add(arrayList2.get(i));
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static ArrayList<String> getStoredBlacklistItems() {
        ArrayList<String> arrayList = new ArrayList<String>();
        File file = new File(blacklistConfigPath);
        if (file.exists()) {
            FileInputStream fileInputStream = null;
            BufferedReader bufferedReader = null;
            try {
                String string;
                fileInputStream = new FileInputStream(blacklistConfigPath);
                bufferedReader = new BufferedReader(new InputStreamReader(fileInputStream));
                while ((string = bufferedReader.readLine()) != null) {
                    if ((string = string.trim()).startsWith("#") || string.length() <= 0) continue;
                    arrayList.add(string);
                }
            }
            catch (Exception exception) {
                logger.error("ServerListenerBlacklistStreams.getStoredBlacklistItems() ", (Throwable)exception);
            }
            finally {
                try {
                    if (bufferedReader != null) {
                        bufferedReader.close();
                    }
                }
                catch (IOException iOException) {}
                bufferedReader = null;
                try {
                    if (fileInputStream != null) {
                        fileInputStream.close();
                    }
                }
                catch (IOException iOException) {}
                fileInputStream = null;
            }
        } else {
            logger.info("ServerListenerBlacklistStreams.getStoredBlacklistItems could not find black list items list");
        }
        return arrayList;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void saveFile() {
        ArrayList<String> arrayList = streamBlackList;
        synchronized (arrayList) {
            ArrayList<String> arrayList2 = streamBlackList;
            try {
                File file = new File(blacklistConfigPath);
                if (!file.exists()) {
                    file.createNewFile();
                }
                FileWriter fileWriter = new FileWriter(blacklistConfigPath, false);
                StringBuilder stringBuilder = new StringBuilder();
                for (int i = 0; i < arrayList2.size(); ++i) {
                    logger.info("ServerListenerBlacklistStreams.saveFile Line: " + arrayList2.get(i));
                    stringBuilder.append(arrayList2.get(i) + "\n");
                }
                fileWriter.write(stringBuilder.toString());
                fileWriter.close();
            }
            catch (IOException iOException) {
                logger.error("ServerListenerBlacklistStreams.saveFile IOException: " + iOException.getMessage(), (Throwable)iOException);
            }
        }
    }

    private static void printContents() {
        ArrayList<String> arrayList = BlackListUtils.getBlackListedStreams();
        for (int i = 0; i < arrayList.size(); ++i) {
            logger.info("ServerListenerBlacklistStreams.printContents bli.get(i): " + arrayList.get(i));
        }
    }
}

