/*
 * Decompiled with CFR 0.152.
 */
package com.wowza.wms.plugin.blacklist;

import com.wowza.wms.application.IApplication;
import com.wowza.wms.application.IApplicationInstance;
import com.wowza.wms.client.IClient;
import com.wowza.wms.http.HTTProvider2Base;
import com.wowza.wms.http.IHTTPRequest;
import com.wowza.wms.http.IHTTPResponse;
import com.wowza.wms.httpstreamer.model.IHTTPStreamerSession;
import com.wowza.wms.logging.WMSLogger;
import com.wowza.wms.logging.WMSLoggerFactory;
import com.wowza.wms.mediacaster.MediaCasterItem;
import com.wowza.wms.mediacaster.MediaCasterStreamId;
import com.wowza.wms.mediacaster.wowza.LiveMediaStreamURL;
import com.wowza.wms.plugin.blacklist.BlackListUtils;
import com.wowza.wms.rtp.model.RTPSession;
import com.wowza.wms.stream.IMediaStream;
import com.wowza.wms.vhost.IVHost;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;

public class HTTPProviderBlacklistStreams
extends HTTProvider2Base {
    public static final String MODULE_NAME = "HTTPProviderBlacklistStreams";
    private WMSLogger logger = WMSLoggerFactory.getLogger(((Object)((Object)this)).getClass());

    public void onHTTPRequest(IVHost iVHost, IHTTPRequest iHTTPRequest, IHTTPResponse iHTTPResponse) {
        if (!this.doHTTPAuthentication(iVHost, iHTTPRequest, iHTTPResponse)) {
            return;
        }
        String string = this.handlePost(iHTTPRequest, iVHost);
        String string2 = "";
        string2 = string2 + this.getBlackListedStreams();
        string2 = string2 + this.getPublishedStreams(iVHost);
        string2 = string2 + this.getRefresh();
        String string3 = "";
        if (string != null) {
            string3 = this.getMsgHeader(string, iHTTPRequest);
        }
        String string4 = this.getHtmlPage(string2, string3);
        try {
            OutputStream outputStream = iHTTPResponse.getOutputStream();
            byte[] byArray = string4.getBytes();
            outputStream.write(byArray);
        }
        catch (Exception exception) {
            this.logger.error("HTTPProviderBlacklistStreams.onHTTPRequest()", (Throwable)exception);
        }
    }

    private String getRefresh() {
        String string = "<br /><br /><input type='button' name='refresh' value='Check for New Streams' onclick=\"location.reload(true);\" />";
        return string;
    }

    private String getBlackListedStreams() {
        String string = "";
        ArrayList<String> arrayList = BlackListUtils.getBlackListedStreams();
        if (arrayList.size() > 0) {
            string = string + this.divHeader("Blacklisted") + this.divSectionStart();
            string = string + "<table>";
            for (int i = 0; i < arrayList.size(); ++i) {
                String[] stringArray = arrayList.get(i).split(BlackListUtils.separatorChar);
                if (stringArray.length != 3) continue;
                String string2 = stringArray[0];
                String string3 = stringArray[1];
                String string4 = stringArray[2];
                string = string + this.addRow(string2, string3, string4);
            }
            string = string + "</table>";
            string = string + this.divSectionEnd();
        }
        return string;
    }

    private String getPublishedStreams(IVHost iVHost) {
        String string = "";
        if (iVHost != null) {
            string = string + this.divHeader("Published Streams");
            string = string + this.divSectionStart();
            string = string + this.startSection(iVHost.getName());
            List list = iVHost.getApplicationNames();
            if (list.size() > 0) {
                for (String string2 : list) {
                    IApplication iApplication = iVHost.getApplication(string2);
                    List list2 = iApplication.getAppInstanceNames();
                    if (list2.size() <= 0) continue;
                    for (String string3 : list2) {
                        IApplicationInstance iApplicationInstance = iApplication.getAppInstance(string3);
                        HashSet<String> hashSet = new HashSet<String>();
                        List list3 = iApplicationInstance.getPublishStreamNames();
                        if (list3.size() > 0) {
                            for (String string4 : list3) {
                                String string5;
                                MediaCasterStreamId mediaCasterStreamId = MediaCasterItem.parseIdString((String)string4);
                                if ((string4 = mediaCasterStreamId.getName()).indexOf("://") >= 0 && (string5 = LiveMediaStreamURL.decodeURLToStreamName((String)string4)) != null) {
                                    string4 = string5;
                                }
                                hashSet.add(string4);
                            }
                        }
                        for (String string4 : hashSet) {
                            if (BlackListUtils.isStreamBlackListed(string2, string3, string4)) continue;
                            string = string + this.addRow(string2, string3, string4);
                        }
                    }
                }
            } else {
                string = string + this.addEmptyRow("No streams published..");
            }
            string = string + this.endSection();
            string = string + this.divSectionEnd();
        }
        return string;
    }

    private boolean blacklistStream(IVHost iVHost, String string, String string2, String string3) {
        try {
            List list;
            List list2;
            List list3;
            IApplicationInstance iApplicationInstance = iVHost.getApplication(string).getAppInstance(string2);
            if (iApplicationInstance != null) {
                Object object;
                Object object2;
                list3 = iApplicationInstance.getClients();
                list2 = iApplicationInstance.getHTTPStreamerSessions();
                list = iApplicationInstance.getRTPSessions();
                Iterator iterator = list2.iterator();
                while (iterator.hasNext()) {
                    try {
                        IHTTPStreamerSession iHTTPStreamerSession = (IHTTPStreamerSession)iterator.next();
                        if (iHTTPStreamerSession == null || !string3.equals(iHTTPStreamerSession.getStreamName())) continue;
                        iHTTPStreamerSession.rejectSession();
                    }
                    catch (Exception exception) {
                        this.logger.error("HTTPProviderBlacklistStreams.blacklistStream()", (Throwable)exception);
                    }
                }
                Iterator iterator2 = list3.iterator();
                while (iterator2.hasNext()) {
                    try {
                        IClient iClient = (IClient)iterator2.next();
                        if (iClient == null || (object2 = iClient.getPlayStreams()).size() <= 0) continue;
                        object = object2.iterator();
                        while (object.hasNext()) {
                            String string4;
                            IMediaStream iMediaStream = (IMediaStream)object.next();
                            String string5 = iMediaStream.getName();
                            if (string5.indexOf("://") >= 0 && (string4 = LiveMediaStreamURL.decodeURLToStreamName((String)string5)) != null) {
                                string5 = string4;
                            }
                            if (!string3.equals(string5)) continue;
                            iClient.setShutdownClient(true);
                        }
                    }
                    catch (Exception exception) {
                        this.logger.error("HTTPProviderBlacklistStreams.blacklistStream()", (Throwable)exception);
                    }
                }
                object2 = list.iterator();
                while (object2.hasNext()) {
                    try {
                        object = (RTPSession)object2.next();
                        if (object == null || !string3.equals(object.getRTSPStream().getStreamName())) continue;
                        iApplicationInstance.getVHost().getRTPContext().shutdownRTPSession((RTPSession)object);
                    }
                    catch (Exception exception) {
                        this.logger.error("HTTPProviderBlacklistStreams.blacklistStream()", (Throwable)exception);
                    }
                }
            }
            if ((list3 = iApplicationInstance.getStreams().getStream(string3)) != null) {
                list2 = list3.getClient();
                if (list2 != null) {
                    list2.setShutdownClient(true);
                } else {
                    list = list3.getRTPStream();
                    if (list != null) {
                        iApplicationInstance.getVHost().getRTPContext().shutdownRTPSession(list.getSession());
                    }
                }
            }
            return true;
        }
        catch (Exception exception) {
            this.logger.error("HTTPProviderBlacklistStreams.blacklistStream()", (Throwable)exception);
            return false;
        }
    }

    private String handlePost(IHTTPRequest iHTTPRequest, IVHost iVHost) {
        if (iHTTPRequest.getMethod().equalsIgnoreCase("post")) {
            iHTTPRequest.parseBodyForParams(true);
        }
        Map map = iHTTPRequest.getParameterMap();
        System.out.println(map.toString());
        if (map.containsKey("blacklist")) {
            String string = (String)((List)map.get("application")).get(0) + "/" + (String)((List)map.get("appInstance")).get(0) + "/" + (String)((List)map.get("stream")).get(0);
            if (((String)((List)map.get("blacklist")).get(0)).equalsIgnoreCase("1")) {
                BlackListUtils.blackListStream((String)((List)map.get("application")).get(0), (String)((List)map.get("appInstance")).get(0), (String)((List)map.get("stream")).get(0));
                if (this.blacklistStream(iVHost, (String)((List)map.get("application")).get(0), (String)((List)map.get("appInstance")).get(0), (String)((List)map.get("stream")).get(0))) {
                    return string + " has been added to the blacklist";
                }
                return string + " failed to add to blacklist.";
            }
            BlackListUtils.removeStreamFromList((String)((List)map.get("application")).get(0), (String)((List)map.get("appInstance")).get(0), (String)((List)map.get("stream")).get(0));
            return string + " has been removed from the blacklist";
        }
        return null;
    }

    private String divSectionStart() {
        return "<div style='padding: 10px 10px 10px 10px; width: 500px; border: 1px solid #ccc; background-color: #eee; border-radius: 8px;'>";
    }

    private String divSectionEnd() {
        return "</div>";
    }

    private String divHeader(String string) {
        return "<div style='clear:both; width: 500px;font-weight:bold; border-radius: 8px; background-color: #66CCFF; border: 1px solid #ccc;padding: 10px 10px 10px 10px; margin-top:10px;  margin-bottom: 5px'>" + string + "</div>";
    }

    private String getMsgHeader(String string, IHTTPRequest iHTTPRequest) {
        if (!string.isEmpty()) {
            String string2 = iHTTPRequest.getRequestURL();
            String[] stringArray = string2.split("\\/");
            String string3 = stringArray[stringArray.length - 1];
            string = string + " <a href='/" + string3 + "'>clear</a>";
        }
        return "<div style='clear:both; background-color: #FFFFCC; border: 1px solid #ccc;padding: 10px 10px 10px 10px'>" + string + "</div>";
    }

    private String getHtmlPage(String string, String string2) {
        return "<html>\n<head>\n<title>Blacklist Streams</title>\n<script type='text/javascript'>\nfunction formSubmit(blacklist, application, appInstance, stream)\n{\n document.forms[0].blacklist.value = blacklist;\n\t\t\t\t  document.forms[0].application.value = application;\n\t\t\t\t  document.forms[0].appInstance.value = appInstance;\n\t\t\t\t  document.forms[0].stream.value = stream;\n\t\t\t\t  document.forms[0].submit();\n\t\t\t\t}\n\t\t\t\t</script>\n\t\t\t</head>\n\t\t\t<body style='font-family: verdana;'>\n<h2 style='margin-left: 50px;'>Stream Blacklists</h2>\t\t\t\t<div style='margin-left: 50px'>\t\t\t\t" + string2 + "\t\t\t\t" + string + " \t\t\t\t<form name='blacklistform' method='post'> \t\t\t\t\t<input type='hidden' name='blacklist' value='' /> \n\t\t\t\t\t<input type='hidden' name='application' value='' /> \t\t\t\t\t<input type='hidden' name='appInstance' value='' /> \t\t\t\t\t<input type='hidden' name='stream' value='' /> \t\t\t\t</form> \t\t\t\t</div>\t\t\t</body></html>";
    }

    private String startSection(String string) {
        return "<div style='font-size: 16px;font-weight:bold; padding: 10px 10px 10px 10px;border: 1px solid #585858; background-color: #ccc;width: 150px; text-align: center;'>" + string + "</div><table style='margin-top: 10px;'><tr style='padding: 10px 10px 10px 10px; background-color: #ccc;'>\t<td style='padding: 10px 10px 10px 10px;'>Application</td>\t<td style='padding: 10px 10px 10px 10px;'>AppInstance</td>\t<td style='padding: 10px 10px 10px 10px;'>Stream</td>\t<td style='padding: 10px 10px 10px 10px;'>Action</td></tr>";
    }

    private String endSection() {
        return "</table>";
    }

    private String addEmptyRow(String string) {
        return "<tr><td colspan='4'><i>" + string + "</i></td></tr>";
    }

    private String addRow(String string, String string2, String string3) {
        String string4 = "1";
        String string5 = "Blacklist";
        if (BlackListUtils.isStreamBlackListed(string, string2, string3)) {
            string5 = "Whitelist";
            string4 = "0";
        }
        return "<tr  onmouseover=\"this.bgColor='#FFFFCC'\" onmouseout=\"this.bgColor='#EEE'\" >\t<td style='width: 120px;padding: 10px 10px 10px 10px;'>" + string + "</td>\t<td style='width: 120px;padding: 10px 10px 10px 10px;'>" + string2 + "</td>\t<td style='width: 120px;padding: 10px 10px 10px 10px;'>" + string3 + "</td>\t<td><a style='padding: 10px 10px 10px 10px; cursor:pointer; color: blue;' onclick=\"formSubmit('" + string4 + "','" + string + "','" + string2 + "','" + string3 + "');\">" + string5 + "</a> </td></tr>";
    }
}

