/*
 * Decompiled with CFR 0.152.
 */
package com.wowza.wms.plugin.blacklist;

import com.wowza.util.StringUtils;
import com.wowza.wms.amf.AMFDataList;
import com.wowza.wms.amf.AMFPacket;
import com.wowza.wms.application.IApplication;
import com.wowza.wms.application.IApplicationInstance;
import com.wowza.wms.application.IApplicationInstanceNotify;
import com.wowza.wms.application.IApplicationNotify;
import com.wowza.wms.client.IClient;
import com.wowza.wms.httpstreamer.model.IHTTPStreamerSession;
import com.wowza.wms.logging.WMSLogger;
import com.wowza.wms.logging.WMSLoggerFactory;
import com.wowza.wms.mediacaster.IMediaCaster;
import com.wowza.wms.module.ModuleBase;
import com.wowza.wms.plugin.blacklist.BlackListUtils;
import com.wowza.wms.request.RequestFunction;
import com.wowza.wms.rtp.model.RTPSession;
import com.wowza.wms.server.IServer;
import com.wowza.wms.server.IServerNotify2;
import com.wowza.wms.stream.IMediaStream;
import com.wowza.wms.stream.IMediaStreamActionNotify;
import com.wowza.wms.stream.IMediaStreamActionNotify2;
import com.wowza.wms.stream.IMediaStreamNameAliasProvider;
import com.wowza.wms.stream.IMediaStreamNameAliasProvider2;
import com.wowza.wms.stream.IMediaStreamNotify;
import com.wowza.wms.stream.livepacketizer.ILiveStreamPacketizer;
import com.wowza.wms.vhost.IVHost;
import com.wowza.wms.vhost.IVHostNotify;
import com.wowza.wms.vhost.VHostSingleton;

public class ServerListenerBlacklistStreams
extends ModuleBase
implements IServerNotify2 {
    public static final String MODULE_NAME = "ServerListenerBlacklistStreams";
    private static final String PROP_NAME_PREFIX = "blacklistStreams";
    public static boolean debug = false;
    private WMSLogger logger = WMSLoggerFactory.getLogger(((Object)((Object)this)).getClass());
    private String configPath = null;

    public void onServerConfigLoaded(IServer iServer) {
        VHostSingleton.addVHostListener((IVHostNotify)new VHostNotifier());
    }

    public void onServerCreate(IServer iServer) {
        String string;
        debug = iServer.getProperties().getPropertyBoolean("blacklistStreamsDebugLog", debug);
        if (this.logger.isDebugEnabled()) {
            debug = true;
        }
        this.configPath = iServer.getProperties().getPropertyStr("blacklistStreamsConfigPath", this.configPath);
        if (!StringUtils.isEmpty((String)this.configPath)) {
            BlackListUtils.setConfigPath(this.configPath);
        }
        if (!StringUtils.isEmpty((String)(string = iServer.getProperties().getPropertyStr("blacklistStreamsSeparatorChar")))) {
            BlackListUtils.setSeparatorChar(string);
        }
    }

    public void onServerInit(IServer iServer) {
    }

    public void onServerShutdownComplete(IServer iServer) {
    }

    public void onServerShutdownStart(IServer iServer) {
    }

    class StreamAliasProvider
    implements IMediaStreamNameAliasProvider2 {
        private final IMediaStreamNameAliasProvider currentAliasProvider;

        public StreamAliasProvider(IMediaStreamNameAliasProvider iMediaStreamNameAliasProvider) {
            this.currentAliasProvider = iMediaStreamNameAliasProvider;
        }

        public String resolvePlayAlias(IApplicationInstance iApplicationInstance, String string) {
            if (BlackListUtils.isStreamBlackListed(iApplicationInstance.getApplication().getName(), iApplicationInstance.getName(), string)) {
                return null;
            }
            return string;
        }

        public String resolvePlayAlias(IApplicationInstance iApplicationInstance, String string, IClient iClient) {
            if (this.currentAliasProvider != null) {
                if (this.currentAliasProvider instanceof IMediaStreamNameAliasProvider2) {
                    string = ((IMediaStreamNameAliasProvider2)this.currentAliasProvider).resolvePlayAlias(iApplicationInstance, string, iClient);
                }
                string = this.currentAliasProvider.resolveStreamAlias(iApplicationInstance, string);
            }
            if (string == null) {
                return null;
            }
            if (BlackListUtils.isStreamBlackListed(iApplicationInstance.getApplication().getName(), iApplicationInstance.getName(), string)) {
                return null;
            }
            return string;
        }

        public String resolvePlayAlias(IApplicationInstance iApplicationInstance, String string, IHTTPStreamerSession iHTTPStreamerSession) {
            if (this.currentAliasProvider != null) {
                if (this.currentAliasProvider instanceof IMediaStreamNameAliasProvider2) {
                    string = ((IMediaStreamNameAliasProvider2)this.currentAliasProvider).resolvePlayAlias(iApplicationInstance, string, iHTTPStreamerSession);
                }
                string = this.currentAliasProvider.resolveStreamAlias(iApplicationInstance, string);
            }
            if (string == null) {
                return null;
            }
            if (BlackListUtils.isStreamBlackListed(iApplicationInstance.getApplication().getName(), iApplicationInstance.getName(), string)) {
                return null;
            }
            return string;
        }

        public String resolvePlayAlias(IApplicationInstance iApplicationInstance, String string, RTPSession rTPSession) {
            if (this.currentAliasProvider != null) {
                if (this.currentAliasProvider instanceof IMediaStreamNameAliasProvider2) {
                    string = ((IMediaStreamNameAliasProvider2)this.currentAliasProvider).resolvePlayAlias(iApplicationInstance, string, rTPSession);
                }
                string = this.currentAliasProvider.resolveStreamAlias(iApplicationInstance, string);
            }
            if (string == null) {
                return null;
            }
            if (BlackListUtils.isStreamBlackListed(iApplicationInstance.getApplication().getName(), iApplicationInstance.getName(), string)) {
                return null;
            }
            return string;
        }

        public String resolvePlayAlias(IApplicationInstance iApplicationInstance, String string, ILiveStreamPacketizer iLiveStreamPacketizer) {
            if (this.currentAliasProvider != null) {
                if (this.currentAliasProvider instanceof IMediaStreamNameAliasProvider2) {
                    string = ((IMediaStreamNameAliasProvider2)this.currentAliasProvider).resolvePlayAlias(iApplicationInstance, string, iLiveStreamPacketizer);
                }
                string = this.currentAliasProvider.resolveStreamAlias(iApplicationInstance, string);
            }
            if (string == null) {
                return null;
            }
            if (BlackListUtils.isStreamBlackListed(iApplicationInstance.getApplication().getName(), iApplicationInstance.getName(), string)) {
                return null;
            }
            return string;
        }

        public String resolveStreamAlias(IApplicationInstance iApplicationInstance, String string) {
            if (this.currentAliasProvider != null) {
                return this.currentAliasProvider.resolveStreamAlias(iApplicationInstance, string);
            }
            return string;
        }

        public String resolveStreamAlias(IApplicationInstance iApplicationInstance, String string, IMediaCaster iMediaCaster) {
            if (this.currentAliasProvider != null) {
                if (this.currentAliasProvider instanceof IMediaStreamNameAliasProvider2) {
                    return ((IMediaStreamNameAliasProvider2)this.currentAliasProvider).resolveStreamAlias(iApplicationInstance, string, iMediaCaster);
                }
                return this.currentAliasProvider.resolveStreamAlias(iApplicationInstance, string);
            }
            return string;
        }
    }

    class StreamManager
    implements IMediaStreamActionNotify2 {
        StreamManager() {
        }

        public void onPublish(IMediaStream iMediaStream, String string, boolean bl, boolean bl2) {
            RTPSession rTPSession;
            String string2;
            String string3;
            IApplicationInstance iApplicationInstance = iMediaStream.getStreams().getAppInstance();
            if (iApplicationInstance.getMediaCasterStreams().getMediaCaster(string) != null) {
                return;
            }
            if (iMediaStream.isTranscodeResult()) {
                return;
            }
            if (iMediaStream.isPublisherStream()) {
                return;
            }
            if (debug) {
                ServerListenerBlacklistStreams.this.logger.info("ServerListenerBlacklistStreams.onApplicationInstanceCreate[" + string + "] Checking stream for blacklist");
            }
            if (!BlackListUtils.isStreamBlackListed(string3 = iApplicationInstance.getApplication().getName(), string2 = iApplicationInstance.getName(), string)) {
                return;
            }
            if (iMediaStream.getClient() != null) {
                ServerListenerBlacklistStreams.sendStreamOnStatusError((IMediaStream)iMediaStream, (String)"NetStream.Publish.BadName", (String)"The publisher's Stream was not white listed");
                iMediaStream.getClient().setShutdownClient(true);
                ServerListenerBlacklistStreams.this.logger.info("ServerListenerBlacklistStreams.onPublish[" + string + "] Client Rejected (NetStream.Publish.BadName), black listed " + string3 + "/" + string2 + "/" + string);
            } else if (iMediaStream.getRTPStream() != null && (rTPSession = iMediaStream.getRTPStream().getSession()) != null) {
                iApplicationInstance.getVHost().getRTPContext().shutdownRTPSession(rTPSession);
                ServerListenerBlacklistStreams.this.logger.info("ServerListenerBlacklistStreams.onPublish[" + string + "] RTP Rejected, black listed. Stream: " + string3 + "/" + string2 + "/" + string);
            }
        }

        public void onPlay(IMediaStream iMediaStream, String string, double d, double d2, int n) {
        }

        public void onUnPublish(IMediaStream iMediaStream, String string, boolean bl, boolean bl2) {
        }

        public void onPause(IMediaStream iMediaStream, boolean bl, double d) {
        }

        public void onSeek(IMediaStream iMediaStream, double d) {
        }

        public void onStop(IMediaStream iMediaStream) {
        }

        public void onMetaData(IMediaStream iMediaStream, AMFPacket aMFPacket) {
        }

        public void onPauseRaw(IMediaStream iMediaStream, boolean bl, double d) {
        }
    }

    class StreamListener
    implements IMediaStreamNotify {
        private final IMediaStreamActionNotify actionNotify;

        StreamListener() {
            this.actionNotify = new StreamManager();
        }

        public void onMediaStreamCreate(IMediaStream iMediaStream) {
            if (debug) {
                ServerListenerBlacklistStreams.this.logger.info("ServerListenerBlacklistStreams.onApplicationInstanceCreate[" + iMediaStream.getName() + "] Stream is initiated ");
            }
            iMediaStream.addClientListener(this.actionNotify);
        }

        public void onMediaStreamDestroy(IMediaStream iMediaStream) {
            if (this.actionNotify != null) {
                iMediaStream.removeClientListener(this.actionNotify);
            }
        }
    }

    class ApplicationInstanceNotify
    implements IApplicationInstanceNotify {
        private final StreamListener listener;

        ApplicationInstanceNotify() {
            this.listener = new StreamListener();
        }

        public void onApplicationInstanceCreate(IApplicationInstance iApplicationInstance) {
            if (debug) {
                ServerListenerBlacklistStreams.this.logger.info("ServerListenerBlacklistStreams.onApplicationInstanceCreate[" + iApplicationInstance.getName() + "] Stream Listener is initiated");
            }
            IMediaStreamNameAliasProvider iMediaStreamNameAliasProvider = iApplicationInstance.getStreamNameAliasProvider();
            iApplicationInstance.setStreamNameAliasProvider((IMediaStreamNameAliasProvider)new StreamAliasProvider(iMediaStreamNameAliasProvider));
            iApplicationInstance.addMediaStreamListener((IMediaStreamNotify)this.listener);
        }

        public void onApplicationInstanceDestroy(IApplicationInstance iApplicationInstance) {
            if (debug) {
                ServerListenerBlacklistStreams.this.logger.info("ServerListenerBlacklistStreams.onApplicationInstanceDestroy[" + iApplicationInstance.getName() + "] Stream listener is removed");
            }
            iApplicationInstance.removeMediaStreamListener((IMediaStreamNotify)this.listener);
        }
    }

    class ApplicationNotify
    implements IApplicationNotify {
        private final ApplicationInstanceNotify listener;

        ApplicationNotify() {
            this.listener = new ApplicationInstanceNotify();
        }

        public void onApplicationCreate(IApplication iApplication) {
            iApplication.addApplicationInstanceListener((IApplicationInstanceNotify)this.listener);
        }

        public void onApplicationDestroy(IApplication iApplication) {
            iApplication.removeApplicationInstanceListener((IApplicationInstanceNotify)this.listener);
        }
    }

    private class VHostNotifier
    implements IVHostNotify {
        private final ApplicationNotify listener;

        private VHostNotifier() {
            this.listener = new ApplicationNotify();
        }

        public void onVHostCreate(IVHost iVHost) {
            iVHost.addApplicationListener((IApplicationNotify)this.listener);
        }

        public void onVHostInit(IVHost iVHost) {
        }

        public void onVHostShutdownStart(IVHost iVHost) {
        }

        public void onVHostShutdownComplete(IVHost iVHost) {
            iVHost.removeApplicationListener((IApplicationNotify)this.listener);
        }

        public void onVHostClientConnect(IVHost iVHost, IClient iClient, RequestFunction requestFunction, AMFDataList aMFDataList) {
        }
    }
}

