/*
 * Decompiled with CFR 0.152.
 */
package com.wowza.wms.plugin;

import com.wowza.util.StringUtils;
import com.wowza.wms.application.IApplicationInstance;
import com.wowza.wms.httpstreamer.cupertinostreaming.httpstreamer.HTTPStreamerSessionCupertino;
import com.wowza.wms.logging.WMSLogger;
import com.wowza.wms.logging.WMSLoggerFactory;
import com.wowza.wms.module.ModuleBase;

public class CupertinoAutoMultibitrateFilter
extends ModuleBase {
    public static final String MODULE_NAME = "ModuleCupertinoAutoMultibitrateFilter";
    public static final String PROP_NAME_PREFIX = "cupertinoAutoMultibitrateFilter";
    private WMSLogger logger;
    private String[] userAgents = new String[]{"Macintosh;", "iPhone;", "iPad;", "iPod;", "AppleTV"};
    private boolean debugLog = false;

    public void onAppStart(IApplicationInstance iApplicationInstance) {
        this.logger = WMSLoggerFactory.getLoggerObj((IApplicationInstance)iApplicationInstance);
        String string = iApplicationInstance.getProperties().getPropertyStr("cupertinoAutoMultibitrateFilterUserAgents", "");
        if (!StringUtils.isEmpty((String)string)) {
            this.userAgents = string.split("\\|");
        }
        this.debugLog = iApplicationInstance.getProperties().getPropertyBoolean("cupertinoAutoMultibitrateFilterDebugLog", this.debugLog);
        if (this.logger.isDebugEnabled()) {
            this.debugLog = true;
        }
    }

    public void onHTTPCupertinoStreamingSessionCreate(HTTPStreamerSessionCupertino hTTPStreamerSessionCupertino) {
        String string = hTTPStreamerSessionCupertino.getUserAgent();
        if (string != null) {
            boolean bl = false;
            for (int i = 0; i < this.userAgents.length; ++i) {
                if (string.indexOf(this.userAgents[i].trim()) < 0) continue;
                bl = true;
                break;
            }
            if (this.debugLog) {
                this.logger.info("ModuleCupertinoAutoMultibitrateFilter.onHTTPCupertinoStreamingSessionCreate: setAutoCreateMultibitratePlaylist:" + bl + " userAgent:" + string);
            }
            hTTPStreamerSessionCupertino.setAutoCreateMultibitratePlaylist(bl);
        }
    }
}

