/*
 * Decompiled with CFR 0.152.
 */
package com.wowza.wms.plugin;

import com.wowza.util.StringUtils;
import com.wowza.util.SystemUtils;
import com.wowza.wms.amf.AMFPacket;
import com.wowza.wms.application.IApplicationInstance;
import com.wowza.wms.application.IApplicationInstanceNotify;
import com.wowza.wms.application.WMSProperties;
import com.wowza.wms.logging.WMSLogger;
import com.wowza.wms.logging.WMSLoggerFactory;
import com.wowza.wms.module.ModuleBase;
import com.wowza.wms.stream.IMediaStream;
import com.wowza.wms.stream.IMediaStreamActionNotify3;
import com.wowza.wms.stream.IMediaStreamLivePacketNotify;
import com.wowza.wms.stream.MediaStreamActionNotifyBase;
import com.wowza.wms.stream.publish.Publisher;
import com.wowza.wms.vhost.IVHost;
import com.wowza.wms.vhost.VHostSingleton;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Timer;
import java.util.TimerTask;

public class ModuleDuplicateStreams
extends ModuleBase {
    public static final String MODULE_NAME = "ModuleDuplicateStreams";
    public static final String PROP_NAME_PREFIX = "duplicateStreams";
    private static final int DELAYED_MAX_SIZE = 100;
    private String streamNames = "*";
    private String targetVHostName = "_defaultVHost_";
    private String targetAppName = "live/_definst_";
    private String streamNameSuffix = "_dest";
    private IApplicationInstance appInstance = null;
    private WMSLogger logger = null;
    private SourcePacketListener sourcePacketListener = new SourcePacketListener();
    private SourceStreamNotify sourceStreamNotify = new SourceStreamNotify();
    private TargetAppInstanceNotify targetAppInstanceNotify = new TargetAppInstanceNotify();
    private Map<IMediaStream, List<AMFPacket>> delayedPackets = new HashMap<IMediaStream, List<AMFPacket>>();
    private long restartTimeout = 10000L;
    private boolean doRestarts = true;
    private Object lock = new Object();

    public void onAppCreate(IApplicationInstance iApplicationInstance) {
        HashMap<String, String> hashMap = new HashMap<String, String>();
        hashMap.put("com.wowza.wms.context.VHost", iApplicationInstance.getVHost().getName());
        hashMap.put("com.wowza.wms.context.Application", iApplicationInstance.getApplication().getName());
        hashMap.put("com.wowza.wms.context.ApplicationInstance", iApplicationInstance.getName());
        this.appInstance = iApplicationInstance;
        this.logger = WMSLoggerFactory.getLoggerObj((IApplicationInstance)iApplicationInstance);
        WMSProperties wMSProperties = iApplicationInstance.getProperties();
        this.streamNames = SystemUtils.expandEnvironmentVariables((String)wMSProperties.getPropertyStr("duplicateStreamsStreamNames", this.streamNames), hashMap);
        this.targetVHostName = SystemUtils.expandEnvironmentVariables((String)wMSProperties.getPropertyStr("duplicateStreamsTargetVHostName", this.targetVHostName), hashMap);
        this.targetAppName = SystemUtils.expandEnvironmentVariables((String)wMSProperties.getPropertyStr("duplicateStreamsTargetAppName", this.targetAppName), hashMap);
        this.doRestarts = wMSProperties.getPropertyBoolean("duplicateStreamsDoRestarts", this.doRestarts);
        this.restartTimeout = wMSProperties.getPropertyLong("duplicateStreamsRestartTimeout", this.restartTimeout);
        this.streamNameSuffix = SystemUtils.expandEnvironmentVariables((String)wMSProperties.getPropertyStr("duplicateStreamsStreamNameSuffix", this.streamNameSuffix), hashMap);
        this.logger.info("ModuleDuplicateStreams.onAppCreate [" + iApplicationInstance.getContextStr() + ", Build #11, streamNames: " + this.streamNames + ", targetVHost: " + this.targetVHostName + ", targetAppName: " + this.targetAppName + ", streamNameSuffix: " + this.streamNameSuffix + "]", "application", "comment");
    }

    public void onAppStop(IApplicationInstance iApplicationInstance) {
        IVHost iVHost;
        String string = this.targetAppName;
        String[] stringArray = this.targetAppName.split("/");
        if (stringArray.length >= 1) {
            string = stringArray[0];
        }
        if ((iVHost = VHostSingleton.getInstance((String)this.targetVHostName)) != null && iVHost.isApplicationLoaded(string)) {
            iVHost.getApplication(string).removeApplicationInstanceListener((IApplicationInstanceNotify)this.targetAppInstanceNotify);
        }
    }

    public void onStreamCreate(IMediaStream iMediaStream) {
        iMediaStream.addClientListener((IMediaStreamActionNotify3)this.sourceStreamNotify);
        iMediaStream.addLivePacketListener((IMediaStreamLivePacketNotify)this.sourcePacketListener);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void onStreamDestroy(IMediaStream iMediaStream) {
        Object object = this.lock;
        synchronized (object) {
            iMediaStream.removeClientListener((IMediaStreamActionNotify3)this.sourceStreamNotify);
            iMediaStream.removeLivePacketListener((IMediaStreamLivePacketNotify)this.sourcePacketListener);
            this.delayedPackets.remove(iMediaStream);
        }
    }

    private void doRestart(String string) {
        Timer timer = new Timer();
        timer.schedule((TimerTask)new RestartTask(string), this.restartTimeout);
    }

    class RestartTask
    extends TimerTask {
        private final String streamName;

        RestartTask(String string) {
            this.streamName = string;
        }

        @Override
        public void run() {
            IMediaStream iMediaStream = ModuleDuplicateStreams.this.appInstance.getStreams().getStream(this.streamName);
            if (iMediaStream != null) {
                iMediaStream.addLivePacketListener((IMediaStreamLivePacketNotify)ModuleDuplicateStreams.this.sourcePacketListener);
            }
        }
    }

    private class TargetAppInstanceNotify
    implements IApplicationInstanceNotify {
        private TargetAppInstanceNotify() {
        }

        public void onApplicationInstanceCreate(IApplicationInstance iApplicationInstance) {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void onApplicationInstanceDestroy(IApplicationInstance iApplicationInstance) {
            Object object = ModuleDuplicateStreams.this.lock;
            synchronized (object) {
                List list = ModuleDuplicateStreams.this.appInstance.getPublishStreamNames();
                for (String string : list) {
                    Publisher publisher;
                    IMediaStream iMediaStream = ModuleDuplicateStreams.this.appInstance.getStreams().getStream(string);
                    if (iMediaStream == null || (publisher = (Publisher)iMediaStream.getProperties().get((Object)"duplicateStreamsPublisher")) == null || !publisher.getAppInstance().equals(iApplicationInstance)) continue;
                    publisher.unpublish();
                    publisher.close();
                    iMediaStream.getProperties().remove((Object)"duplicateStreamsPublisher");
                    iMediaStream.removeLivePacketListener((IMediaStreamLivePacketNotify)ModuleDuplicateStreams.this.sourcePacketListener);
                    if (!ModuleDuplicateStreams.this.doRestarts) continue;
                    ModuleDuplicateStreams.this.doRestart(string);
                }
            }
        }
    }

    private class SourceStreamNotify
    extends MediaStreamActionNotifyBase {
        private SourceStreamNotify() {
        }

        public void onMetaData(IMediaStream iMediaStream, AMFPacket aMFPacket) {
            ModuleDuplicateStreams.this.sourcePacketListener.onLivePacket(iMediaStream, aMFPacket);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void onUnPublish(IMediaStream iMediaStream, String string, boolean bl, boolean bl2) {
            Object object = ModuleDuplicateStreams.this.lock;
            synchronized (object) {
                Publisher publisher = (Publisher)iMediaStream.getProperties().get((Object)"duplicateStreamsPublisher");
                if (publisher != null) {
                    publisher.unpublish();
                    publisher.close();
                    iMediaStream.getProperties().remove((Object)"duplicateStreamsPublisher");
                    iMediaStream.removeLivePacketListener((IMediaStreamLivePacketNotify)ModuleDuplicateStreams.this.sourcePacketListener);
                }
            }
        }
    }

    private class SourcePacketListener
    implements IMediaStreamLivePacketNotify {
        private SourcePacketListener() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void onLivePacket(IMediaStream iMediaStream, AMFPacket aMFPacket) {
            String string = iMediaStream.getName();
            Object object = ModuleDuplicateStreams.this.lock;
            synchronized (object) {
                if (string.length() > 0 || ModuleDuplicateStreams.this.delayedPackets.containsKey(iMediaStream) && ((List)ModuleDuplicateStreams.this.delayedPackets.get(iMediaStream)).size() > 100) {
                    if (ModuleDuplicateStreams.this.delayedPackets.containsKey(iMediaStream)) {
                        if (((List)ModuleDuplicateStreams.this.delayedPackets.get(iMediaStream)).size() > 100) {
                            ModuleDuplicateStreams.this.logger.warn("ModuleDuplicateStreams.onLivePacket stream name missing for too long.  Cannot publish stream.", iMediaStream, "application", "comment", 500, null);
                            ModuleDuplicateStreams.this.delayedPackets.remove(iMediaStream);
                            iMediaStream.removeLivePacketListener((IMediaStreamLivePacketNotify)this);
                            if (ModuleDuplicateStreams.this.doRestarts) {
                                ModuleDuplicateStreams.this.doRestart(string);
                            }
                            return;
                        }
                        this.flushDelayedPackets(iMediaStream);
                    }
                } else {
                    ArrayList<AMFPacket> arrayList = (ArrayList<AMFPacket>)ModuleDuplicateStreams.this.delayedPackets.get(iMediaStream);
                    if (arrayList == null) {
                        arrayList = new ArrayList<AMFPacket>();
                        ModuleDuplicateStreams.this.delayedPackets.put(iMediaStream, arrayList);
                    }
                    arrayList.add(aMFPacket);
                    return;
                }
            }
            object = (Publisher)iMediaStream.getProperties().get((Object)"duplicateStreamsPublisher");
            if (object == null) {
                boolean bl = this.checkStartStream(string);
                if (!bl) {
                    iMediaStream.removeLivePacketListener((IMediaStreamLivePacketNotify)this);
                    return;
                }
                IVHost iVHost = VHostSingleton.getInstance((String)ModuleDuplicateStreams.this.targetVHostName);
                String string2 = ModuleDuplicateStreams.this.targetAppName;
                String string3 = "_definst_";
                String[] stringArray = ModuleDuplicateStreams.this.targetAppName.split("/");
                if (stringArray.length >= 1) {
                    string2 = stringArray[0];
                }
                if (stringArray.length >= 2) {
                    string3 = stringArray[1];
                }
                if ((object = Publisher.createInstance((IVHost)iVHost, (String)string2, (String)string3)) != null) {
                    IMediaStream iMediaStream2 = object.getAppInstance().getStreams().getStream(string + ModuleDuplicateStreams.this.streamNameSuffix);
                    if (iMediaStream2 != null) {
                        object.close();
                        iMediaStream.removeLivePacketListener((IMediaStreamLivePacketNotify)this);
                        ModuleDuplicateStreams.this.logger.warn("ModuleDuplicateStreams.onLivePacket target stream already exists.  Cannot publish stream [source: " + string + ", target: " + string + ModuleDuplicateStreams.this.streamNameSuffix + "]", iMediaStream, "application", "comment", 500, null);
                        if (ModuleDuplicateStreams.this.doRestarts) {
                            ModuleDuplicateStreams.this.doRestart(string);
                        }
                        return;
                    }
                    object.setStreamType(object.getAppInstance().getStreamType());
                    object.publish(string + ModuleDuplicateStreams.this.streamNameSuffix);
                    iMediaStream.getProperties().setProperty("duplicateStreamsPublisher", object);
                    object.getAppInstance().getApplication().addApplicationInstanceListener((IApplicationInstanceNotify)ModuleDuplicateStreams.this.targetAppInstanceNotify);
                }
            }
            switch (aMFPacket.getType()) {
                case 8: {
                    object.addAudioData(aMFPacket.getData(), aMFPacket.getAbsTimecode());
                    break;
                }
                case 9: {
                    object.addVideoData(aMFPacket.getData(), aMFPacket.getAbsTimecode());
                    break;
                }
                case 15: 
                case 18: {
                    object.addDataData(aMFPacket.getData(), aMFPacket.getAbsTimecode());
                }
            }
        }

        private boolean checkStartStream(String string) {
            if (!StringUtils.isEmpty((String)ModuleDuplicateStreams.this.streamNameSuffix) && string.endsWith(ModuleDuplicateStreams.this.streamNameSuffix)) {
                return false;
            }
            boolean bl = false;
            if (ModuleDuplicateStreams.this.streamNames.equals("*") || ModuleDuplicateStreams.this.streamNames.equals(string)) {
                bl = true;
            } else {
                String[] stringArray;
                for (String string2 : stringArray = ModuleDuplicateStreams.this.streamNames.split(",")) {
                    if ((string2 = string2.trim()).equals(string)) {
                        bl = true;
                        break;
                    }
                    if (string2.startsWith("*") && string.endsWith(string2.substring(1))) {
                        bl = true;
                        break;
                    }
                    if (!string2.endsWith("*") || !string.startsWith(string2.substring(0, string2.length() - 1))) continue;
                    bl = true;
                    break;
                }
            }
            return bl;
        }

        private void flushDelayedPackets(IMediaStream iMediaStream) {
            List list = (List)ModuleDuplicateStreams.this.delayedPackets.remove(iMediaStream);
            for (AMFPacket aMFPacket : list) {
                this.onLivePacket(iMediaStream, aMFPacket);
            }
        }
    }
}

