/*
 * Decompiled with CFR 0.152.
 */
package com.wowza.wms.plugin;

import com.wowza.util.StringUtils;
import com.wowza.wms.application.IApplicationInstance;
import com.wowza.wms.logging.WMSLogger;
import com.wowza.wms.logging.WMSLoggerFactory;
import com.wowza.wms.module.ModuleBase;
import com.wowza.wms.stream.IMediaStream;
import com.wowza.wms.stream.livedvr.ILiveStreamDvrRecorderControl;

public class DvrRecorderControl
extends ModuleBase {
    public static final String MODULE_NAME = "DvrRecorderControl";
    public static final String PROP_NAME_PREFIX = "dvrRecorderControl";
    private WMSLogger logger;
    private String suffixes = "*";
    private boolean matchAllow = true;
    private boolean noMatchAllow = false;

    public void onAppStart(IApplicationInstance iApplicationInstance) {
        this.logger = WMSLoggerFactory.getLoggerObj((IApplicationInstance)iApplicationInstance);
        this.suffixes = iApplicationInstance.getProperties().getPropertyStr("dvrRecorderControlSuffixes", this.suffixes);
        this.matchAllow = iApplicationInstance.getProperties().getPropertyBoolean("dvrRecorderControlMatchAllow", this.matchAllow);
        this.noMatchAllow = iApplicationInstance.getProperties().getPropertyBoolean("dvrRecorderControlNoMatchAllow", this.noMatchAllow);
        iApplicationInstance.setLiveStreamDvrRecorderControl((ILiveStreamDvrRecorderControl)new DvrRecorderController());
    }

    private class DvrRecorderController
    implements ILiveStreamDvrRecorderControl {
        private DvrRecorderController() {
        }

        public boolean shouldDvrRecord(String string, IMediaStream iMediaStream) {
            String[] stringArray;
            DvrRecorderControl.this.logger.info("DvrRecorderControl.shouldDvrRecord [" + string + " : " + iMediaStream.getName() + " : " + DvrRecorderControl.this.suffixes + "]", iMediaStream);
            if (DvrRecorderControl.this.suffixes.equals("*")) {
                DvrRecorderControl.this.logger.info("DvrRecorderControl.shouldDvrRecord [" + string + " : " + iMediaStream.getName() + " :  suffixes is wildcard. returning " + DvrRecorderControl.this.matchAllow + "]", iMediaStream);
                return DvrRecorderControl.this.matchAllow;
            }
            if (StringUtils.isEmpty((String)DvrRecorderControl.this.suffixes)) {
                DvrRecorderControl.this.logger.info("DvrRecorderControl.shouldDvrRecord [" + string + " : " + iMediaStream.getName() + " : suffixes is empty. returning " + DvrRecorderControl.this.noMatchAllow + "]", iMediaStream);
                return DvrRecorderControl.this.noMatchAllow;
            }
            for (String string2 : stringArray = DvrRecorderControl.this.suffixes.split(",")) {
                if (!iMediaStream.getName().endsWith(string2.trim())) continue;
                DvrRecorderControl.this.logger.info("DvrRecorderControl.shouldDvrRecord [" + string + " : " + iMediaStream.getName() + " : match found : " + string2.trim() + " : returning " + DvrRecorderControl.this.matchAllow + "]", iMediaStream);
                return DvrRecorderControl.this.matchAllow;
            }
            DvrRecorderControl.this.logger.info("DvrRecorderControl.shouldDvrRecord [" + string + " : " + iMediaStream.getName() + " : No match found : returning " + DvrRecorderControl.this.noMatchAllow + "]", iMediaStream);
            return DvrRecorderControl.this.noMatchAllow;
        }
    }
}

