/*
 * Decompiled with CFR 0.152.
 */
package com.wowza.wms.plugin.geoip;

import com.maxmind.geoip2.exception.GeoIp2Exception;
import com.maxmind.geoip2.model.CountryResponse;
import com.maxmind.geoip2.record.Country;
import com.wowza.util.StringUtils;
import com.wowza.wms.amf.AMFDataList;
import com.wowza.wms.application.IApplicationInstance;
import com.wowza.wms.client.IClient;
import com.wowza.wms.httpstreamer.model.IHTTPStreamerSession;
import com.wowza.wms.logging.WMSLogger;
import com.wowza.wms.logging.WMSLoggerFactory;
import com.wowza.wms.module.ModuleBase;
import com.wowza.wms.plugin.geoip.ServerListenerGeoIp;
import com.wowza.wms.request.RequestFunction;
import com.wowza.wms.rtp.model.IRTSPActionNotify;
import com.wowza.wms.rtp.model.RTPSession;
import com.wowza.wms.rtp.model.RTSPActionNotifyBase;
import com.wowza.wms.rtsp.RTSPRequestMessage;
import com.wowza.wms.rtsp.RTSPResponseMessages;
import com.wowza.wms.server.Server;
import com.wowza.wms.util.SecurityUtils;
import java.util.ArrayList;
import java.util.List;

public class ModuleGeoIp
extends ModuleBase {
    public static final String CLASSNAME = "ModuleGeoIP";
    private WMSLogger logger;
    private IApplicationInstance appInstance;
    private ServerListenerGeoIp geoIpReader = (ServerListenerGeoIp)Server.getInstance().getProperties().get((Object)"ServerListenerGeoIp");
    private RTSPActionNotifyListener rtspListener = new RTSPActionNotifyListener();
    private String allowedEncodersStr = "Wirecast/|FME/|FMLE/|Wowza GoCoder*|Lavf/|UA Teradek/|KulaByte/|HaivisionKB/|VidBlaster/|XSplit/|PESA|makitoX/|Elemental Live/";
    private List<String> allowedEncoders = new ArrayList<String>();
    private String allowedIpsStr = "";
    private List<String> allowedIps;
    private String countriesStr = "*";
    private List<String> countries;
    private boolean matchAllow = true;
    private boolean debugLog = false;
    private String category = "application";
    private String event = "comment";

    public void onAppStart(IApplicationInstance iApplicationInstance) {
        this.logger = WMSLoggerFactory.getLoggerObj((IApplicationInstance)iApplicationInstance);
        this.appInstance = iApplicationInstance;
        this.allowedEncodersStr = iApplicationInstance.getProperties().getPropertyStr("securityPublishValidEncoders", this.allowedEncodersStr);
        this.allowedEncodersStr = iApplicationInstance.getProperties().getPropertyStr("geoIpAllowedEncoders", this.allowedEncodersStr);
        this.allowedEncoders = SecurityUtils.parseValidFlashStrings((String)this.allowedEncodersStr);
        this.allowedIpsStr = iApplicationInstance.getProperties().getPropertyStr("geoIpAllowedIps", this.allowedIpsStr);
        this.allowedIps = this.splitPropertyIntoList(this.allowedIpsStr, true);
        this.countriesStr = iApplicationInstance.getProperties().getPropertyStr("geoIpCountries", this.countriesStr);
        this.countries = this.splitPropertyIntoList(this.countriesStr, false);
        this.matchAllow = iApplicationInstance.getProperties().getPropertyBoolean("geoIpMatchAllow", this.matchAllow);
        this.debugLog = iApplicationInstance.getProperties().getPropertyBoolean("geoIpDebugLog", this.debugLog);
        if (this.logger.isDebugEnabled()) {
            this.debugLog = true;
        }
        if (this.geoIpReader == null) {
            this.logger.warn("ModuleGeoIp.onAppStart [" + iApplicationInstance.getContextStr() + "] Build #1 ServerListenerGeoIp not set");
        } else {
            this.logger.info("ModuleGeoIp.onAppStart [" + iApplicationInstance.getContextStr() + "] Build #1 countries: " + this.countries + ", matchAllow: " + this.matchAllow + ", allowedIps: " + this.allowedIps + ", allowedEncoders: " + this.allowedEncoders, "application", "comment");
        }
    }

    public void onConnect(IClient iClient, RequestFunction requestFunction, AMFDataList aMFDataList) {
        try {
            if (this.debugLog) {
                this.logger.info(String.format("%s.onConnect [%s] clientIp: %s, flashVer: %s", CLASSNAME, this.appInstance.getContextStr(), iClient.getIp(), iClient.getFlashVer()), this.category, this.event);
            }
            if (SecurityUtils.isValidFlashVersion((String)iClient.getFlashVer(), this.allowedEncoders)) {
                return;
            }
            if (SecurityUtils.isInIPList((String)iClient.getIp(), this.allowedIps)) {
                return;
            }
            if (this.checkAddress(iClient.getIp())) {
                return;
            }
            iClient.rejectConnection();
        }
        catch (Exception exception) {
            this.logger.error("ModuleGeoIP.onConnect [" + this.appInstance.getContextStr() + "] error occured.", (Throwable)exception);
        }
        catch (Throwable throwable) {
            this.logger.error("ModuleGeoIP.onConnect [" + this.appInstance.getContextStr() + "] Throwable error occured.", throwable);
        }
    }

    public void onHTTPSessionCreate(IHTTPStreamerSession iHTTPStreamerSession) {
        try {
            if (this.debugLog) {
                this.logger.info(String.format("%s.onHTTPSessionCreate [%s] sessionIp: %s", CLASSNAME, this.appInstance.getContextStr(), iHTTPStreamerSession.getIpAddress()), this.category, this.event);
            }
            if (SecurityUtils.isInIPList((String)iHTTPStreamerSession.getIpAddress(), this.allowedIps)) {
                return;
            }
            if (this.checkAddress(iHTTPStreamerSession.getIpAddress())) {
                return;
            }
            iHTTPStreamerSession.rejectSession();
            iHTTPStreamerSession.setDeleteSession();
        }
        catch (Exception exception) {
            this.logger.error("ModuleGeoIP.onHttpSessionCreate [" + this.appInstance.getContextStr() + "] error occured.", (Throwable)exception);
        }
        catch (Throwable throwable) {
            this.logger.error("ModuleGeoIP.onHttpSessionCreate [" + this.appInstance.getContextStr() + "] Throwable error occured.", throwable);
        }
    }

    public void onRTPSessionCreate(RTPSession rTPSession) {
        rTPSession.addActionListener((IRTSPActionNotify)this.rtspListener);
    }

    public boolean checkAddress(String string) {
        Country country;
        boolean bl = !this.matchAllow;
        CountryResponse countryResponse = null;
        try {
            countryResponse = this.geoIpReader.getGeoIpCountry(string);
        }
        catch (GeoIp2Exception geoIp2Exception) {
            this.logger.warn(String.format("%s.checkAddress [%s]: %s.", CLASSNAME, this.appInstance.getContextStr(), geoIp2Exception.getMessage()), this.category, this.event);
        }
        if (countryResponse != null && (country = countryResponse.getCountry()) != null) {
            if (this.debugLog) {
                this.logger.info(String.format("%s.checkAddress [%s] ipAddress: %s, country: %s", CLASSNAME, this.appInstance.getContextStr(), string, country), this.category, this.event);
            }
            String string2 = country.getIsoCode();
            for (String string3 : this.countries) {
                if (string3.equals("*")) {
                    if (this.debugLog) {
                        this.logger.info(String.format("%s.checkAddress [%s] ipAddress: %s, isoCode: %s, countryCode: %s is wildcard. returning %b", CLASSNAME, this.appInstance.getContextStr(), string, string2, string3, this.matchAllow), this.category, this.event);
                    }
                    bl = this.matchAllow;
                    break;
                }
                if (StringUtils.isEmpty((String)string2)) {
                    if (this.debugLog) {
                        this.logger.info(String.format("%s.checkAddress [%s] ipAddress: %s, isoCode: %s is empty. returning %b", CLASSNAME, this.appInstance.getContextStr(), string, string2, !this.matchAllow), this.category, this.event);
                    }
                    bl = !this.matchAllow;
                    break;
                }
                if (!string2.matches(string3)) continue;
                if (this.debugLog) {
                    this.logger.info(String.format("%s.checkAddress [%s] ipAddress: %s, isoCode: %s, matches countryCode: %s. returning %b", CLASSNAME, this.appInstance.getContextStr(), string, string2, string3, this.matchAllow), this.category, this.event);
                }
                bl = this.matchAllow;
                break;
            }
        }
        return bl;
    }

    private List<String> splitPropertyIntoList(String string, boolean bl) {
        String[] stringArray;
        ArrayList<String> arrayList = new ArrayList<String>();
        if (StringUtils.isEmpty((String)string)) {
            return arrayList;
        }
        for (String string2 : stringArray = string.split("[,|]")) {
            string2 = string2.trim();
            if (bl) {
                if (SecurityUtils.isValidIPMatchingString((String)string2)) {
                    arrayList.add(string2);
                    continue;
                }
                this.logger.warn(String.format("ModuleGeoIp.splitPropertyIntoList[%s]: Invalid IP list string '%s'.", this.appInstance.getContextStr(), string2), this.category, this.event);
                continue;
            }
            arrayList.add(string2);
        }
        return arrayList;
    }

    class RTSPActionNotifyListener
    extends RTSPActionNotifyBase {
        RTSPActionNotifyListener() {
        }

        public void onDescribe(RTPSession rTPSession, RTSPRequestMessage rTSPRequestMessage, RTSPResponseMessages rTSPResponseMessages) {
            try {
                if (ModuleGeoIp.this.debugLog) {
                    ModuleGeoIp.this.logger.info(String.format("%s::RTSPActionNotifyListener.onDescribe [%s] sessionIp: %s", ModuleGeoIp.CLASSNAME, ModuleGeoIp.this.appInstance.getContextStr(), rTPSession.getIp()), ModuleGeoIp.this.category, ModuleGeoIp.this.event);
                }
                if (SecurityUtils.isInIPList((String)rTPSession.getIp(), (List)ModuleGeoIp.this.allowedIps)) {
                    return;
                }
                if (ModuleGeoIp.this.checkAddress(rTPSession.getIp())) {
                    return;
                }
                rTPSession.rejectSession();
            }
            catch (Exception exception) {
                ModuleGeoIp.this.logger.error("ModuleGeoIP::RTSPActionNotifyListener.onDescribe [" + ModuleGeoIp.this.appInstance.getContextStr() + "] error occured.", (Throwable)exception);
            }
            catch (Throwable throwable) {
                ModuleGeoIp.this.logger.error("ModuleGeoIP::RTSPActionNotifyListener.onDescribe [" + ModuleGeoIp.this.appInstance.getContextStr() + "] Throwable error occured.", throwable);
            }
        }

        public void onAnnounce(RTPSession rTPSession, RTSPRequestMessage rTSPRequestMessage, RTSPResponseMessages rTSPResponseMessages) {
            try {
                if (ModuleGeoIp.this.debugLog) {
                    ModuleGeoIp.this.logger.info(String.format("%s::RTSPActionNotifyListener.onAnnounce [%s] sessionIp: %s, userAgent: %s", ModuleGeoIp.CLASSNAME, ModuleGeoIp.this.appInstance.getContextStr(), rTPSession.getIp(), rTPSession.getUserAgent()), ModuleGeoIp.this.category, ModuleGeoIp.this.event);
                }
                if (SecurityUtils.isValidFlashVersion((String)rTPSession.getUserAgent(), (List)ModuleGeoIp.this.allowedEncoders)) {
                    return;
                }
                if (SecurityUtils.isInIPList((String)rTPSession.getIp(), (List)ModuleGeoIp.this.allowedIps)) {
                    return;
                }
                if (ModuleGeoIp.this.checkAddress(rTPSession.getIp())) {
                    return;
                }
                rTPSession.rejectSession();
            }
            catch (Exception exception) {
                ModuleGeoIp.this.logger.error("ModuleGeoIP::RTSPActionNotifyListener.onAnnounce [" + ModuleGeoIp.this.appInstance.getContextStr() + "] error occured.", (Throwable)exception);
            }
            catch (Throwable throwable) {
                ModuleGeoIp.this.logger.error("ModuleGeoIP::RTSPActionNotifyListener.onAnnounce [" + ModuleGeoIp.this.appInstance.getContextStr() + "] Throwable error occured.", throwable);
            }
        }
    }
}

