/*
 * Decompiled with CFR 0.152.
 */
package com.wowza.wms.plugin.geoip;

import com.maxmind.geoip2.DatabaseReader;
import com.maxmind.geoip2.GeoIp2Provider;
import com.maxmind.geoip2.WebServiceClient;
import com.maxmind.geoip2.exception.GeoIp2Exception;
import com.maxmind.geoip2.model.CountryResponse;
import com.wowza.util.StringUtils;
import com.wowza.util.SystemUtils;
import com.wowza.wms.bootstrap.Bootstrap;
import com.wowza.wms.logging.WMSLoggerFactory;
import com.wowza.wms.server.IServer;
import com.wowza.wms.server.IServerNotify2;
import java.io.Closeable;
import java.io.File;
import java.io.IOException;
import java.net.InetAddress;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Timer;
import java.util.TimerTask;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReadWriteLock;
import java.util.concurrent.locks.ReentrantReadWriteLock;

public class ServerListenerGeoIp
implements IServerNotify2 {
    public static final String PROP_GEOIP_READER = "ServerListenerGeoIp";
    public static final int CACHE_CAPACITY = 4096;
    private ReadWriteLock lock = new ReentrantReadWriteLock();
    private Lock readLock = this.lock.readLock();
    private Lock writeLock = this.lock.writeLock();
    private GeoIp2Provider provider;
    private int accountId = -1;
    private String licenseKey = null;
    private File dbFile = null;
    private long dbLastModified = -1L;
    private Timer checkTimer = null;
    private long checkInterval = 1000L;
    private long checkTimeout = this.checkInterval * 30L;
    private long lastLookup = -1L;
    private boolean shuttingDown = false;
    private ConcurrentMap<String, MaxmindResponse> cache = new ConcurrentHashMap<String, MaxmindResponse>(4096);

    public void onServerConfigLoaded(IServer iServer) {
        this.accountId = iServer.getProperties().getPropertyInt("geoIpAccountId", this.accountId);
        this.licenseKey = iServer.getProperties().getPropertyStr("geoIpLicenseKey", this.licenseKey);
        String string = iServer.getProperties().getPropertyStr("geoIpDatabasePath", Bootstrap.getServerHome((int)2) + File.separatorChar + "conf" + File.separatorChar + "GeoIP2-Country.mmdb");
        this.dbFile = new File(SystemUtils.expandEnvironmentVariables((String)string));
        if (!this.dbFile.exists() && this.dbFile.isFile()) {
            this.dbFile = null;
        }
    }

    public void onServerCreate(IServer iServer) {
        iServer.getProperties().setProperty(PROP_GEOIP_READER, (Object)this);
    }

    public void onServerInit(IServer iServer) {
        this.checkTimer = new Timer();
        this.checkTimer.schedule(new TimerTask(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void run() {
                ServerListenerGeoIp.this.writeLock.lock();
                try {
                    if (ServerListenerGeoIp.this.provider instanceof WebServiceClient) {
                        if (ServerListenerGeoIp.this.lastLookup + ServerListenerGeoIp.this.checkTimeout > System.currentTimeMillis()) {
                            ((WebServiceClient)ServerListenerGeoIp.this.provider).close();
                            ServerListenerGeoIp.this.provider = null;
                        }
                    } else if (ServerListenerGeoIp.this.dbFile.exists() && ServerListenerGeoIp.this.dbFile.lastModified() > ServerListenerGeoIp.this.dbLastModified) {
                        if (ServerListenerGeoIp.this.provider instanceof DatabaseReader) {
                            ((DatabaseReader)ServerListenerGeoIp.this.provider).close();
                            ServerListenerGeoIp.this.provider = null;
                            ServerListenerGeoIp.this.cache.clear();
                        }
                        ServerListenerGeoIp.this.dbLastModified = ServerListenerGeoIp.this.dbFile.lastModified();
                    }
                    if (ServerListenerGeoIp.this.cache.size() >= 4096) {
                        ArrayList arrayList = new ArrayList(ServerListenerGeoIp.this.cache.values());
                        Collections.sort(arrayList);
                        for (MaxmindResponse maxmindResponse : arrayList) {
                            if (!((double)ServerListenerGeoIp.this.cache.size() > 3072.0)) continue;
                            ServerListenerGeoIp.this.cache.values().remove(maxmindResponse);
                        }
                    }
                }
                catch (IOException iOException) {
                    WMSLoggerFactory.getLogger(this.getClass()).error("ServerListenerGeoIp::CheckTimer.run error occured", (Throwable)iOException);
                }
                finally {
                    ServerListenerGeoIp.this.writeLock.unlock();
                }
            }
        }, 0L, this.checkInterval);
    }

    public void onServerShutdownStart(IServer iServer) {
        this.writeLock.lock();
        try {
            this.checkTimer.cancel();
            if (this.provider != null) {
                ((Closeable)this.provider).close();
            }
        }
        catch (IOException iOException) {
        }
        finally {
            this.shuttingDown = true;
            this.provider = null;
            this.writeLock.unlock();
        }
    }

    public void onServerShutdownComplete(IServer iServer) {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public CountryResponse getGeoIpCountry(String string) throws GeoIp2Exception {
        MaxmindResponse maxmindResponse;
        block18: {
            maxmindResponse = null;
            this.readLock.lock();
            try {
                block19: {
                    maxmindResponse = (MaxmindResponse)this.cache.get(string);
                    if (this.shuttingDown || maxmindResponse != null) break block18;
                    if (this.provider == null) {
                        this.readLock.unlock();
                        this.writeLock.lock();
                        try {
                            if (this.provider != null || this.shuttingDown) break block19;
                            try {
                                if (this.accountId != -1 && !StringUtils.isEmpty((String)this.licenseKey)) {
                                    this.provider = new WebServiceClient.Builder(this.accountId, this.licenseKey).build();
                                } else if (this.dbFile.exists()) {
                                    this.provider = new DatabaseReader.Builder(this.dbFile).build();
                                }
                            }
                            catch (Exception exception) {
                                WMSLoggerFactory.getLogger(this.getClass()).error("ServerListenerGeoIp.checkProvider error occured", (Throwable)exception);
                            }
                        }
                        catch (Exception exception) {
                            WMSLoggerFactory.getLogger(this.getClass()).error("ServerListenerGeoIp.checkProvider2 error occured", (Throwable)exception);
                        }
                        finally {
                            this.readLock.lock();
                            this.writeLock.unlock();
                        }
                    }
                }
                if (this.provider != null) {
                    InetAddress inetAddress = InetAddress.getByName(string);
                    CountryResponse countryResponse = this.provider.country(inetAddress);
                    this.lastLookup = System.currentTimeMillis();
                    maxmindResponse = new MaxmindResponse(countryResponse, this.lastLookup);
                    this.cache.putIfAbsent(string, maxmindResponse);
                }
            }
            catch (IOException iOException) {
                WMSLoggerFactory.getLogger(this.getClass()).error("ServerListenerGeoIp.getGeoIpCountry error occured", (Throwable)iOException);
            }
            finally {
                this.readLock.unlock();
            }
        }
        if (maxmindResponse != null) {
            maxmindResponse.lastAccess = System.currentTimeMillis();
            return maxmindResponse.countryResponse;
        }
        return null;
    }

    class MaxmindResponse
    implements Comparable<MaxmindResponse> {
        long lastAccess = -1L;
        CountryResponse countryResponse = null;

        public MaxmindResponse(CountryResponse countryResponse, long l) {
            this.countryResponse = countryResponse;
            this.lastAccess = l;
        }

        @Override
        public int compareTo(MaxmindResponse maxmindResponse) {
            return Long.compare(this.lastAccess, maxmindResponse.lastAccess);
        }
    }
}

