/*
 * Decompiled with CFR 0.152.
 */
package com.wowza.wms.plugin;

import com.wowza.wms.application.IApplicationInstance;
import com.wowza.wms.http.HTTProvider2Base;
import com.wowza.wms.http.IHTTPRequest;
import com.wowza.wms.http.IHTTPResponse;
import com.wowza.wms.logging.WMSLogger;
import com.wowza.wms.logging.WMSLoggerFactory;
import com.wowza.wms.stream.publish.Playlist;
import com.wowza.wms.stream.publish.Stream;
import com.wowza.wms.vhost.IVHost;
import java.io.OutputStream;
import java.util.Iterator;
import java.util.List;
import java.util.Set;

public class HTTPStreamControl
extends HTTProvider2Base {
    public static final String CLASSNAME = "HTTPStreamControl";
    private static final Class<HTTPStreamControl> CLASS = HTTPStreamControl.class;
    private WMSLogger logger = WMSLoggerFactory.getLogger(CLASS);

    public void init() {
        super.init();
        this.logger.info("HTTPStreamControl.init: Build# 1");
    }

    public void onHTTPRequest(IVHost iVHost, IHTTPRequest iHTTPRequest, IHTTPResponse iHTTPResponse) {
        Object object;
        Object object2;
        if (!this.doHTTPAuthentication(iVHost, iHTTPRequest, iHTTPResponse)) {
            return;
        }
        StringBuffer stringBuffer = new StringBuffer();
        Set set = iHTTPRequest.getParameterNames();
        IApplicationInstance iApplicationInstance = null;
        String string = "getStreamNames";
        String string2 = null;
        String string3 = null;
        String string4 = null;
        int n = 0;
        int n2 = -1;
        if (set.contains("appName")) {
            object2 = iHTTPRequest.getParameter("appName");
            object = iHTTPRequest.getParameter("appInstanceName");
            object = object == null ? "_definst_" : object;
            try {
                iApplicationInstance = iVHost.getApplication((String)object2).getAppInstance((String)object);
            }
            catch (Exception exception) {
                this.logger.error("Invalid appInstance: " + exception);
            }
            if (iApplicationInstance != null) {
                if (set.contains("action")) {
                    string = iHTTPRequest.getParameter("action");
                }
                if (set.contains("streamName")) {
                    string2 = iHTTPRequest.getParameter("streamName");
                }
                if (set.contains("playlistName")) {
                    string3 = iHTTPRequest.getParameter("playlistName");
                }
                if (set.contains("playlistItemName")) {
                    string4 = iHTTPRequest.getParameter("playlistItemName");
                }
                if (set.contains("start")) {
                    n = Integer.parseInt(iHTTPRequest.getParameter("start"));
                }
                if (set.contains("length")) {
                    n2 = Integer.parseInt(iHTTPRequest.getParameter("length"));
                }
                if (string.equalsIgnoreCase("getStreamNames")) {
                    this.getStreamNames(iApplicationInstance, stringBuffer);
                } else if (string.equalsIgnoreCase("openPlaylistOnStream") && string3 != null && string2 != null) {
                    this.openPlaylistOnStream(iApplicationInstance, string3, string2, stringBuffer);
                } else if (string.equalsIgnoreCase("addItemToPlaylist") && string3 != null && string4 != null) {
                    this.addItemToPlaylist(iApplicationInstance, string3, string4, n, n2, stringBuffer);
                } else if (string.equalsIgnoreCase("removeItemFromPlaylist") && string4 != null && string2 != null) {
                    this.removeItemFromPlaylist(iApplicationInstance, string4, string2, stringBuffer);
                } else if (string.equalsIgnoreCase("playNextPlaylistItem") && string2 != null) {
                    this.playNextPlaylistItem(iApplicationInstance, string2, stringBuffer);
                } else if (string.equalsIgnoreCase("addNewStream") && string2 != null) {
                    this.addNewStream(iApplicationInstance, string2, stringBuffer);
                } else if (string.equalsIgnoreCase("addNewPlaylist") && string3 != null) {
                    this.addNewPlaylist(iApplicationInstance, string3, stringBuffer);
                } else if (string.equalsIgnoreCase("stopStream") && string2 != null) {
                    this.stopStream(iApplicationInstance, string2, stringBuffer);
                } else {
                    stringBuffer.append("Invalid or missing argument(s).");
                }
            } else {
                stringBuffer.append("Requires a valid application name.");
            }
        } else {
            stringBuffer.append("Requires an application name.");
        }
        try {
            object2 = iHTTPResponse.getOutputStream();
            object = stringBuffer.toString().getBytes();
            ((OutputStream)object2).write((byte[])object);
        }
        catch (Exception exception) {
            this.logger.error((Object)exception);
        }
    }

    public void getStreamNames(IApplicationInstance iApplicationInstance, StringBuffer stringBuffer) {
        this.logger.info("getFiles");
        List list = null;
        try {
            list = iApplicationInstance.getPublishers();
        }
        catch (Exception exception) {
            this.logger.error((Object)exception);
        }
        if (list != null) {
            Object object2;
            Iterator iterator = list.iterator();
            for (Object object2 : list) {
                this.logger.info("Stream Name: " + object2.getStream().getName());
            }
            object2 = iApplicationInstance.getStreams().getPublishStreamNames();
            Iterator iterator2 = object2.iterator();
            while (iterator2.hasNext()) {
                String string = (String)iterator2.next();
                stringBuffer.append(string);
            }
        }
    }

    public void openPlaylistOnStream(IApplicationInstance iApplicationInstance, String string, String string2, StringBuffer stringBuffer) {
        Stream stream = (Stream)iApplicationInstance.getProperties().getProperty(string2);
        Playlist playlist = (Playlist)iApplicationInstance.getProperties().getProperty(string);
        playlist.open(stream);
        this.logger.info("HTTPStreamControl.openPlaylistOnStream: playlist=" + string + " stream=" + string2);
        stringBuffer.append("Open Playlist: " + string + " on Stream " + string2);
    }

    public void addItemToPlaylist(IApplicationInstance iApplicationInstance, String string, String string2, int n, int n2, StringBuffer stringBuffer) {
        Playlist playlist = (Playlist)iApplicationInstance.getProperties().getProperty(string);
        playlist.addItem(string2, n, n2);
        this.logger.info("HTTPStreamControl.addItemToPlaylist: playlist=" + string + " playlist item=" + string2 + " start=" + n + "duration" + n2);
        stringBuffer.append("Add Item to Playlist: " + string + " with PlaylistItem=" + string2 + " start=" + n + " duration=" + n2);
    }

    public void removeItemFromPlaylist(IApplicationInstance iApplicationInstance, String string, String string2, StringBuffer stringBuffer) {
        Stream stream = (Stream)iApplicationInstance.getProperties().getProperty(string2);
        stream.removeFromPlaylist(string);
        this.logger.info("HTTPStreamControl.removeItemFromPlaylist: playlist item=" + string + " stream=" + string2);
        stringBuffer.append("Remove Item from Playlist: " + string + " on Stream " + string2);
    }

    public void playNextPlaylistItem(IApplicationInstance iApplicationInstance, String string, StringBuffer stringBuffer) {
        Stream stream = (Stream)iApplicationInstance.getProperties().getProperty(string);
        stream.next();
        this.logger.info("HTTPStreamControl.playNextPlaylistItem: stream=" + string);
        stringBuffer.append("Play Next Item on Playlist for Stream: " + string);
    }

    public void addNewStream(IApplicationInstance iApplicationInstance, String string, StringBuffer stringBuffer) {
        Stream stream = Stream.createInstance((IApplicationInstance)iApplicationInstance, (String)string);
        iApplicationInstance.getProperties().put((Object)string, (Object)stream);
        this.logger.info("HTTPStreamControl.addNewStream: stream=" + string);
        stringBuffer.append("Add New Stream for Playlist: " + string);
    }

    public void addNewPlaylist(IApplicationInstance iApplicationInstance, String string, StringBuffer stringBuffer) {
        Playlist playlist = new Playlist(string);
        playlist.setRepeat(true);
        iApplicationInstance.getProperties().put((Object)string, (Object)playlist);
        this.logger.info("HTTPStreamControl.addNewPlaylist: playlist=" + string);
        stringBuffer.append("Add New Playlist: " + string);
    }

    public void stopStream(IApplicationInstance iApplicationInstance, String string, StringBuffer stringBuffer) {
        Stream stream = (Stream)iApplicationInstance.getProperties().remove((Object)string);
        if (stream != null) {
            stream.close();
        }
        this.logger.info("HTTPStreamControl.stopStream: stream=" + string);
        stringBuffer.append("Stop Stream for Playlist: " + string);
    }
}

