/*
 * Decompiled with CFR 0.152.
 */
package com.wowza.wms.plugin;

import com.wowza.util.IOPerformanceCounter;
import com.wowza.wms.application.IApplicationInstance;
import com.wowza.wms.application.WMSProperties;
import com.wowza.wms.logging.WMSLogger;
import com.wowza.wms.logging.WMSLoggerFactory;
import com.wowza.wms.module.ModuleBase;
import com.wowza.wms.stream.IMediaStream;
import com.wowza.wms.stream.IMediaStreamActionNotify;
import java.util.Date;
import java.util.Timer;
import java.util.TimerTask;

public class ModuleLimitPublishedStreamBandwidth
extends ModuleBase
implements IMediaStreamActionNotify {
    public static final String MODULE_NAME = "ModuleLimitPublishedStreamBandwidth";
    public static final String PROP_NAME_PREFIX = "limitPublishedStreamBandwidth";
    IApplicationInstance appInstance;
    int maxBitrate = 800;
    int sustained = 10;
    int interval = 5000;
    boolean debugLog = false;
    WMSLogger logger = null;

    public void onAppStart(IApplicationInstance iApplicationInstance) {
        this.appInstance = iApplicationInstance;
        this.logger = WMSLoggerFactory.getLoggerObj((IApplicationInstance)iApplicationInstance);
        this.maxBitrate = iApplicationInstance.getProperties().getPropertyInt("MaxBitrate", this.maxBitrate);
        this.maxBitrate = iApplicationInstance.getProperties().getPropertyInt("limitPublishedStreamBandwidthMaxBitrate", this.maxBitrate);
        this.debugLog = iApplicationInstance.getProperties().getPropertyBoolean("StreamMonitorLogging", this.debugLog);
        this.debugLog = iApplicationInstance.getProperties().getPropertyBoolean("limitPublishedStreamBandwidthDebugLog", this.debugLog);
        if (this.logger.isDebugEnabled()) {
            this.debugLog = true;
        }
        this.sustained = iApplicationInstance.getProperties().getPropertyInt("limitPublishedStreamBandwidthSustained", this.sustained);
        this.logger.info("ModuleLimitPublishedStreamBandwidth Build #2. MaxBitrate: " + this.maxBitrate, "application", "comment");
    }

    public void onStreamCreate(IMediaStream iMediaStream) {
        iMediaStream.addClientListener((IMediaStreamActionNotify)this);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void onUnPublish(IMediaStream iMediaStream, String string, boolean bl, boolean bl2) {
        MonitorStream monitorStream;
        WMSProperties wMSProperties;
        WMSProperties wMSProperties2 = wMSProperties = iMediaStream.getProperties();
        synchronized (wMSProperties2) {
            monitorStream = (MonitorStream)wMSProperties.get((Object)"monitor");
        }
        if (monitorStream != null) {
            monitorStream.stop();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void onPublish(IMediaStream iMediaStream, String string, boolean bl, boolean bl2) {
        WMSProperties wMSProperties;
        Object object;
        if (iMediaStream.getClient() == null && iMediaStream.getRTPStream() == null) {
            this.logger.warn("ModuleLimitPublishedStreamBandwidth.onPublish: Stream is being published by a non-rtmp connection. It is not possible to limit the bandwidth. [" + this.appInstance.getContextStr() + "/" + string + "]", "application", "comment");
            return;
        }
        if (!(iMediaStream.getRTPStream() == null || (object = iMediaStream.getRTPStream().getSession()) != null && object.isAnnounce())) {
            this.logger.warn("ModuleLimitPublishedStreamBandwidth.onPublish: Stream is being published by a RTSP mediaCaster connection. It is not possible to limit the bandwidth. [" + this.appInstance.getContextStr() + "/" + string + "]", "application", "comment");
            return;
        }
        object = new MonitorStream(iMediaStream);
        WMSProperties wMSProperties2 = wMSProperties = iMediaStream.getProperties();
        synchronized (wMSProperties2) {
            wMSProperties.setProperty("monitor", object);
        }
        ((MonitorStream)object).start();
    }

    public void onPlay(IMediaStream iMediaStream, String string, double d, double d2, int n) {
    }

    public void onSeek(IMediaStream iMediaStream, double d) {
    }

    public void onStop(IMediaStream iMediaStream) {
    }

    public void onPause(IMediaStream iMediaStream, boolean bl, double d) {
    }

    private class MonitorStream {
        public Timer mTimer;
        public TimerTask mTask;
        public IMediaStream stream;

        public MonitorStream(IMediaStream iMediaStream) {
            this.stream = iMediaStream;
            this.mTask = new TimerTask(){

                @Override
                public void run() {
                    if (MonitorStream.this.stream == null) {
                        MonitorStream.this.stop();
                    }
                    IOPerformanceCounter iOPerformanceCounter = MonitorStream.this.stream.getMediaIOPerformance();
                    Double d = iOPerformanceCounter.getMessagesInBytesRate() * 8.0 * 0.001;
                    if (ModuleLimitPublishedStreamBandwidth.this.debugLog) {
                        ModuleLimitPublishedStreamBandwidth.this.logger.info("ModuleLimitPublishedStreamBandwidth.MonitorStream.run '" + MonitorStream.this.stream.getName() + "' BitRate: " + Math.round(Math.floor(d)) + "kbs, MaxBitrate:" + ModuleLimitPublishedStreamBandwidth.this.maxBitrate, "application", "comment");
                    }
                    if (d > (double)ModuleLimitPublishedStreamBandwidth.this.maxBitrate && ModuleLimitPublishedStreamBandwidth.this.maxBitrate > 0) {
                        if (MonitorStream.this.stream.getClient() != null) {
                            ModuleLimitPublishedStreamBandwidth.this.logger.info("ModuleLimitPublishedStreamBandwidth.MonitorStream.run[RTMP] Sent NetStream.Publish.Rejected to " + MonitorStream.this.stream.getClientId() + " stream name: " + MonitorStream.this.stream.getName() + ", BitRate: " + Math.round(Math.floor(d)) + "kbs", "application", "comment");
                            ModuleLimitPublishedStreamBandwidth.sendStreamOnStatusError((IMediaStream)MonitorStream.this.stream, (String)"NetStream.Publish.Rejected", (String)("bitrate too high: " + Math.round(Math.floor(d)) + "kbs"));
                            MonitorStream.this.stream.getClient().setShutdownClient(true);
                        } else if (MonitorStream.this.stream.getRTPStream() != null) {
                            ModuleLimitPublishedStreamBandwidth.this.logger.info("ModuleLimitPublishedStreamBandwidth.MonitorStream.run[RTSP] Shutdown session: " + MonitorStream.this.stream.getRTPStream().getSession() + " stream name: " + MonitorStream.this.stream.getName() + ", BitRate: " + Math.round(Math.floor(d)) + "kbs", "application", "comment");
                            MonitorStream.this.stream.getRTPStream().getRTPContext().shutdownRTPSession(MonitorStream.this.stream.getRTPStream().getSession());
                        }
                    }
                }
            };
            this.mTimer = new Timer();
        }

        public void start() {
            if (this.mTimer == null) {
                this.mTimer = new Timer();
            }
            this.mTimer.scheduleAtFixedRate(this.mTask, new Date(), (long)ModuleLimitPublishedStreamBandwidth.this.interval);
        }

        public void stop() {
            if (this.mTimer != null) {
                this.mTimer.cancel();
                this.mTimer = null;
            }
        }
    }
}

