/*
 * Decompiled with CFR 0.152.
 */
package com.wowza.wms.plugin;

import com.wowza.wms.amf.AMFDataList;
import com.wowza.wms.application.ApplicationInstance;
import com.wowza.wms.application.IApplicationInstance;
import com.wowza.wms.client.IClient;
import com.wowza.wms.httpstreamer.model.IHTTPStreamerSession;
import com.wowza.wms.logging.WMSLogger;
import com.wowza.wms.logging.WMSLoggerFactory;
import com.wowza.wms.module.ModuleBase;
import com.wowza.wms.request.RequestFunction;
import com.wowza.wms.rtp.model.RTPSession;
import com.wowza.wms.rtp.model.RTPUrl;
import com.wowza.wms.stream.IMediaStream;
import com.wowza.wms.stream.MediaStream;
import com.wowza.wms.stream.mediacaster.MediaStreamMediaCasterUtils;
import com.wowza.wms.util.ModuleUtils;
import java.util.HashMap;

public class ModuleLimitStreamViewers
extends ModuleBase {
    public static final String MODULE_NAME = "ModuleLimitStreamViewers";
    public static final String PROP_NAME_PREFIX = "limitStreamViewers";
    public static final int MAXVIEWERS = 200;
    WMSLogger logger = null;
    private IApplicationInstance appInstance;
    private HashMap<String, Integer> streamLimits = new HashMap();
    private int maxStreamViewers = 200;
    private boolean logConnectionCounts = true;
    private boolean logRejections = true;

    public void onAppStart(IApplicationInstance iApplicationInstance) {
        this.logger = WMSLoggerFactory.getLoggerObj((IApplicationInstance)iApplicationInstance);
        this.appInstance = iApplicationInstance;
        this.maxStreamViewers = iApplicationInstance.getProperties().getPropertyInt("maxStreamViewers", 200);
        this.maxStreamViewers = iApplicationInstance.getProperties().getPropertyInt("limitStreamViewersMaxViewers", 200);
        this.logConnectionCounts = iApplicationInstance.getProperties().getPropertyBoolean("limitStreamViewersLogConnectionCounts", this.logConnectionCounts);
        this.logRejections = iApplicationInstance.getProperties().getPropertyBoolean("limitStreamViewersLogRejections", this.logRejections);
        if (this.logger.isDebugEnabled()) {
            this.logConnectionCounts = true;
            this.logRejections = true;
        }
        this.fillStreamLimits();
        this.logger.info("ModuleLimitStreamViewers limit: " + this.maxStreamViewers + " logConnections: " + this.logConnectionCounts + ", logRejections: " + this.logRejections, "application", "comment");
    }

    public void play(IClient iClient, RequestFunction requestFunction, AMFDataList aMFDataList) {
        int n;
        String string = aMFDataList.getString(3);
        int n2 = this.getViewerCounts(string = ((ApplicationInstance)this.appInstance).internalResolvePlayAlias(string, iClient), iClient);
        if (n2 < (n = this.getStreamLimit(string))) {
            this.invokePrevious(iClient, requestFunction, aMFDataList);
        } else {
            IMediaStream iMediaStream = ModuleLimitStreamViewers.getStream((IClient)iClient, (RequestFunction)requestFunction);
            if (iMediaStream != null) {
                String string2 = "NetStream.Play.Failed";
                String string3 = "ModuleLimitStreamViewers: Over viewer limit[" + n + "]";
                ModuleLimitStreamViewers.sendStreamOnStatusError((IMediaStream)iMediaStream, (String)string2, (String)string3);
                if (this.logRejections) {
                    this.logger.info("ModuleLimitStreamViewersModuleLimitViewers: Over viewer limit[" + n + " streamName: " + string + "]", "application", "comment");
                }
            }
        }
    }

    public void onHTTPSessionCreate(IHTTPStreamerSession iHTTPStreamerSession) {
        int n;
        String string = iHTTPStreamerSession.getStreamName();
        int n2 = this.getViewerCounts(string);
        if (n2 > (n = this.getStreamLimit(string))) {
            iHTTPStreamerSession.rejectSession();
            if (this.logRejections) {
                this.logger.info("ModuleLimitStreamViewers: Over viewer limit[" + n + " streamName: " + string + "]", "application", "comment");
            }
        }
    }

    public void onRTPSessionCreate(RTPSession rTPSession) {
        int n;
        String string = rTPSession.getUri();
        RTPUrl rTPUrl = new RTPUrl(string);
        String string2 = rTPUrl.getStreamName();
        int n2 = this.getViewerCounts(string2 = ((ApplicationInstance)this.appInstance).internalResolvePlayAlias(string2, rTPSession));
        if (n2 >= (n = this.getStreamLimit(string2))) {
            rTPSession.rejectSession();
            if (this.logRejections) {
                this.logger.info("ModuleLimitStreamViewers: Over viewer limit[" + n + " streamName: " + string2 + "]", "application", "comment");
            }
        }
    }

    private void fillStreamLimits() {
        String[] stringArray;
        String string = this.appInstance.getProperties().getPropertyStr("limitStreamViewersByList", null);
        if (string != null && (stringArray = string.split(",")).length > 0) {
            for (int i = 0; i < stringArray.length; ++i) {
                String[] stringArray2 = stringArray[i].split("=");
                if (stringArray2.length != 2) continue;
                String string2 = stringArray2[0];
                try {
                    int n = Integer.parseInt(stringArray2[1]);
                    this.streamLimits.put(string2, new Integer(n));
                    this.logger.info("ModuleLimitStreamViewers Limits: " + string2 + " = " + n);
                    continue;
                }
                catch (NumberFormatException numberFormatException) {
                    this.logger.warn("ModuleLimitStreamViewers limit not set for stream. NumberFormatException: " + stringArray[i]);
                }
            }
        }
    }

    private int getStreamLimit(String string) {
        if (this.streamLimits.containsKey(string = this.decodeStreamName(string))) {
            return this.streamLimits.get(string);
        }
        return this.maxStreamViewers;
    }

    private String decodeStreamName(String string) {
        String string2 = MediaStream.BASE_STREAM_EXT;
        if (string != null) {
            String[] stringArray = ModuleUtils.decodeStreamExtension((String)string, (String)string2);
            string = stringArray[0];
            string2 = stringArray[1];
            boolean bl = string.indexOf("://") >= 0;
            int n = string.indexOf("?");
            if (!bl && n >= 0) {
                string = string.substring(0, n);
            }
        }
        return string;
    }

    private int getViewerCounts(String string) {
        return this.getViewerCounts(string, null);
    }

    private synchronized int getViewerCounts(String string, IClient iClient) {
        int n = 0;
        int n2 = 0;
        int n3 = 0;
        int n4 = 0;
        if ((string = this.decodeStreamName(string)) != null) {
            n2 += this.appInstance.getPlayStreamCount(string);
            n3 += this.appInstance.getHTTPStreamerSessionCount(string);
            n4 += this.appInstance.getRTPSessionCount(string);
            String string2 = MediaStreamMediaCasterUtils.mapMediaCasterName((IApplicationInstance)this.appInstance, (IClient)iClient, (String)string);
            if (!string2.equals(string)) {
                if (this.logConnectionCounts) {
                    this.logger.info("ModuleLimitStreamViewers.getViewerCounts matching mediaCaster name: " + string2, "application", "comment");
                }
                n2 += this.appInstance.getPlayStreamCount(string2);
                n3 += this.appInstance.getHTTPStreamerSessionCount(string2);
                n4 += this.appInstance.getRTPSessionCount(string2);
            }
            n = n2 + n3 + n4;
            if (this.logConnectionCounts) {
                this.logger.info("ModuleLimitStreamViewers.getViewerCounts streamName: " + string + " total:" + n + " rtmp: " + n2 + " http: " + n3 + " rtp: " + n4, "application", "comment");
            }
        }
        return n;
    }
}

