/*
 * Decompiled with CFR 0.152.
 */
package com.wowza.wms.plugin;

import com.wowza.util.StringUtils;
import com.wowza.wms.application.WMSProperties;
import com.wowza.wms.logging.WMSLoggerFactory;
import com.wowza.wms.server.IServer;
import com.wowza.wms.server.IServerNotify2;
import com.wowza.wms.vhost.IVHost;
import com.wowza.wms.vhost.VHostSingleton;

public class LoadAndLockAppInstances
implements IServerNotify2 {
    public static final String CLASS_NAME = "LoadAndLockAppInstances";
    public static final String PROP_NAME_PREFIX = "loadAndLock";
    private String vhostName = "_defaultVHost_";
    private String appNames = "";

    public void onServerConfigLoaded(IServer iServer) {
    }

    public void onServerCreate(IServer iServer) {
    }

    public void onServerInit(IServer iServer) {
        WMSLoggerFactory.getLogger(null).info("LoadAndLockAppInstances.onServerInit");
        WMSProperties wMSProperties = iServer.getProperties();
        this.vhostName = wMSProperties.getPropertyStr("loadAndLockVHost", this.vhostName);
        this.appNames = wMSProperties.getPropertyStr("loadAndLockApplications", this.appNames);
        if (!StringUtils.isEmpty((String)this.appNames)) {
            String[] stringArray;
            for (String string : stringArray = this.appNames.split(",")) {
                String[] stringArray2 = string.trim().split("/");
                String string2 = stringArray2[0].trim();
                String string3 = "_definst_";
                if (stringArray2.length > 1) {
                    string3 = stringArray2[1].trim();
                }
                if (StringUtils.isEmpty((String)this.vhostName) || StringUtils.isEmpty((String)string2) || StringUtils.isEmpty((String)string3)) continue;
                this.loadAndLockAppInstance(this.vhostName, string2, string3);
            }
        }
    }

    public void onServerShutdownStart(IServer iServer) {
    }

    public void onServerShutdownComplete(IServer iServer) {
    }

    private void loadAndLockAppInstance(String string, String string2, String string3) {
        IVHost iVHost = VHostSingleton.getInstance((String)string);
        if (iVHost != null) {
            if (iVHost.startApplicationInstance(string2, string3)) {
                iVHost.getApplication(string2).getAppInstance(string3).setApplicationTimeout(0);
            } else {
                WMSLoggerFactory.getLoggerObj((IVHost)iVHost).warn("LoadAndLockAppInstances.loadAndLockAppInstance: Application folder ([install-location]/applications/" + string2 + ") is missing", "vhost", "comment");
            }
        }
    }
}

