/*
 * Decompiled with CFR 0.152.
 */
package com.wowza.wms.plugin;

import com.wowza.io.DirectRandomAccessReader;
import com.wowza.io.IRandomAccessReader;
import com.wowza.io.ITrackRandomAccessReaderPerformance;
import com.wowza.util.IOPerformanceCounter;
import com.wowza.wms.application.IApplicationInstance;
import com.wowza.wms.logging.WMSLoggerFactory;
import com.wowza.wms.stream.IMediaStream;
import java.io.File;
import java.io.IOException;

public class RandomAccessReaderMediaCacheLocalContent
implements IRandomAccessReader,
ITrackRandomAccessReaderPerformance {
    public static final String CLASS_NAME = "RandomAccessReaderMediaCacheLocalContent";
    public static final String PROP_NAME_PREFIX = "mediaCacheLocalContent";
    private IRandomAccessReader randomReader = null;
    private String mediacacheRandomAccessReaderClassName = "com.wowza.wms.mediacache.impl.MediaCacheRandomAccessReaderVODEdge";

    private IRandomAccessReader getMediaCacheRandomAccessReader(IApplicationInstance iApplicationInstance) {
        this.mediacacheRandomAccessReaderClassName = iApplicationInstance.getProperties().getPropertyStr("mediaCacheLocalContentRandomAccessReaderClassName", this.mediacacheRandomAccessReaderClassName);
        try {
            Class<?> clazz = Class.forName(this.mediacacheRandomAccessReaderClassName);
            if (clazz != null) {
                return (IRandomAccessReader)clazz.newInstance();
            }
        }
        catch (Exception exception) {
            WMSLoggerFactory.getLoggerObj((IApplicationInstance)iApplicationInstance).error("RandomAccessReaderMediaCacheLocalContent.init() Cannot load mediacacheRandomAccessReaderClass :" + this.mediacacheRandomAccessReaderClassName);
        }
        return null;
    }

    public void init(IApplicationInstance iApplicationInstance, IMediaStream iMediaStream, String string, String object, String string2) {
        File file = iMediaStream.getStreamFileForRead((String)object, string2, iMediaStream.getQueryStr());
        if (file.exists()) {
            this.randomReader = new DirectRandomAccessReader();
        } else {
            String string3 = iApplicationInstance.decodeStorageDir(iApplicationInstance.getProperties().getPropertyStr("mediaCacheLocalContentMediaCachePath", ""));
            if (!((String)object).startsWith(string3)) {
                object = (String)(string3.endsWith("/") ? string3 : string3 + "/") + (String)object;
            }
            this.randomReader = this.getMediaCacheRandomAccessReader(iApplicationInstance);
        }
        this.randomReader.init(iApplicationInstance, iMediaStream, string, (String)object, string2);
    }

    public void setStreamIOTracker(IOPerformanceCounter iOPerformanceCounter) {
        if (this.randomReader instanceof ITrackRandomAccessReaderPerformance) {
            ((ITrackRandomAccessReaderPerformance)this.randomReader).setStreamIOTracker(iOPerformanceCounter);
        }
    }

    public void setClientIOTracker(IOPerformanceCounter iOPerformanceCounter) {
        if (this.randomReader instanceof ITrackRandomAccessReaderPerformance) {
            ((ITrackRandomAccessReaderPerformance)this.randomReader).setClientIOTracker(iOPerformanceCounter);
        }
    }

    public void open() throws IOException {
        this.randomReader.open();
    }

    public void close() throws IOException {
        this.randomReader.close();
    }

    public boolean isOpen() {
        return this.randomReader.isOpen();
    }

    public long getFilePointer() {
        return this.randomReader.getFilePointer();
    }

    public void seek(long l) {
        this.randomReader.seek(l);
    }

    public int read(byte[] byArray, int n, int n2) {
        return this.randomReader.read(byArray, n, n2);
    }

    public int getDirecton() {
        return this.randomReader.getDirecton();
    }

    public void setDirecton(int n) {
        this.randomReader.setDirecton(n);
    }

    public String getBasePath() {
        return this.randomReader.getBasePath();
    }

    public String getMediaName() {
        return this.randomReader.getMediaName();
    }

    public String getMediaExtension() {
        return this.randomReader.getMediaExtension();
    }

    public boolean exists() {
        return this.randomReader.exists();
    }

    public long lastModified() {
        return this.randomReader.lastModified();
    }

    public long length() {
        return this.randomReader.length();
    }

    public String getPath() {
        return this.randomReader.getPath();
    }
}

